/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Messages;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.ActiveAgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentHeartbeatMonitor;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentRegistrationListener;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentListImpl;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.AgentConstants;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.ISANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.AuthorizationException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.Event;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogTrace;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.RemoveActiveAgentException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.event.data.SANEventExceptionHandler;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.OID;

public final class SANDiskMgrHostService
implements ISANDiskMgrHostService,
IService,
ICliDispatcher,
ICallback {
    static final String className = SANDiskMgrHostService.class.getName();
    static final String MESSAGE_NAME = "aperi.logger.message.HostMgr";
    static final String TRACE_NAME = "aperi.logger.trace.HostMgr";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Messages";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.Texts";
    private ResourceBundle rb = null;
    protected static Factory factory = null;
    private AgentHeartbeatMonitor _agentHeartbeatThread = null;
    private Map hostMap = null;
    private AgentRegistrationListener agent_reg = null;
    public static long sysUpTime = System.currentTimeMillis();
    static LogTrace logs = null;
    static LogWrapper trace = null;
    static LogWrapper messages = null;
    static final String MINIMUM_HOSTQUERY_VERSION = "1.1.0";
    static final String MINIMUM_HOSTSERVICE_VERSION = "1.1.0";
    static final String MINIMUM_SANMANAGER_VERSION = "1.1.0";
    static final String MINIMUM_SANDBPARMS_VERSION = "1.1.0";
    private Status status = new Status(5, 3);
    private OID oid = null;
    private SnmpTrap myTrap = null;
    private String message = null;
    private String sev = null;
    private String description = null;
    private String messageID = null;
    private boolean _healthy = true;
    private static ResourceBundle resources = null;
    private TopicSubscriber _agentRegistrationSubscriber = null;

    public String dispatch(String method, String[] args) {
        return CliDispatcher.dispatch((Object)this, (String)method, (String[])args);
    }

    public SANDiskMgrHostService() {
        Locale loc = Locale.getDefault();
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME, loc);
    }

    public boolean startup() {
        block7: {
            String methodName = "startup";
            if (trace.isLogging()) {
                trace.entry((Object)this, "startup");
            }
            try {
                this.status.setRunStatus(9);
                IConfigService dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                String heartbeat_interval = dbp.getProperty("hostPollingInterval", "user");
                factory = FactoryFactory.createFactory((int)2, null);
                factory.setExceptionListener((ExceptionListener)new SANEventExceptionHandler());
                this.hostMap = TdmAgentListImpl.bldTdmHostMap();
                this.agent_reg = new AgentRegistrationListener(this.hostMap);
                this._agentHeartbeatThread = new AgentHeartbeatMonitor(heartbeat_interval, this.hostMap);
                this._agentHeartbeatThread.setDaemon(true);
                this._agentHeartbeatThread.start();
                String ownerHostName = dbp.getProperty("manager.loc", "setup");
                String ownerHostPort = dbp.getProperty("manager.port", "setup");
                dbp.register("hostPollingInterval", "user", ownerHostName + ":" + ownerHostPort, "SANHostMgr");
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Registered with " + ownerHostName + "  " + ownerHostPort + "  " + "hostPollingInterval" + "  " + "user" + "  " + "SANHostMgr");
                this.description = "Fabric Manager SAN Disk Manager Host Service has started.";
                this.messageID = SANDiskMgrHostService.getMessageId("BTSserviceStartup");
                this.oid = new OID("1.3.6.1.4.1.2.6.173.5.1");
                this.myTrap = Event.createServiceSnmpTrap((long)sysUpTime, (OID)this.oid, (int)1, (String)this.description, (String)this.messageID, (String)"Common", (LogTrace)logs);
                if (this.myTrap != null) {
                    Event.fireSNMPEvent((String)"publisherID", (String)"org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", (SnmpTrap)this.myTrap, (LogTrace)logs);
                }
                this.message = this.rb.getString("startup");
                this.sev = "HARMLESS";
                if (trace.isLogging()) {
                    trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "startup", "TEC Message: " + this.message);
                }
                Event.fireTECEvent((String)"publisherID", (String)"org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", (String)"Common", (String)this.getName(), (String)this.messageID, (String)this.message, (String)this.sev, (LogTrace)logs);
                this.fireDiskMgrHostServiceEvent("STARTED");
                messages.message(IRecordType.TYPE_INFO, (Object)this, "startup", "BTSserviceStartup", (Object)this.getName());
                this.getMonitorThreadStatus();
                if (trace.isLogging()) {
                    trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", this.getName() + " started ...");
                }
            }
            catch (Exception e) {
                if (!trace.isLogging()) break block7;
                trace.exception((Object)this, "startup", (Throwable)e);
            }
        }
        this.status.setRunStatus(8);
        if (trace.isLogging()) {
            trace.exit((Object)this, "startup");
        }
        return true;
    }

    public boolean shutdown() {
        block10: {
            block9: {
                String methodName = "shutdown";
                if (trace.isLogging()) {
                    trace.entry((Object)this, "shutdown");
                }
                IConfigService dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
                String ownerHostName = dbp.getProperty("manager.loc", "setup");
                String ownerHostPort = dbp.getProperty("manager.port", "setup");
                dbp.deRegister("hostPollingInterval", "user", ownerHostName + ":" + ownerHostPort, "SANHostMgr");
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "shutdown", "Deregistered hostPollingInterval property change");
                this.status.setRunStatus(11);
                this.getMonitorThreadStatus();
                this._agentHeartbeatThread.safeStop();
                try {
                    this._agentHeartbeatThread.join();
                }
                catch (InterruptedException e) {
                    messages.exception((Object)this, "shutdown", (Throwable)e);
                    if (!trace.isLogging()) break block9;
                    trace.exception((Object)this, "shutdown", (Throwable)e);
                }
            }
            this.description = "Fabric Manager SAN Disk Manager Host Service is shutting down.";
            this.messageID = SANDiskMgrHostService.getMessageId("BTSserviceShutdown");
            this.oid = new OID("1.3.6.1.4.1.2.6.173.5.2");
            this.myTrap = Event.createServiceSnmpTrap((long)sysUpTime, (OID)this.oid, (int)2, (String)this.description, (String)this.messageID, (String)"Common", (LogTrace)logs);
            if (this.myTrap != null) {
                Event.fireSNMPEvent((String)"publisherID", (String)"org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", (SnmpTrap)this.myTrap, (LogTrace)logs);
            }
            this.message = this.rb.getString("shutdown");
            if (trace.isLogging()) {
                trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "shutdown", "TEC Message: " + this.message);
            }
            this.sev = "HARMLESS";
            Event.fireTECEvent((String)"publisherID", (String)"org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename", (String)"Common", (String)this.getName(), (String)this.messageID, (String)this.message, (String)this.sev, (LogTrace)logs);
            this.fireDiskMgrHostServiceEvent("SHUTDOWN");
            try {
                if (factory != null) {
                    factory.close();
                }
            }
            catch (JMSException e) {
                messages.exception((Object)className, "shutdown", (Throwable)e);
                if (!trace.isLogging()) break block10;
                trace.exception((Object)className, "shutdown", (Throwable)e);
            }
        }
        messages.message(IRecordType.TYPE_INFO, (Object)this, "shutdown", "BTSserviceShutdown", (Object)this.getName());
        this.status.setRunStatus(10);
        if (trace.isLogging()) {
            trace.exit((Object)this, "shutdown");
        }
        return true;
    }

    public String getName() {
        String str = "SANHostMgr";
        return str;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SANHostMgr_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SANHostMgr_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        return "Maintains the list of managed hosts";
    }

    public boolean isCompatibleVersion(String version) {
        return true;
    }

    public boolean isAlive() {
        return this._healthy;
    }

    public void setPrimary(Object resource) {
    }

    static ISANDiskMgrHostService getSANDiskMgrHostService() {
        return (ISANDiskMgrHostService)MonitorActivator._serviceHelper.bindLocal("SANHostMgr");
    }

    static Factory getFactory() {
        return factory;
    }

    protected static String getMessageId(String messageKey) {
        int blank = 32;
        Messages m = new Messages();
        String messageText = (String)m.handleGetObject(messageKey) + ' ';
        return messageText.substring(0, messageText.indexOf(32));
    }

    static String getString(String messageID, Object[] msgArgs) {
        if (resources == null) {
            Locale locale = Locale.getDefault();
            resources = ResourceBundle.getBundle(BUNDLENAME, locale);
        }
        String msgPattern = resources.getString(messageID);
        MessageFormat msgFmt = new MessageFormat(msgPattern);
        String msg = msgFmt.format(msgArgs);
        return msg;
    }

    public synchronized void propCallback(String name, String group, String value) {
        String methodName = "propCallback";
        Object interval = null;
        if (trace.isLogging()) {
            trace.entry((Object)IRecordType.TYPE_ENTRY, className, (Object)"propCallback", (Object)("name=" + name + ", group=" + group + ", value=" + value));
        }
        if (group.equals("user") && name.equals("hostPollingInterval")) {
            this._agentHeartbeatThread.setHeartbeatInterval(value);
        }
        if (trace.isLogging()) {
            trace.exit((Object)this, "propCallback");
        }
    }

    public void agentHeartbeat(HostQueryInfo hqinfo) {
        this.agent_reg.agentRegistrationHeartbeat(hqinfo);
    }

    public String getMonitorThreadStatus() {
        String methodName = "monitorThreadStatus";
        String msg = " ";
        try {
            boolean status = false;
            boolean interrupted_status = false;
            msg = msg + this._agentHeartbeatThread.toString();
            status = this._agentHeartbeatThread.isAlive();
            msg = status ? msg + " alive = true " : msg + " alive = false ";
            interrupted_status = AgentHeartbeatMonitor.interrupted();
            msg = interrupted_status ? msg + " interrupted = true " : msg + " interrupted = false ";
        }
        catch (Exception e) {
            messages.exception((Object)this, "monitorThreadStatus", (Throwable)e);
            if (trace.isLogging()) {
                trace.exception((Object)this, "monitorThreadStatus", (Throwable)e);
            }
            msg = msg + " Error: " + e.toString();
        }
        trace.text(IRecordType.TYPE_ERROR, (Object)this, "monitorThreadStatus", msg);
        return msg;
    }

    public String GetAgent(GUID guid, int port) {
        try {
            Agent h = this.getAgent(guid, port);
            return h.toString();
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public Agent getAgent(GUID guid, int port) throws TdmException {
        String methodName = "getAgent";
        try {
            return AgentBuilder.getHost(guid, port);
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgent", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgent", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgent", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgent", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetAgentList() {
        try {
            Agent[] hostList = this.getAgentList();
            String hosts = "";
            for (int i = 0; i < hostList.length; ++i) {
                hosts = hosts + hostList[i].agentName + hostList[i].getUniqueAgentName() + "\n";
            }
            return hosts;
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public Agent[] getAgentList() throws TdmException {
        String methodName = "getAgentList";
        try {
            return AgentListImpl.getHostList();
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgentList", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgentList", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getAgentList", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getAgentList", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetActiveAgentList() {
        try {
            Agent[] hostList = this.getActiveAgentList();
            String hosts = "";
            for (int i = 0; i < hostList.length; ++i) {
                hosts = hosts + hostList[i].toString() + "\n";
            }
            return hosts;
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public Agent[] getActiveAgentList() throws TdmException {
        String methodName = "getActiveAgentList";
        try {
            return ActiveAgentListImpl.getActiveHostList();
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getActiveAgentList", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getActiveAgentList", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getActiveAgentList", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getActiveAgentList", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetTdmAgent(GUID guid, int port) {
        try {
            TdmAgent h = this.getTdmAgent(guid, port);
            return h.toString();
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public TdmAgent getTdmAgent(GUID guid, int port) throws TdmException {
        String methodName = "getTdmAgent";
        try {
            return TdmAgentBuilder.getTdmHost(guid, port);
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgent", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgent", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgent", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgent", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetTdmAgentList() {
        try {
            TdmAgent[] hostList = this.getTdmAgentList();
            String hosts = "";
            for (int i = 0; i < hostList.length; ++i) {
                hosts = hosts + "\n" + hostList[i].agentName + " " + hostList[i].getUniqueAgentName() + " " + hostList[i].status + "\n";
            }
            return hosts;
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public TdmAgent[] getTdmAgentList() throws TdmException {
        String methodName = "getTdmAgentList";
        try {
            return TdmAgentListImpl.getTdmHostList();
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgentList", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgentList", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getTdmAgentList", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getTdmAgentList", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String RemoveInactiveAgent(GUID guid, int port) {
        try {
            this.removeInactiveAgent(guid, port);
            return "Removed " + guid + ":" + port;
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public void removeInactiveAgent(GUID guid, int port) throws TdmException {
        String methodName = "SANDiskMgrHostService:removeInactiveAgent";
        this.hostMap.remove(guid + ":" + port);
        try {
            HostManager.removeInactiveHost(guid, port);
        }
        catch (RemoveActiveAgentException e) {
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)((Object)e));
            }
            throw e;
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:removeInactiveAgent", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:removeInactiveAgent", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:removeInactiveAgent", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetPolicyDomainIDFromAgent(GUID guid, int port) throws TdmException {
        try {
            return new Integer(this.getPolicyDomainIDFromAgent(guid, port)).toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public int getPolicyDomainIDFromAgent(GUID guid, int port) throws TdmException {
        String methodName = "getPolicyDomainIDFromAgent";
        try {
            return HostManager.getPolicyDomainIDFromAgent(guid, port);
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getPolicyDomainIDFromAgent", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getPolicyDomainIDFromAgent", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "getPolicyDomainIDFromAgent", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "getPolicyDomainIDFromAgent", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String GetTdmAgentListInDomain(int id) {
        try {
            TdmAgent[] hostList = this.getTdmAgentListInDomain(id);
            String hosts = "";
            for (int i = 0; i < hostList.length; ++i) {
                hosts = hosts + hostList[i].agentName + " " + hostList[i].getUniqueAgentName() + "\n";
            }
            return hosts;
        }
        catch (TdmException e) {
            return e.toString();
        }
    }

    public TdmAgent[] getTdmAgentListInDomain(int id) throws TdmException {
        String methodName = "SANDiskMgrHostService.getTdmAgentListInDomain";
        try {
            return TdmAgentListImpl.getTdmAgentListInDomain(id);
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService.getTdmAgentListInDomain", (Throwable)e1);
            }
            throw e1;
        }
    }

    public void moveAgentToDomain(GUID guid, int port, int id) throws TdmException {
        String methodName = "SANDiskMgrHostService:moveAgentToDomain";
        try {
            HostManager.moveAgentToDomain(guid, port, id);
        }
        catch (TdmException e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:moveAgentToDomain", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:moveAgentToDomain", (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e1) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "SANDiskMgrHostService:moveAgentToDomain", "Agent_Error", (Object)e1.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "SANDiskMgrHostService:moveAgentToDomain", (Throwable)e1);
            }
            throw e1;
        }
    }

    public String Die() {
        this.die();
        return "OK";
    }

    void die() {
        this._healthy = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAgentMap() throws Exception {
        try {
            String ans = "";
            Set s = this.hostMap.keySet();
            Map map = this.hostMap;
            synchronized (map) {
                for (Object obj : s) {
                    TdmAgent host = (TdmAgent)this.hostMap.get(obj);
                    ans = ans + "\n" + host.agentName + " " + host.getUniqueAgentName() + " " + host.status + "\n";
                }
            }
            return ans;
        }
        catch (Exception e) {
            messages.message(IRecordType.TYPE_ERROR, (Object)this, "listHostMap", "Agent_Error", (Object)e.toString());
            if (trace.isLogging()) {
                trace.exception((Object)this, "listHostMap", (Throwable)e);
            }
            throw e;
        }
    }

    public String SetHeartbeatMonitorInterval(String interval) {
        String methodName = "SetHeartbeatMonitorInterval";
        try {
            IConfigService dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            int status = dbp.setProperty("hostPollingInterval", "user", interval);
            this._agentHeartbeatThread.setHeartbeatInterval(interval);
            if (status == 0) {
                return "OK";
            }
            return "Property NOT saved\n";
        }
        catch (Exception e) {
            messages.exception((Object)this, "SetHeartbeatMonitorInterval", (Throwable)e);
            if (trace.isLogging()) {
                trace.exception((Object)this, "SetHeartbeatMonitorInterval", (Throwable)e);
            }
            return e.toString();
        }
    }

    public String SetAgentHeartbeatInterval(String interval) {
        String methodName = "SetAgentHeartbeatInterval";
        try {
            IConfigService dbp = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            int status = dbp.setProperty("hostQueryPollingInterval", "user", interval);
            if (status == 0) {
                return "OK";
            }
            return "Property NOT saved\n";
        }
        catch (Exception e) {
            messages.exception((Object)this, "SetAgentHeartbeatInterval", (Throwable)e);
            if (trace.isLogging()) {
                trace.exception((Object)this, "SetAgentHeartbeatInterval", (Throwable)e);
            }
            return e.toString();
        }
    }

    static AgentTableReader getHostTableReader() throws AuthorizationException, InterruptedException, SQLException {
        return new AgentTableReader((DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection(), AgentConstants.HOST_TABLE_NAME);
    }

    static AgentTableUpdater getHostTableUpdater() throws AuthorizationException, InterruptedException, SQLException {
        return new AgentTableUpdater((DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection(), AgentConstants.HOST_TABLE_NAME);
    }

    void fireDiskMgrHostServiceEvent(String evtstatus) {
        String methodName = "fireDiskMgrHostServiceEvent";
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    static {
        try {
            logs = new LogTrace(MESSAGE_NAME, BUNDLENAME, TRACE_NAME);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        messages = SANDiskMgrHostService.logs.messages;
        trace = SANDiskMgrHostService.logs.trace;
    }
}

