/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;

class TdmAgentListImpl {
    static final String className = TdmAgentListImpl.class.getName();
    static final int INITIAL_HASHMAP_SIZE = 25;

    TdmAgentListImpl() {
    }

    static Map bldTdmHostMap() {
        TdmAgent[] hostArray;
        Map<String, TdmAgent> hostmap;
        block5: {
            String methodName = "bldTdmHostMap";
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "bldTdmHostMap");
            }
            hostmap = Collections.synchronizedMap(new HashMap(25));
            hostArray = null;
            try {
                hostArray = TdmAgentListImpl.getTdmHostList();
            }
            catch (Exception e) {
                SANDiskMgrHostService.messages.exception((Object)className, "bldTdmHostMap", (Throwable)e);
                if (!SANDiskMgrHostService.trace.isLogging()) break block5;
                SANDiskMgrHostService.trace.exception((Object)className, "bldTdmHostMap", (Throwable)e);
            }
        }
        for (int i = 0; i != hostArray.length; ++i) {
            hostArray[i].status_lstchanged = new Date();
            hostmap.put(hostArray[i].getUniqueAgentName(), hostArray[i]);
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "bldTdmHostMap");
        }
        return hostmap;
    }

    static TdmAgent[] getTdmHostList() throws TdmException {
        String methodName = "getTdmHostList";
        TdmAgent thost = null;
        Vector<TdmAgent> temp = new Vector<TdmAgent>();
        TdmAgent[] thostArray = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getTdmHostList");
        }
        AgentTableReader tableAccess = null;
        DeviceAgent.DeviceAgentCursor hostResults = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            hostResults = tableAccess.listHosts();
            while (hostResults.next()) {
                thost = TdmAgentBuilder.getTdmHost(hostResults, tableAccess);
                temp.add(thost);
            }
            thostArray = new TdmAgent[temp.size()];
            for (int i = 0; i != thostArray.length; ++i) {
                thostArray[i] = (TdmAgent)temp.elementAt(i);
            }
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHostList", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHostList", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (hostResults != null) {
                try {
                    hostResults.close();
                }
                catch (SQLException ignore) {}
            }
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmHostList");
        }
        return thostArray;
    }

    static TdmAgent[] getTdmAgentListInDomain(int domainID) throws TdmException {
        String methodName = "getTdmAgentListInDomain";
        TdmAgent thost = null;
        Vector<TdmAgent> temp = new Vector<TdmAgent>();
        TdmAgent[] thostArray = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getTdmAgentListInDomain");
        }
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            DeviceAgent.DeviceAgentCursor agentResults = tableAccess.listAgentsInDomain(domainID);
            while (agentResults.next()) {
                thost = TdmAgentBuilder.getTdmHost(agentResults, tableAccess);
                temp.add(thost);
            }
            agentResults.close();
            agentResults = null;
            thostArray = new TdmAgent[temp.size()];
            for (int i = 0; i != thostArray.length; ++i) {
                thostArray[i] = (TdmAgent)temp.elementAt(i);
            }
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmAgentListInDomain", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmAgentListInDomain", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmAgentListInDomain", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmAgentListInDomain", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmAgentListInDomain");
        }
        return thostArray;
    }
}

