/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty;
import org.eclipse.aperi.snmp.IConfig;

public class SNMPConfig
implements IConfig {
    private OutbandScannerProperty outbandProp = new OutbandScannerProperty();
    private static Map retryOverride = Collections.synchronizedMap(new HashMap());
    private static Map timeoutOverride = Collections.synchronizedMap(new HashMap());
    private static Map SnmpCommunity = Collections.synchronizedMap(new HashMap());
    private static Map SnmpWriteCommunity = Collections.synchronizedMap(new HashMap());
    public static final int DEFAULT = -1;

    public Map getConfigInfo(String hostname) {
        HashMap<String, String> parms = new HashMap<String, String>();
        String name = (String)SnmpCommunity.get(hostname);
        if (name == null) {
            parms.put("readCommName", new String(OutbandScannerProperty.getSnmpCommunityName()));
        } else {
            parms.put("readCommName", name);
        }
        name = (String)SnmpWriteCommunity.get(hostname);
        if (name == null) {
            parms.put("writeCommName", new String(OutbandScannerProperty.getSnmpWriteCommunityName()));
        } else {
            parms.put("writeCommName", name);
        }
        Integer retries = (Integer)retryOverride.get(hostname);
        if (retries == null) {
            parms.put("retries", new Integer(this.outbandProp.getSnmpRetryCount()).toString());
        } else {
            parms.put("retries", retries.toString());
        }
        Integer timeout = (Integer)timeoutOverride.get(hostname);
        if (timeout == null) {
            parms.put("timeout", new Integer(this.outbandProp.getSnmpInitialTimeout()).toString());
        } else {
            parms.put("timeout", timeout.toString());
        }
        return parms;
    }

    public static void setRetries(String hostname, int retries) {
        if (retries == -1) {
            retryOverride.remove(hostname);
        } else {
            retryOverride.put(hostname, new Integer(retries));
        }
    }

    public static void setTimeout(String hostname, int timeout) {
        if (timeout == -1) {
            timeoutOverride.remove(hostname);
        } else {
            timeoutOverride.put(hostname, new Integer(timeout));
        }
    }

    public void setSnmpCommunityName(String hostname, String community) {
        if (SnmpCommunity.get(hostname) != null) {
            SnmpCommunity.remove(hostname);
        }
        SnmpCommunity.put(hostname, community);
    }

    public void setSnmpWriteCommunityName(String hostname, String writeCommunity) {
        if (SnmpWriteCommunity.get(hostname) != null) {
            SnmpWriteCommunity.remove(hostname);
        }
        SnmpWriteCommunity.put(hostname, writeCommunity);
    }
}

