/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.tsanm;

import org.eclipse.aperi.Router;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class InbandScanner
extends Thread {
    private Thread thread = null;
    private boolean shutdown = false;
    public static String className = InbandScanner.class.getName();
    public static String queueName = "Inband Scanner";
    public static final String MESSAGE_NAME = "aperi.logger.message.InbandScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.InbandScanner";
    public static String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
    public static final String TopologyScanner = "Topology";
    public static final String AttributeScanner = "AttributePEOnly";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;

    public InbandScanner() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    public void run() {
        boolean trace = false;
        String methodName = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            block21: {
                org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response;
                if (traceLogger != null && traceLogger.isLogging()) {
                    trace = true;
                }
                if (Configuration.debug && trace) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, queueName + ": waiting for a job.");
                }
                JobInfo job = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (job == null) {
                    if (!trace) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, queueName + ":Error - got a NULL job from the queue");
                    continue;
                }
                String scannerName = (String)job.getRequest().getData();
                String agent = job.getTarget()[0];
                String agentVersion = null;
                if (job.getTarget().length > 1) {
                    agentVersion = job.getTarget()[1];
                }
                ILogger jobLogger = null;
                Request request = Router.getRouter().getRequest(job.getDiscoverRequest());
                if (request != null) {
                    jobLogger = request.getJobLogger();
                }
                try {
                    IScanner scanner = (IScanner)ConnectorClient.getService((String)job.getTarget()[0], IScanner.class, (String)"SANAgentScanner");
                    if (jobLogger != null) {
                        jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "InbandScanner_invoke", (Object[])new String[]{scannerName, job.getTarget()[0]});
                    }
                    if (trace) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "about to invoke the scan on scanner= " + scannerName + " and Target=  " + job.getTarget()[0]);
                    }
                    if ((response = scanner.invoke(scannerName, job.getTarget()[0], "MibQueryEngine")).getHeader() == null) {
                        Header hdr = new Header();
                        response.setHeader(hdr);
                    }
                    response.getHeader().setScannerName(scannerName);
                    response.getHeader().setAgentAddress(job.getTarget()[0]);
                    response.getHeader().setScannerId(job.getRequestId());
                    String option = response.getHeader().getType();
                    if (option == null || option.length() == 0) {
                        if (scannerName.equalsIgnoreCase(AttributeScanner)) {
                            response.getHeader().setType("PE");
                        } else {
                            response.getHeader().setType("");
                        }
                    }
                    if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                        job.setResponse((Response)new ObjectResponse((Object)response, job));
                    }
                    job.setReturnCode(response.getReturnCode());
                    job.complete(response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK);
                    if (jobLogger != null) {
                        if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                            jobLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "InbandScanner_Successful", (Object)scannerName, (Object)job.getTarget()[0]);
                        } else {
                            jobLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandScanner_Failed", (Object[])new String[]{scannerName, job.getTarget()[0], new Integer(response.getReturnCode()).toString()});
                        }
                    }
                }
                catch (Exception e) {
                    response = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_ERROR, "Query Engine Detected Error:" + e);
                    job.setReturnCode(100);
                    job.complete(false);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandScanHandler_invokeScannerFailure", (Object)scannerName, (Object)job.getTarget()[0]);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (jobLogger != null) {
                        jobLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandScanHandler_UnknownHostException", (Object)scannerName, (Object)job.getTarget()[0]);
                        jobLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    }
                    if (trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    response = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_ERROR, "Query Engine Detected Error (throwable):" + t);
                    job.setReturnCode(100);
                    job.complete(false);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandScanHandler_invokeScannerFailure", (Object)scannerName, (Object)job.getTarget()[0]);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                    if (!trace) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
            }
            if (!Configuration.debug || !trace) continue;
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, queueName + ": finishing job.");
        }
    }

    public void shutdown() {
        String methodName;
        block5: {
            methodName = "shutdown";
            this.shutdown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (traceLogger == null || !traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

