/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.util.ArrayList;
import org.eclipse.aperi.fabric.FabricManagerService;

class DiscoverMonitor
implements Runnable {
    private static DiscoverMonitor discoverMonitor;
    private static Thread runner;
    private ArrayList<String> jobsToMonitor = new ArrayList();
    private boolean shutdown = false;

    private DiscoverMonitor() {
    }

    public static DiscoverMonitor getDiscoverMonitor() {
        if (discoverMonitor == null) {
            discoverMonitor = new DiscoverMonitor();
        }
        return discoverMonitor;
    }

    public synchronized void monitor(String processId) {
        if (this.shutdown) {
            return;
        }
        this.jobsToMonitor.add(processId);
        if (runner == null) {
            runner = new Thread(this);
            runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.jobsToMonitor.isEmpty() && !this.shutdown) {
            String processId = null;
            DiscoverMonitor discoverMonitor = this;
            synchronized (discoverMonitor) {
                processId = this.jobsToMonitor.remove(0);
            }
            if (processId == null) continue;
            FabricManagerService.getDiscoverServiceProxy().waitTilComplete(processId);
        }
        runner = null;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    static {
        runner = null;
    }
}

