/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;

class DiscoverSNMPAgents
extends DiscoverProcess {
    private static String className = DiscoverSNMPAgents.class.getName();
    private static ISNMPAgentManager snmpServiceProxy = null;

    public DiscoverSNMPAgents() {
        super("Discover SNMP Agents", false, new String[]{"IPADDRESS", "SNMP Community", "USERID", "PASSWORD"}, new String[]{String[].class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String methodName = "process";
        ILogger jobLogger = discoverRequest.getJobLogger();
        snmpServiceProxy = DiscoverSNMPAgents.getSNMPServiceProxy();
        String[] ipAddress = (String[])DiscoverSNMPAgents.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
        if (ipAddress.length > 0) {
            String[] agents;
            String snmpCommunity = (String)DiscoverSNMPAgents.getParameter((Map)parameters, (String)"SNMP Community", (String)String.class.getName());
            String userid = (String)DiscoverSNMPAgents.getParameter((Map)parameters, (String)"USERID", (String)String.class.getName());
            String password = (String)DiscoverSNMPAgents.getParameter((Map)parameters, (String)"PASSWORD", (String)String.class.getName());
            if (jobLogger != null) {
                for (int i = 0; i < ipAddress.length; ++i) {
                    String[] addresses = new String[3];
                    StringTokenizer st = new StringTokenizer(ipAddress[i].trim(), ".");
                    int count = 0;
                    while (st.hasMoreTokens() && count < 3) {
                        addresses[count++] = st.nextToken();
                    }
                    if (count != 3) continue;
                    String prefix = addresses[0] + '.' + addresses[1] + '.' + addresses[2] + '.';
                    jobLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "DiscoverSNMPAgents_startingScan", (Object[])new String[]{prefix + "0", prefix + "255"});
                }
            }
            if ((agents = snmpServiceProxy.discoverAgents(ipAddress, snmpCommunity, userid, password)).length > 0) {
                SNMPAgent[] snmpAgents = DiscoverSNMPAgents.getSNMPAgents();
                HashMap<String, SNMPAgent> agentHashmap = new HashMap<String, SNMPAgent>();
                for (int i = 0; i < snmpAgents.length; ++i) {
                    agentHashmap.put(snmpAgents[i].getIpAddress(), snmpAgents[i]);
                }
                ArrayList agentTable = new ArrayList();
                for (int i = 0; i < agents.length; ++i) {
                    SNMPAgent snmpAgent = (SNMPAgent)agentHashmap.get(agents[i]);
                    if (snmpAgent != null) {
                        if (jobLogger == null) continue;
                        jobLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "DiscoverSNMPAgents_foundAgent", (Object)agents[i]);
                        continue;
                    }
                    if (jobLogger == null) break;
                    jobLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "DiscoverSNMPAgents_foundAgentWithoutRecord", (Object)agents[i]);
                    break;
                }
            }
        }
        if (jobLogger != null) {
            jobLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "DiscoverSNMPAgents_startingAgentProbes");
        }
        ArrayList agentList = new ArrayList();
        ArrayList<Integer> agentTypeList = new ArrayList<Integer>();
        agentTypeList.add(new Integer(FabricManagerConstants.SNMPType));
        agentTypeList.add(new Integer(FabricManagerConstants.CIMType));
        Hashtable properties = new Hashtable();
        properties.put("AGENTS", agentList);
        properties.put("AGENT_TYPES", agentTypeList);
        String[] job = Router.getRouter().perform(Discover.probeFabricAgents, properties, new Integer(discoverRequest.getId()).toString());
        Router.getRouter().waitTilComplete(job);
        return new Result(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SNMPAgent[] getSNMPAgents() {
        ArrayList<SNMPAgent> agents = new ArrayList<SNMPAgent>();
        DBConnection connection = ServiceUtils.getConnection();
        IpTarget.IpTargetCursor cursor = null;
        try {
            cursor = IpTarget.getCursor((DBConnection)connection, null, null);
            while (cursor.next()) {
                IpTarget target = cursor.getObject();
                agents.add(new SNMPAgent(target.getIpAddress(), target.getHostName(), target.getReadCommunityName(), target.getUserId(), target.getPassword()));
            }
            connection.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            SNMPAgent[] sNMPAgentArray = new SNMPAgent[]{};
            return sNMPAgentArray;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return agents.toArray(new SNMPAgent[0]);
    }

    public static ISNMPAgentManager getSNMPServiceProxy() {
        if (snmpServiceProxy == null) {
            snmpServiceProxy = (ISNMPAgentManager)FabricActivator._serviceHelper.bindLocal("SNMPAgentManager");
        }
        return snmpServiceProxy;
    }

    public String getProcessInfoForJobLog(Map parameters) {
        try {
            String[] ipAddress = (String[])DiscoverSNMPAgents.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
            StringBuffer info = new StringBuffer();
            info.append("SNMP");
            for (int i = 0; i < ipAddress.length; ++i) {
                info.append("+" + ipAddress[i]);
            }
            return info.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

