/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Database;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.event.SANEventMessageHandler;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.event.data.SANEventExceptionHandler;
import org.eclipse.aperi.sanmgmt.event.data.SANEventUtil;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.event.interfaces.ISANEventServiceR2;
import org.eclipse.aperi.sanmgmt.event.interfaces.ISANSnmpControlR2;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryCreationFailedException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryInvalidException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.UnknownFactoryTypeException;

public class SANEventService
implements ISANEventServiceR2,
ISANSnmpControlR2,
IService,
Serializable,
ICallback,
MessageListener,
ICliDispatcher {
    private static final long serialVersionUID = 20001130L;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String TRACE_FACTORY_NAME = "aperi.logger.trace.eventFactory";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventService";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventText";
    private ResourceBundle rb = null;
    protected transient ILogger msgLogger = null;
    protected transient ILogger traceLogger = null;
    protected transient ILogger traceFactoryLogger = null;
    static final String className = SANEventService.class.getName();
    private static IConfigService dbParms = null;
    private static Factory factory = null;
    private static Message template = null;
    static String subscriberName = null;
    static TopicSubscriber subscriber;
    static TopicPublisher publisher;
    static SANEventMessageHandler messagePrinter;
    static SANEventExceptionHandler exceptionPrinter;
    private DestinationFactory destFactory = null;
    private static final String NEW_LINE = "\n";
    public static final String COMMA = ",";
    boolean aliveStatus = true;
    private Status status = new Status(5, 9);
    private String description = "Generic service for publishing SNMP traps and TEC events.";
    private static ArrayList entityTypes;
    private static ArrayList eventCategories;
    private static ArrayList eventSeverities;
    private static ArrayList eventTypes;
    private static ArrayList eventActions;
    static final String EVENT_SEVERITY = "EVENT_SEVERITY";
    static final String ENTITY_TYPE = "ENTITY_TYPE";
    static final String UNIQUE_ID = "UNIQUE_ID";
    static final String EVENT_TYPE = "EVENT_TYPE";
    static final String EVENT_CATEGORY = "EVENT_CATEGORY";
    static final String RULE_ID = "RULE_ID";
    static final String EVENT_ACTION = "EVENT_ACTION";
    static final String EVENT_SEVERITY_SHORT = "SEV";
    static final String ENTITY_TYPE_SHORT = "ENT";
    static final String UNIQUE_ID_SHORT = "UID";
    static final String EVENT_TYPE_SHORT = "EVENT_TYPE";
    static final String EVENT_CATEGORY_SHORT = "CAT";
    static final String RULE_ID_SHORT = "RULE";
    static final String EVENT_ACTION_SHORT = "ACT";
    static final String UNSPECIFIED = "unspecified";
    private static HashMap defaultRule1;
    private static HashMap defaultRule2;
    private static HashMap defaultRule3;
    private static HashMap defaultRule4;
    private static HashMap defaultRule5;
    private static HashMap defaultRule6;
    private static HashMap defaultRule7;
    private static HashMap defaultRule8;
    private static HashMap defaultRule9;
    private static HashMap defaultRule10;
    private static HashMap defaultRule11;
    private static HashMap defaultRule12;
    private static HashMap defaultRule13;
    private static HashMap defaultRule14;
    private static HashMap defaultRule15;
    private static HashMap defaultRule16;
    private static HashMap defaultRule17;
    private static HashMap defaultRule18;
    private static HashMap defaultRule19;
    private static HashMap defaultRule20;
    private static HashMap[] defaultFilterRules;

    public static void initStaticVars() {
        dbParms = null;
        factory = null;
        template = null;
        subscriberName = null;
        subscriber = null;
        publisher = null;
        messagePrinter = null;
        exceptionPrinter = null;
        entityTypes = null;
        eventCategories = null;
        eventSeverities = null;
        eventTypes = null;
        eventActions = null;
    }

    public SANEventService() throws IOException, JMSException {
        String methodName = "SANEventService";
        this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEventService");
        }
        this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (this.msgLogger != null) {
            this.msgLogger.setMessageFile(BUNDLENAME);
        }
        this.traceFactoryLogger = LogManagerFactory.getTraceLogger((String)TRACE_FACTORY_NAME);
        dbParms = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        this.destFactory = new DestinationFactory(this.msgLogger, this.traceLogger, dbParms);
        messagePrinter = new SANEventMessageHandler(this.destFactory);
        exceptionPrinter = new SANEventExceptionHandler();
        Locale loc = Locale.getDefault();
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME, loc);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEventService");
        }
    }

    public boolean isAlive() {
        return this.aliveStatus;
    }

    public boolean deleteSnmpAddr(SnmpAddress snmpAddr) {
        return this.destFactory.deleteSnmpAddr(snmpAddr);
    }

    public void forwardEvent(SANEvent event, String publisherID) throws JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("PublisherID", publisherID);
        this.forwardEvent(event, props);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void forwardEvent(SANEvent event, Hashtable templateProperties) throws JMSException {
        String methodName = "forwardEvent";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "forwardEvent", (Object)event);
        }
        try {
            try {
                if (factory == null) {
                    factory = FactoryFactory.createFactory((int)2, null);
                }
                if (template == null) {
                    template = factory.createMessage(null);
                }
                template.clearProperties();
                String key = null;
                String value = null;
                Enumeration keys = templateProperties.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    value = (String)templateProperties.get(key);
                    template.setStringProperty(key, value);
                }
                publisher = factory.createPublisher(event.getClass().getName(), template);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "forwardEvent", "Publisher = " + publisher);
                }
                ObjectMessage msg = factory.createMessage((Serializable)event);
                msg.setJMSPriority(2);
                publisher.publish((Message)msg);
            }
            catch (JMSException e) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)e);
                }
                if (this.traceLogger == null) throw e;
                if (!this.traceLogger.isLogging()) throw e;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)e);
                throw e;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (publisher == null) throw throwable;
                publisher.close();
                throw throwable;
            }
            catch (JMSException jmse) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)jmse);
                }
                if (this.traceLogger == null) throw jmse;
                if (!this.traceLogger.isLogging()) throw jmse;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)jmse);
                throw jmse;
            }
        }
        try {}
        catch (JMSException jmse) {
            if (this.msgLogger != null) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)jmse);
            }
            if (this.traceLogger == null) throw jmse;
            if (!this.traceLogger.isLogging()) throw jmse;
            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)jmse);
            throw jmse;
        }
        if (publisher != null) {
            publisher.close();
        }
        if (this.traceLogger == null) return;
        if (!this.traceLogger.isLogging()) return;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "forwardEvent");
    }

    public ArrayList getAllSnmpAddr() {
        return this.destFactory.getAllSnmpAddr();
    }

    public boolean setSnmpAddr(SnmpAddress snmpAddr) {
        return this.destFactory.setSnmpAddr(snmpAddr);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return "SANEvent";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("MessagingService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("MessagingService_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String methodName = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "shutdown");
        }
        this.status.setRunStatus(11);
        this.destFactory.close();
        messagePrinter.close();
        try {
            subscriber.close();
            factory.close();
        }
        catch (Exception e) {
            if (this.msgLogger != null) {
                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)e);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)e);
            }
        }
        finally {
            this.status.setRunStatus(10);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
            }
        }
        return true;
    }

    public boolean startup() {
        block32: {
            block31: {
                block30: {
                    block29: {
                        String methodName = "startup";
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "startup");
                        }
                        this.status.setRunStatus(9);
                        this.destFactory.init();
                        try {
                            int rc = dbParms.setProperty("SANDomainID", "user", SANEventUtil.getUniqueQualifier());
                            if (rc != 0) {
                                if (this.msgLogger != null) {
                                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "startup", "SANEventMessage_DomainIDNotSaved", (Object)"user.properties");
                                }
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_WARN, (Object)className, "startup", "Unable to save the DomainID (SANDomainID) to the properties file: RC = " + rc);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)e);
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block29;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)e);
                        }
                    }
                    if (factory == null) {
                        try {
                            factory = FactoryFactory.createFactory((int)2, (String)null);
                        }
                        catch (FactoryCreationFailedException fcfe) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fcfe);
                            }
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fcfe);
                            }
                        }
                        catch (UnknownFactoryTypeException ufte) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)ufte);
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block30;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)ufte);
                        }
                    }
                }
                if (this.traceFactoryLogger != null && this.traceFactoryLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "startup", "Created Factory");
                }
                try {
                    factory.setExceptionListener((ExceptionListener)exceptionPrinter);
                }
                catch (FactoryInvalidException fie) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fie);
                    }
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fie);
                    }
                }
                catch (JMSException je) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)je);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block31;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)je);
                }
            }
            subscriberName = SANEventUtil.getUniqueSubscriberId((String)className);
            SANEvent target = new SANEvent();
            try {
                subscriber = factory.createSubscriber(target.getClass().getName(), null, null, (MessageListener)this);
            }
            catch (FactoryInvalidException fie) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fie);
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)fie);
                }
            }
            catch (JMSException je) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)je);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block32;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)je);
            }
        }
        this.status.setRunStatus(8);
        if (this.msgLogger != null) {
            this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "startup", "SANEventService_ready");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "startup");
        }
        return true;
    }

    private Factory getFactory() {
        return factory;
    }

    public void propCallback(String name, String group, String value) {
        this.destFactory.propCallback(name, group, value);
    }

    public void onMessage(Message message) {
        String methodName = "onMessage";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (messagePrinter != null) {
            messagePrinter.onMessage(message);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String dispatch(String methodName, String[] args) {
        String functionName = "dispatch";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)functionName);
        }
        String output = "";
        output = (methodName = methodName.toLowerCase()).equals("insertfilterrule") ? this.insertFilterRule(args) : (methodName.equals("updatefilterrule") ? this.updateFilterRule(args) : (methodName.equals("listfilterrules") ? this.listFilterRules(args) : (methodName.equals("changefilterrulepriority") ? this.changeFilterRulePriority(args) : (methodName.equals("setdefaultfilterrules") ? this.setDefaultFilterRules(args) : (methodName.equals("deletefilterrule") ? this.deleteFilterRule(args) : (methodName.equals("help") ? this.help(args) : this.rb.getString("invalidCmd")))))));
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        if (output.equals("invalid")) {
            return this.rb.getString("invalidCmd");
        }
        return output;
    }

    private String insertFilterRule(String[] args) {
        String methodName = "insertFilterRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
        }
        String result = new String();
        String criteria = new String();
        String value = new String();
        String ruleId = new String();
        HashMap ruleMap = new HashMap(12);
        boolean validCommand = true;
        Database db = new Database("", "", "");
        DBConnection connection = null;
        try {
            connection = db.getConnection();
        }
        catch (SQLException e) {
            result = "invalid";
            return result;
        }
        int i = 0;
        while (i < args.length) {
            value = (criteria = args[i++].toUpperCase()).equals(UNIQUE_ID) ? args[i++] : args[i++].toLowerCase();
            if (criteria.equalsIgnoreCase(RULE_ID) || criteria.equalsIgnoreCase(RULE_ID_SHORT)) {
                ruleId = value;
            }
            if (validCommand = this.addCriteria(ruleMap, criteria, value)) continue;
            result = "invalid";
            result = "invalid";
            return "invalid";
        }
        if (validCommand) {
            validCommand = this.isCommandValid(connection, ruleMap);
            if (!validCommand) {
                result = "invalid";
                return "invalid";
            }
            this.initializeValues(ruleMap);
            try {
                if (this.isRuleInUse(ruleId, connection)) {
                    this.incrementRuleIds(ruleId, connection);
                }
                this.saveRule(ruleMap, connection);
                connection.commit();
            }
            catch (SQLException except) {
                if (this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)except);
                }
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                result = "invalid";
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return result;
    }

    private String updateFilterRule(String[] args) {
        String methodName = "updateFilterRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
        }
        String result = new String();
        String criteria = new String();
        String value = new String();
        String ruleId = new String();
        HashMap ruleMap = new HashMap();
        boolean validCommand = true;
        Database db = new Database("", "", "");
        DBConnection connection = null;
        try {
            connection = db.getConnection();
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            result = "invalid";
            return result;
        }
        int i = 0;
        while (i < args.length) {
            value = (criteria = args[i++].toUpperCase()).equals(UNIQUE_ID) ? args[i++] : args[i++].toLowerCase();
            if (criteria.equalsIgnoreCase(RULE_ID) || criteria.equalsIgnoreCase(RULE_ID_SHORT)) {
                ruleId = value;
            }
            if (validCommand = this.addCriteria(ruleMap, criteria, value)) continue;
            result = "invalid";
            result = "invalid";
            return "invalid";
        }
        if (validCommand) {
            validCommand = this.isCommandValid(connection, ruleMap);
            if (!validCommand) {
                result = "invalid";
                return "invalid";
            }
            this.initializeValues(ruleMap);
            try {
                if (!this.isRuleInUse(ruleId, connection)) {
                    connection.commit();
                    result = "invalid";
                    return "invalid";
                }
                this.updateRule(ruleMap, connection);
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.commit();
                }
                catch (SQLException except) {
                    // empty catch block
                }
                result = "invalid";
                return "invalid";
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return result;
    }

    private String changeFilterRulePriority(String[] args) {
        String methodName = "changeFilterRulePriority";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
        }
        String result = new String("");
        if (args.length != 2) {
            result = "invalid";
            return "invalid";
        }
        String oldRule = args[0];
        String newRule = args[1];
        if (oldRule.equals(newRule)) {
            return result;
        }
        Database db = new Database("", "", "");
        DBConnection connection = null;
        try {
            connection = db.getConnection();
            boolean commandValid = this.isRuleInUse(oldRule, connection);
            if (commandValid) {
                if (this.isRuleInUse(newRule, connection)) {
                    int intOldRule;
                    int intNewRule = Integer.parseInt(newRule);
                    if (intNewRule < (intOldRule = Integer.parseInt(oldRule))) {
                        oldRule = Integer.toString(++intOldRule);
                    }
                    this.incrementRuleIds(newRule, connection);
                }
            } else {
                connection.commit();
                result = "invalid";
                return "invalid";
            }
            this.updateRuleId(oldRule, newRule, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.commit();
            }
            catch (SQLException except) {
                // empty catch block
            }
            result = "invalid";
            return "invalid";
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return result;
    }

    private String deleteFilterRule(String[] args) {
        String result;
        String methodName;
        block8: {
            methodName = "deleteFilterRule";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
            }
            result = new String("");
            String ruleId = args[0].toLowerCase();
            Database db = new Database("", "", "");
            DBConnection connection = null;
            try {
                connection = db.getConnection();
                if (this.isRuleInUse(ruleId, connection)) {
                    this.deleteRule(ruleId, connection);
                    connection.commit();
                } else {
                    connection.commit();
                    result = "invalid";
                }
            }
            catch (SQLException e) {
                if (connection == null) break block8;
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return result;
    }

    private String setDefaultFilterRules(String[] args) {
        String methodName;
        block7: {
            methodName = "setDefaultFilterRules";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
            }
            Database db = new Database("", "", "");
            DBConnection connection = null;
            try {
                connection = db.getConnection();
                this.deleteAllFilterRules(connection);
                for (int i = 0; i < defaultFilterRules.length; ++i) {
                    this.initializeValues(defaultFilterRules[i]);
                    this.saveRule(defaultFilterRules[i], connection);
                }
                connection.commit();
            }
            catch (SQLException e) {
                if (connection == null) break block7;
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        String result = new String("");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return result;
    }

    private String listFilterRules(String[] args) {
        String output;
        String methodName;
        block13: {
            methodName = "listFilterRules";
            DBResultSet resultSet = null;
            String sev = "";
            String entityType = "";
            String uid = "";
            String eventType = "";
            String category = "";
            int intRuleId = 0;
            String ruleId = "";
            String action = "";
            output = "";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
            }
            Database db = new Database("", "", "");
            DBConnection connection = null;
            try {
                connection = db.getConnection();
                resultSet = this.listRules(connection);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        sev = resultSet.getString(EVENT_SEVERITY);
                        entityType = resultSet.getString(ENTITY_TYPE);
                        uid = resultSet.getString(UNIQUE_ID);
                        eventType = resultSet.getString("EVENT_TYPE");
                        category = resultSet.getString(EVENT_CATEGORY);
                        intRuleId = resultSet.getInt(RULE_ID);
                        ruleId = Integer.toString(intRuleId);
                        action = resultSet.getString(EVENT_ACTION);
                        output = output + NEW_LINE + "Rule_ID: " + ruleId;
                        if (sev != null && !sev.equals(UNSPECIFIED)) {
                            output = output + NEW_LINE + "Event_Severity: " + sev;
                        }
                        if (entityType != null && !entityType.equals(UNSPECIFIED)) {
                            output = output + NEW_LINE + "Entity_Type: " + entityType;
                        }
                        if (uid != null && !uid.equals(UNSPECIFIED)) {
                            output = output + NEW_LINE + "Unique_ID: " + uid;
                        }
                        if (eventType != null && !eventType.equals(UNSPECIFIED)) {
                            output = output + NEW_LINE + "Event_Type: " + eventType;
                        }
                        if (category != null && !category.equals(UNSPECIFIED)) {
                            output = output + NEW_LINE + "Event_Category: " + category;
                        }
                        if (action == null || action.equals(UNSPECIFIED)) continue;
                        output = output + NEW_LINE + "Event_Action: " + action + NEW_LINE;
                    }
                }
                resultSet.close();
            }
            catch (SQLException e) {
                if (connection == null) break block13;
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return output;
    }

    private String help(String[] args) {
        String output;
        String methodName;
        block4: {
            methodName = "help";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
            }
            output = new String();
            try {
                output = this.rb.getString("header1") + NEW_LINE + NEW_LINE + this.rb.getString("header2") + NEW_LINE + NEW_LINE + this.rb.getString("insert") + NEW_LINE + this.rb.getString("update") + NEW_LINE + this.rb.getString("changePri") + NEW_LINE + this.rb.getString("setDefault") + NEW_LINE + this.rb.getString("delete") + NEW_LINE + this.rb.getString("list") + NEW_LINE + this.rb.getString("help") + NEW_LINE + NEW_LINE + this.rb.getString("insertDesc") + this.rb.getString("parms") + this.rb.getString("validParms") + this.rb.getString("optParms") + NEW_LINE + NEW_LINE + this.rb.getString("updateDesc") + this.rb.getString("parms") + this.rb.getString("validParms") + this.rb.getString("optParms") + NEW_LINE + NEW_LINE + this.rb.getString("changePriDesc") + NEW_LINE + NEW_LINE + this.rb.getString("setDefaultDesc") + NEW_LINE + NEW_LINE + this.rb.getString("deleteDesc") + NEW_LINE + NEW_LINE + this.rb.getString("listDesc") + NEW_LINE + NEW_LINE + this.rb.getString("helpDesc");
            }
            catch (Exception e) {
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "dispatch(help)", (Throwable)e);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)methodName);
        }
        return output;
    }

    private boolean addCriteria(HashMap ruleMap, String criteria, String value) {
        boolean validCriteria = true;
        if (criteria.equalsIgnoreCase(EVENT_ACTION) || criteria.equalsIgnoreCase(RULE_ID) || criteria.equalsIgnoreCase(EVENT_CATEGORY) || criteria.equalsIgnoreCase(EVENT_SEVERITY) || criteria.equalsIgnoreCase(ENTITY_TYPE) || criteria.equalsIgnoreCase("EVENT_TYPE") || criteria.equalsIgnoreCase(UNIQUE_ID)) {
            validCriteria = true;
        } else if (criteria.equalsIgnoreCase(EVENT_ACTION_SHORT)) {
            criteria = EVENT_ACTION;
        } else if (criteria.equalsIgnoreCase(RULE_ID_SHORT)) {
            criteria = RULE_ID;
        } else if (criteria.equalsIgnoreCase(EVENT_CATEGORY_SHORT)) {
            criteria = EVENT_CATEGORY;
        } else if (criteria.equalsIgnoreCase(EVENT_SEVERITY_SHORT)) {
            criteria = EVENT_SEVERITY;
        } else if (criteria.equalsIgnoreCase(ENTITY_TYPE_SHORT)) {
            criteria = ENTITY_TYPE;
        } else if (criteria.equalsIgnoreCase("EVENT_TYPE")) {
            criteria = "EVENT_TYPE";
        } else if (criteria.equalsIgnoreCase(UNIQUE_ID_SHORT)) {
            criteria = UNIQUE_ID;
        } else {
            validCriteria = false;
        }
        if (validCriteria) {
            ruleMap.put(criteria, value);
        }
        return validCriteria;
    }

    private void initializeValues(HashMap ruleMap) {
        String parmValue = null;
        parmValue = (String)ruleMap.get(EVENT_SEVERITY);
        if (parmValue == null) {
            parmValue = UNSPECIFIED;
            ruleMap.put(EVENT_SEVERITY, parmValue);
        }
        if ((parmValue = (String)ruleMap.get(EVENT_CATEGORY)) == null) {
            parmValue = UNSPECIFIED;
            ruleMap.put(EVENT_CATEGORY, parmValue);
        }
        if ((parmValue = (String)ruleMap.get("EVENT_TYPE")) == null) {
            parmValue = UNSPECIFIED;
            ruleMap.put("EVENT_TYPE", parmValue);
        }
    }

    private boolean isCommandValid(DBConnection connection, HashMap ruleMap) {
        boolean validCommand = true;
        if (ruleMap.get(EVENT_ACTION) == null || ruleMap.get(EVENT_ACTION).equals("") || ruleMap.get("EVENT_TYPE") == null || ruleMap.get("EVENT_TYPE").equals("") || ruleMap.get(RULE_ID) == null || ruleMap.get(RULE_ID).equals("")) {
            validCommand = false;
            return validCommand;
        }
        if (ruleMap.get(UNIQUE_ID) != null && !ruleMap.get(UNIQUE_ID).equals("") && (ruleMap.get(ENTITY_TYPE) == null || ruleMap.get(ENTITY_TYPE).equals(""))) {
            validCommand = false;
            return validCommand;
        }
        if (ruleMap.get(ENTITY_TYPE) != null && !ruleMap.get(ENTITY_TYPE).equals("")) {
            try {
                String tempEntityType = this.convertEntityTypeToProperCase(connection, (String)ruleMap.get(ENTITY_TYPE));
                ruleMap.put(ENTITY_TYPE, tempEntityType);
            }
            catch (Exception e) {
                validCommand = false;
                return validCommand;
            }
        }
        if (ruleMap.get(EVENT_CATEGORY) != null && !ruleMap.get(EVENT_CATEGORY).equals("")) {
            try {
                String tempEventCategory = this.convertEventCategoryToProperCase(connection, (String)ruleMap.get(EVENT_CATEGORY));
                ruleMap.put(EVENT_CATEGORY, tempEventCategory);
            }
            catch (Exception e) {
                validCommand = false;
                return validCommand;
            }
        }
        if (ruleMap.get(EVENT_SEVERITY) != null && !ruleMap.get(EVENT_SEVERITY).equals("")) {
            try {
                String tempEventSeverity = this.convertEventSeverityToProperCase(connection, (String)ruleMap.get(EVENT_SEVERITY));
                ruleMap.put(EVENT_SEVERITY, tempEventSeverity);
            }
            catch (Exception e) {
                validCommand = false;
                return validCommand;
            }
        }
        if (ruleMap.get(EVENT_ACTION) != null && !ruleMap.get(EVENT_ACTION).equals("")) {
            try {
                String tempEventAction = this.convertEventActionToProperCase(connection, (String)ruleMap.get(EVENT_ACTION));
                ruleMap.put(EVENT_ACTION, tempEventAction);
            }
            catch (Exception e) {
                validCommand = false;
                return validCommand;
            }
        }
        if (ruleMap.get("EVENT_TYPE") != null && !ruleMap.get("EVENT_TYPE").equals("")) {
            try {
                String tempEventType = this.convertEventTypeToProperCase(connection, (String)ruleMap.get("EVENT_TYPE"));
                ruleMap.put("EVENT_TYPE", tempEventType);
            }
            catch (Exception e) {
                validCommand = false;
                return validCommand;
            }
        }
        return validCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRuleInUse(String ruleId, DBConnection connection) throws SQLException {
        String methodName = "isRuleInUse";
        DBResultSet resultSet = null;
        boolean ruleIsInUse = false;
        try {
            String query = new String("select ITSANM.SANM_EVENT_FILTER.RULE_ID as ruleId from ITSANM.SANM_EVENT_FILTER where RULE_ID = ?");
            DBPreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, ruleId);
            resultSet = stmt.executeQuery();
            if (resultSet == null) {
                boolean bl = ruleIsInUse;
                return bl;
            }
            if (resultSet.next()) {
                ruleIsInUse = true;
            }
            resultSet.close();
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (!this.traceLogger.isLogging()) break block19;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        return ruleIsInUse;
    }

    private void saveRule(HashMap ruleMap, DBConnection connection) throws SQLException {
        String methodName = "saveRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "dispatch", (Object)"entered");
        }
        try {
            String sql = new String("INSERT INTO ITSANM.SANM_EVENT_FILTER (EVENT_SEVERITY , ENTITY_TYPE, UNIQUE_ID, EVENT_TYPE, EVENT_ACTION, RULE_ID, EVENT_CATEGORY) VALUES ((select id from ITSANM.SANM_EVENT_SEVERITY WHERE NAME=?), (select id from ITSANM.SANM_DEV_KEYS WHERE NAME=?), (?),  (select id from ITSANM.SANM_EVENT_TYPE WHERE NAME=?), (select id from ITSANM.SANM_EVENT_ACTION WHERE NAME=?),  (?), (select id from ITSANM.SANM_EVENT_CATEGORY WHERE NAME=?))");
            DBPreparedStatement stmt = connection.prepareStatement(sql);
            int rule = Integer.parseInt((String)ruleMap.get(RULE_ID));
            stmt.setString(1, (String)ruleMap.get(EVENT_SEVERITY));
            stmt.setString(2, (String)ruleMap.get(ENTITY_TYPE));
            stmt.setString(3, (String)ruleMap.get(UNIQUE_ID));
            stmt.setString(4, (String)ruleMap.get("EVENT_TYPE"));
            stmt.setString(5, (String)ruleMap.get(EVENT_ACTION));
            stmt.setInt(6, rule);
            stmt.setString(7, (String)ruleMap.get(EVENT_CATEGORY));
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw e;
        }
    }

    private void updateRule(HashMap ruleMap, DBConnection connection) throws SQLException {
        String methodName = "updateRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)methodName);
        }
        try {
            String sql = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET EVENT_SEVERITY= (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME=?), ENTITY_TYPE= (SELECT ID FROM ITSANM.SANM_DEV_KEYS WHERE NAME=?), UNIQUE_ID=?, EVENT_TYPE= (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME=?), EVENT_CATEGORY= (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME=?), EVENT_ACTION= (SELECT ID FROM ITSANM.SANM_EVENT_ACTION WHERE NAME=?) WHERE RULE_ID=?");
            DBPreparedStatement stmt = connection.prepareStatement(sql);
            int rule = Integer.parseInt((String)ruleMap.get(RULE_ID));
            stmt.setString(1, (String)ruleMap.get(EVENT_SEVERITY));
            stmt.setString(2, (String)ruleMap.get(ENTITY_TYPE));
            stmt.setString(3, (String)ruleMap.get(UNIQUE_ID));
            stmt.setString(4, (String)ruleMap.get("EVENT_TYPE"));
            stmt.setString(5, (String)ruleMap.get(EVENT_CATEGORY));
            stmt.setString(6, (String)ruleMap.get(EVENT_ACTION));
            stmt.setInt(7, rule);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw e;
        }
    }

    private void incrementRuleIds(String ruleId, DBConnection connection) throws SQLException {
        block2: {
            String methodName = "incrementRuleIds";
            try {
                String sql = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET RULE_ID=RULE_ID+1 WHERE RULE_ID>=?");
                DBPreparedStatement stmt = connection.prepareStatement(sql);
                int intRule = Integer.parseInt(ruleId);
                stmt.setInt(1, intRule);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private void updateRuleId(String oldRuleId, String newRuleId, DBConnection connection) throws SQLException {
        block2: {
            String methodName = "updateRuleId";
            try {
                String sql = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET RULE_ID=? WHERE RULE_ID=?");
                DBPreparedStatement stmt = connection.prepareStatement(sql);
                int oldRule = Integer.parseInt(oldRuleId);
                int newRule = Integer.parseInt(newRuleId);
                stmt.setInt(1, newRule);
                stmt.setInt(2, oldRule);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private void deleteRule(String ruleId, DBConnection connection) throws SQLException {
        block2: {
            String methodName = "deleteRule";
            try {
                String sql = new String("DELETE FROM ITSANM.SANM_EVENT_FILTER WHERE RULE_ID=?");
                DBPreparedStatement stmt = connection.prepareStatement(sql);
                int intRule = Integer.parseInt(ruleId);
                stmt.setInt(1, intRule);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private void deleteAllFilterRules(DBConnection connection) throws SQLException {
        block2: {
            String methodName = "deleteAllFilterRules";
            try {
                String sql = new String("DELETE FROM ITSANM.SANM_EVENT_FILTER");
                DBPreparedStatement stmt = connection.prepareStatement(sql);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private DBResultSet listRules(DBConnection connection) throws SQLException {
        DBResultSet resultSet;
        block2: {
            String methodName = "listRules";
            resultSet = null;
            boolean ruleIsInUse = false;
            try {
                String query = new String(" SELECT   ITSANM.SANM_EVENT_FILTER.RULE_ID AS RULE_ID,   ITSANM.SANM_EVENT_SEVERITY.NAME AS EVENT_SEVERITY,   ITSANM.SANM_DEV_KEYS.NAME AS ENTITY_TYPE,   ITSANM.SANM_EVENT_FILTER.UNIQUE_ID AS UNIQUE_ID,   ITSANM.SANM_EVENT_TYPE.NAME AS EVENT_TYPE,   ITSANM.SANM_EVENT_CATEGORY.NAME AS EVENT_CATEGORY,   ITSANM.SANM_EVENT_ACTION.NAME AS EVENT_ACTION FROM    ITSANM.SANM_DEV_KEYS RIGHT OUTER JOIN ITSANM.SANM_EVENT_FILTER       ON ( ITSANM.SANM_DEV_KEYS.ID = ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE )     LEFT OUTER JOIN ITSANM.SANM_EVENT_CATEGORY       ON ( ITSANM.SANM_EVENT_CATEGORY.ID = ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY )     LEFT OUTER JOIN ITSANM.SANM_EVENT_TYPE       ON ( ITSANM.SANM_EVENT_TYPE.ID = ITSANM.SANM_EVENT_FILTER.EVENT_TYPE )     LEFT OUTER JOIN ITSANM.SANM_EVENT_ACTION       ON ( ITSANM.SANM_EVENT_ACTION.ID = ITSANM.SANM_EVENT_FILTER.EVENT_ACTION )     LEFT OUTER JOIN ITSANM.SANM_EVENT_SEVERITY       ON ( ITSANM.SANM_EVENT_SEVERITY.ID = ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY )  ORDER BY     RULE_ID");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return resultSet;
    }

    private String convertEntityTypeToProperCase(DBConnection connection, String entityType) throws Exception {
        String tmpEntityType = entityType.replace('_', ' ');
        ArrayList types = this.getEntityTypes(connection);
        if (!types.isEmpty()) {
            for (int i = 0; i < types.size(); ++i) {
                if (!tmpEntityType.equalsIgnoreCase((String)types.get(i))) continue;
                return (String)types.get(i);
            }
        }
        throw new Exception();
    }

    private ArrayList getEntityTypes(DBConnection connection) {
        block4: {
            String methodName = "getIntityTypes";
            if (entityTypes != null) {
                return entityTypes;
            }
            entityTypes = new ArrayList();
            DBResultSet resultSet = null;
            try {
                String query = new String("SELECT ITSANM.SANM_DEV_KEYS.NAME  as name FROM ITSANM.SANM_DEV_KEYS");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
                int i = 0;
                while (resultSet.next()) {
                    entityTypes.add(i, resultSet.getString("name"));
                    ++i;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return entityTypes;
    }

    private String convertEventCategoryToProperCase(DBConnection connection, String category) throws Exception {
        ArrayList categories = this.getEventCategories(connection);
        if (!categories.isEmpty()) {
            for (int i = 0; i < categories.size(); ++i) {
                if (!category.equalsIgnoreCase((String)categories.get(i))) continue;
                return (String)categories.get(i);
            }
        }
        throw new Exception();
    }

    private ArrayList getEventCategories(DBConnection connection) {
        block4: {
            String methodName = "getEventCategories";
            if (eventCategories != null) {
                return eventCategories;
            }
            eventCategories = new ArrayList();
            DBResultSet resultSet = null;
            try {
                String query = new String("SELECT ITSANM.SANM_EVENT_CATEGORY.NAME  as name FROM ITSANM.SANM_EVENT_CATEGORY");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
                int i = 0;
                while (resultSet.next()) {
                    eventCategories.add(i, resultSet.getString("name"));
                    ++i;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return eventCategories;
    }

    private String convertEventSeverityToProperCase(DBConnection connection, String severity) throws Exception {
        ArrayList severityList = this.getEventSeverities(connection);
        if (!severityList.isEmpty()) {
            for (int i = 0; i < severityList.size(); ++i) {
                if (!severity.equalsIgnoreCase((String)severityList.get(i))) continue;
                return (String)severityList.get(i);
            }
        }
        throw new Exception();
    }

    private ArrayList getEventSeverities(DBConnection connection) {
        block4: {
            String methodName = "getEventSeverities";
            if (eventSeverities != null) {
                return eventSeverities;
            }
            eventSeverities = new ArrayList();
            DBResultSet resultSet = null;
            try {
                String query = new String("SELECT ITSANM.SANM_EVENT_SEVERITY.NAME  as name FROM ITSANM.SANM_EVENT_SEVERITY");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
                int i = 0;
                while (resultSet.next()) {
                    eventSeverities.add(i, resultSet.getString("name"));
                    ++i;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return eventSeverities;
    }

    private String convertEventActionToProperCase(DBConnection connection, String eventAction) throws Exception {
        ArrayList eventActionList = this.getEventActions(connection);
        if (!eventActionList.isEmpty()) {
            for (int i = 0; i < eventActionList.size(); ++i) {
                if (!eventAction.equalsIgnoreCase((String)eventActionList.get(i))) continue;
                return (String)eventActionList.get(i);
            }
        }
        throw new Exception();
    }

    private ArrayList getEventActions(DBConnection connection) {
        block4: {
            String methodName = "getEventActions";
            if (eventActions != null) {
                return eventActions;
            }
            eventActions = new ArrayList();
            DBResultSet resultSet = null;
            try {
                String query = new String("SELECT ITSANM.SANM_EVENT_ACTION.NAME  as name FROM ITSANM.SANM_EVENT_ACTION");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
                int i = 0;
                while (resultSet.next()) {
                    eventActions.add(i, resultSet.getString("name"));
                    ++i;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return eventActions;
    }

    private String convertEventTypeToProperCase(DBConnection connection, String eventType) throws Exception {
        ArrayList eventTypeList = this.getEventTypes(connection);
        if (!eventTypeList.isEmpty()) {
            for (int i = 0; i < eventTypeList.size(); ++i) {
                if (!eventType.equalsIgnoreCase((String)eventTypeList.get(i))) continue;
                return (String)eventTypeList.get(i);
            }
        }
        throw new Exception();
    }

    private ArrayList getEventTypes(DBConnection connection) {
        block4: {
            String methodName = "getEventTypes";
            if (eventTypes != null) {
                return eventTypes;
            }
            eventTypes = new ArrayList();
            DBResultSet resultSet = null;
            try {
                String query = new String("SELECT ITSANM.SANM_EVENT_TYPE.NAME  as name FROM ITSANM.SANM_EVENT_TYPE");
                DBPreparedStatement stmt = connection.prepareStatement(query);
                resultSet = stmt.executeQuery();
                int i = 0;
                while (resultSet.next()) {
                    eventTypes.add(i, resultSet.getString("name"));
                    ++i;
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return eventTypes;
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    static {
        publisher = null;
        messagePrinter = null;
        exceptionPrinter = null;
        entityTypes = null;
        eventCategories = null;
        eventSeverities = null;
        eventTypes = null;
        eventActions = null;
        defaultRule1 = new HashMap();
        defaultRule1.put(EVENT_ACTION, "suppress");
        defaultRule1.put("EVENT_TYPE", "tec");
        defaultRule1.put(RULE_ID, "1");
        defaultRule1.put(ENTITY_TYPE, "HBA2Node");
        defaultRule2 = new HashMap();
        defaultRule2.put(EVENT_ACTION, "suppress");
        defaultRule2.put("EVENT_TYPE", "trap");
        defaultRule2.put(RULE_ID, "2");
        defaultRule2.put(ENTITY_TYPE, "HBA2Node");
        defaultRule3 = new HashMap();
        defaultRule3.put(EVENT_ACTION, "suppress");
        defaultRule3.put("EVENT_TYPE", "tec");
        defaultRule3.put(RULE_ID, "3");
        defaultRule3.put(ENTITY_TYPE, "PE2Node");
        defaultRule4 = new HashMap();
        defaultRule4.put(EVENT_ACTION, "suppress");
        defaultRule4.put("EVENT_TYPE", "trap");
        defaultRule4.put(RULE_ID, "4");
        defaultRule4.put(ENTITY_TYPE, "PE2Node");
        defaultRule5 = new HashMap();
        defaultRule5.put(EVENT_ACTION, "suppress");
        defaultRule5.put("EVENT_TYPE", "tec");
        defaultRule5.put(RULE_ID, "5");
        defaultRule5.put(ENTITY_TYPE, "PV2LUN");
        defaultRule6 = new HashMap();
        defaultRule6.put(EVENT_ACTION, "suppress");
        defaultRule6.put("EVENT_TYPE", "trap");
        defaultRule6.put(RULE_ID, "6");
        defaultRule6.put(ENTITY_TYPE, "PV2LUN");
        defaultRule7 = new HashMap();
        defaultRule7.put(EVENT_ACTION, "suppress");
        defaultRule7.put("EVENT_TYPE", "tec");
        defaultRule7.put(RULE_ID, "7");
        defaultRule7.put(EVENT_SEVERITY, "minor");
        defaultRule8 = new HashMap();
        defaultRule8.put(EVENT_ACTION, "suppress");
        defaultRule8.put("EVENT_TYPE", "trap");
        defaultRule8.put(RULE_ID, "8");
        defaultRule8.put(EVENT_SEVERITY, "minor");
        defaultRule9 = new HashMap();
        defaultRule9.put(EVENT_ACTION, "suppress");
        defaultRule9.put("EVENT_TYPE", "tec");
        defaultRule9.put(RULE_ID, "9");
        defaultRule9.put(ENTITY_TYPE, "OS2FS");
        defaultRule10 = new HashMap();
        defaultRule10.put(EVENT_ACTION, "suppress");
        defaultRule10.put("EVENT_TYPE", "trap");
        defaultRule10.put(RULE_ID, "10");
        defaultRule10.put(ENTITY_TYPE, "OS2FS");
        defaultRule11 = new HashMap();
        defaultRule11.put(EVENT_ACTION, "suppress");
        defaultRule11.put("EVENT_TYPE", "tec");
        defaultRule11.put(RULE_ID, "11");
        defaultRule11.put(ENTITY_TYPE, "OS2LV");
        defaultRule12 = new HashMap();
        defaultRule12.put(EVENT_ACTION, "suppress");
        defaultRule12.put("EVENT_TYPE", "trap");
        defaultRule12.put(RULE_ID, "12");
        defaultRule12.put(ENTITY_TYPE, "OS2LV");
        defaultRule13 = new HashMap();
        defaultRule13.put(EVENT_ACTION, "suppress");
        defaultRule13.put("EVENT_TYPE", "tec");
        defaultRule13.put(RULE_ID, "13");
        defaultRule13.put(ENTITY_TYPE, "OS2PV");
        defaultRule14 = new HashMap();
        defaultRule14.put(EVENT_ACTION, "suppress");
        defaultRule14.put("EVENT_TYPE", "trap");
        defaultRule14.put(RULE_ID, "14");
        defaultRule14.put(ENTITY_TYPE, "OS2PV");
        defaultRule15 = new HashMap();
        defaultRule15.put(EVENT_ACTION, "suppress");
        defaultRule15.put("EVENT_TYPE", "tec");
        defaultRule15.put(RULE_ID, "15");
        defaultRule15.put(ENTITY_TYPE, "OS2VG");
        defaultRule16 = new HashMap();
        defaultRule16.put(EVENT_ACTION, "suppress");
        defaultRule16.put("EVENT_TYPE", "trap");
        defaultRule16.put(RULE_ID, "16");
        defaultRule16.put(ENTITY_TYPE, "OS2VG");
        defaultRule17 = new HashMap();
        defaultRule17.put(EVENT_ACTION, "suppress");
        defaultRule17.put("EVENT_TYPE", "tec");
        defaultRule17.put(RULE_ID, "17");
        defaultRule17.put(ENTITY_TYPE, "Port");
        defaultRule18 = new HashMap();
        defaultRule18.put(EVENT_ACTION, "suppress");
        defaultRule18.put("EVENT_TYPE", "trap");
        defaultRule18.put(RULE_ID, "18");
        defaultRule18.put(ENTITY_TYPE, "Port");
        defaultRule19 = new HashMap();
        defaultRule19.put(EVENT_ACTION, "suppress");
        defaultRule19.put("EVENT_TYPE", "tec");
        defaultRule19.put(RULE_ID, "19");
        defaultRule19.put(ENTITY_TYPE, "Node");
        defaultRule20 = new HashMap();
        defaultRule20.put(EVENT_ACTION, "suppress");
        defaultRule20.put("EVENT_TYPE", "trap");
        defaultRule20.put(RULE_ID, "20");
        defaultRule20.put(ENTITY_TYPE, "Node");
        defaultFilterRules = new HashMap[]{defaultRule1, defaultRule2, defaultRule3, defaultRule4, defaultRule5, defaultRule6, defaultRule7, defaultRule8, defaultRule9, defaultRule10, defaultRule11, defaultRule12, defaultRule13, defaultRule14, defaultRule15, defaultRule16, defaultRule17, defaultRule18, defaultRule19, defaultRule20};
    }
}

