/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import com.tivoli.tec.event_delivery.EDException;
import com.tivoli.tec.event_delivery.TECAgent;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class TecEventProcessor
implements Runnable {
    private static ILogger msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
    private static ILogger traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
    static final String className = TecEventProcessor.class.getName();
    private Vector eventQueue = new Vector();
    DestinationFactory destFactory = null;
    private Thread workerThread = null;
    private static TecEventProcessor myThread;
    private static long MAXNUMBEROFTRAP;
    private TECAgent tecAgent = null;
    private String serverLocation = null;
    private int serverPort = -1;
    private String debugMode = null;

    private TecEventProcessor() {
    }

    public static TecEventProcessor instance() {
        if (myThread == null) {
            myThread = new TecEventProcessor();
        }
        return myThread;
    }

    public void start(DestinationFactory destFactory) {
        String methodName = "start";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.destFactory = destFactory;
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.workerThread = null;
        TecEventProcessor tecEventProcessor = this;
        synchronized (tecEventProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName;
        block15: {
            methodName = "run";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                Thread curThread = Thread.currentThread();
                while (this.workerThread == curThread) {
                    String messageInfo;
                    try {
                        while (this.eventQueue.isEmpty()) {
                            TecEventProcessor tecEventProcessor = this;
                            synchronized (tecEventProcessor) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (this.workerThread == null) {
                                    if (traceLogger.isLogging()) {
                                        messageInfo = "TecEventProcessor was shutdown";
                                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, messageInfo);
                                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                                    }
                                    return;
                                }
                            }
                        }
                        String tec = (String)this.eventQueue.firstElement();
                        this.eventQueue.remove(0);
                        this.sendTecEvent(tec);
                    }
                    catch (Exception e) {
                        messageInfo = "Failed to send Tec Event";
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception pe) {
                String messageInfo = "Failed to start TecEventProcessor";
                if (!traceLogger.isLogging()) break block15;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pe);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTecEvent(String tecStr) {
        String ipAddress;
        String methodName = "addTecEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)new String("TECEvent"));
        }
        if ((ipAddress = this.destFactory.getTECServerLocation()) == null) {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.removeAllElements();
            }
            return;
        }
        if ((long)this.eventQueue.size() < MAXNUMBEROFTRAP) {
            this.eventQueue.addElement(tecStr);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "New TEC event added to TecEventProcessor for TEC client@" + ipAddress);
        } else {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.remove(0);
            }
            this.eventQueue.addElement(tecStr);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Tec event queue for client@" + ipAddress + " is full, delete the oldest one and add the new one.");
        }
        TecEventProcessor tecEventProcessor = this;
        synchronized (tecEventProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int sendTecEvent(String tecEvent) {
        String methodName = "sendTecEvent";
        String newServerLocation = null;
        int newServerPort = -1;
        int rc = -2;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)new String("tecEvent"));
        }
        newServerLocation = this.destFactory.getTECServerLocation();
        newServerPort = this.destFactory.getTECServerPort();
        if (newServerLocation == null || newServerLocation.equals("")) {
            this.serverLocation = null;
            this.serverPort = -1;
            if (this.tecAgent != null) {
                this.tecAgent.disconnect();
                this.tecAgent = null;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "The TEC server location or the port was not set.  The TECAgent is null.");
                }
            }
            rc = -2;
        } else if (this.tecAgent == null) {
            this.createTecAgent();
        } else if (!newServerLocation.equals(this.serverLocation) || newServerPort != this.serverPort) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "The TEC server location or port number has changed. A new TECAgent will be created to send TEC events.");
            }
            this.createTecAgent();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Sending TEC event: " + tecEvent);
        }
        if (this.tecAgent != null) {
            rc = this.tecAgent.sendEvent(tecEvent);
        }
        String result = rc < 0 ? "Unable to send TEC event with return code = " + rc : (rc == 0 ? "The TEC event is filtered out with return code = " + rc : "TEC event was sent successfully with number of bytes sent = " + rc);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, result);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private void createTecAgent() {
        String methodName;
        block11: {
            String tecConfigStr;
            methodName = "createTecAgent";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if ((tecConfigStr = this.getTecConfigString()) != null) {
                if (this.tecAgent != null) {
                    this.tecAgent.disconnect();
                    this.tecAgent = null;
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "TECAgent disconnected and was set to null.  The TECAgent will be recreated.");
                    }
                }
                try {
                    this.tecAgent = new TECAgent((Reader)new StringReader(tecConfigStr), 0, false);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "TECAgent created successfully.");
                    }
                }
                catch (EDException eife) {
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "SANEventMessage_tecException");
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Unable to create TEC agent to establish connection with the TEC server.");
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)eife);
                    }
                }
                catch (Exception e) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block11;
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Unable to create TEC agent to establish connection with the TEC server.");
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String getTecConfigString() {
        String methodName = "getTecConfigString";
        this.serverLocation = this.destFactory.getTECServerLocation();
        this.serverPort = this.destFactory.getTECServerPort();
        this.debugMode = this.destFactory.getTECDebugMode();
        if (this.serverLocation == null || this.serverLocation.equals("")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Server location returned is null. No TEC event will be sent.");
            }
            return null;
        }
        String tsnmBaseDir = Variables.getBaseDirectory();
        if (tsnmBaseDir == null) {
            tsnmBaseDir = "";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "The base product directory could not be located.");
            }
        } else {
            char ch = File.separator.charAt(0);
            tsnmBaseDir = tsnmBaseDir.replace('\\', ch);
        }
        String tecLogPath = tsnmBaseDir + File.separator + "tec" + File.separator;
        String bufEvtPath = tecLogPath + "cache";
        String evdTrcConfigStr = "";
        if (this.debugMode.equalsIgnoreCase("YES")) {
            evdTrcConfigStr = "LogLevel=ALL\nTraceLevel=ALL\nLogFileName=" + tecLogPath + "adptlog.log\n" + "TraceFileName=" + tecLogPath + "adpttrc.log\n";
        }
        String configStr = "ServerLocation=" + this.serverLocation + "\n" + "ServerPort=" + this.serverPort + "\n" + "BufferEvents=YES\n" + "BufEvtPath=" + bufEvtPath + "\n" + "BufEvtMaxSize=512\n" + "ConnectionMode=connection_oriented\n" + evdTrcConfigStr;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "TEC Server configuration has value: \n" + configStr);
        }
        return configStr;
    }

    static {
        msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        myThread = null;
        MAXNUMBEROFTRAP = 1000L;
    }
}

