/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;
import org.eclipse.aperi.disk.discovery.SubSystemDeletion;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;

public class DiskManagementOperations
extends DiskOperations
implements IDiskManagementService {
    static final long SUBSYSTEMDELETIONTIMEOUTDEFAULT = 30000L;
    static final String SUBSYSTEM_DELETION_TIMEOUT = "SUBSYSTEMDELETIONTIMEOUT";
    private static volatile Map cStorageSystemUsage = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubsystemDataInUse(String pSubsystemID) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"registerSubsystemDataInUse", (Object[])new Object[]{pSubsystemID});
        Map map = cStorageSystemUsage;
        synchronized (map) {
            Object mVal = cStorageSystemUsage.get(pSubsystemID);
            int mUsageCount = 1;
            if (mVal != null) {
                mUsageCount = (Integer)mVal + 1;
            }
            cStorageSystemUsage.put(pSubsystemID, new Integer(mUsageCount));
        }
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubsystemDataInUse(String pSubsystemID) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deregisterSubsystemDataInUse", (Object[])new Object[]{pSubsystemID});
        Map map = cStorageSystemUsage;
        synchronized (map) {
            Object mVal = cStorageSystemUsage.get(pSubsystemID);
            if (mVal == null) {
                return;
            }
            int mUsageCount = (Integer)mVal - 1;
            if (mUsageCount < 1) {
                cStorageSystemUsage.remove(pSubsystemID);
            } else {
                cStorageSystemUsage.put(pSubsystemID, new Integer(mUsageCount));
            }
        }
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSubsystemDataInUse(String pSubsystemID) throws IDParseException, EntityNotFoundException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"checkSubsystemDataInUse", (Object[])new Object[]{pSubsystemID});
        Map map = cStorageSystemUsage;
        synchronized (map) {
            if (cStorageSystemUsage.containsKey(pSubsystemID)) {
                mLTH.exit((Object)new Boolean(true));
                return true;
            }
        }
        DBConnection mDBCon = null;
        try {
            mDBCon = ServiceUtils.getConnection();
            StorageSubsystem mSS = ExternalKeyManager.getStorageSubsystem((String)pSubsystemID, (DBConnection)mDBCon);
            if (mSS.getProbeStatus() != null && mSS.getProbeStatus().trim().equals("0")) {
                mLTH.exit((Object)new Boolean(true));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (mDBCon != null) {
                try {
                    mDBCon.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            mLTH.exit((Object)new Boolean(false));
        }
        return false;
    }

    public DiskManagementOperations(DiskManager pDiskManager) {
        super(pDiskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    private long getTimeout(DBConnection pConn, LogTraceHelper pLTH) {
        long mTimeoutValue = 30000L;
        ConfigData mCD = ParameterHelper.readConfigData((DBConnection)pConn, (String)SUBSYSTEM_DELETION_TIMEOUT, (LogTraceHelper)pLTH);
        mTimeoutValue = mCD != null ? Long.valueOf(mCD.getValue()) : 30000L;
        return mTimeoutValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removePhysicalVolumesFromDB(int[] pPhyVolumeAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removePhysicalVolumesFromDB", (Object[])new Object[]{pPhyVolumeAutoIDs});
        DBConnection mConn = null;
        Result mReturn = new Result();
        mReturn.setSRMMessage("HWN020001I", new String[]{"removePhysicalVolumesFromDB"});
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"PhyVolumeAutoIDs", (Object)pPhyVolumeAutoIDs, (LogTraceHelper)mLTH);
            mConn = ServiceUtils.getConnection();
            long mTimeoutValue = this.getTimeout(mConn, mLTH);
            mLTH.traceInfo("Timeout for deletion :" + mTimeoutValue);
            Object mObjResult = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deletePhysicalVolumes", (Object[])new Object[]{pPhyVolumeAutoIDs}, (long)mTimeoutValue, (LogTraceHelper)mLTH);
            mReturn.setResults(new Object[]{mObjResult});
            Result result = mReturn;
            return result;
        }
        catch (DiskManagerExecException pEx) {
            mLTH.traceError("Internal error: deletePhysicalVolumes DiskManagerExecException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[]{pEx.getMessage()}));
            return result;
        }
        catch (DiskManagerTimeoutException pEx) {
            mLTH.traceError("Internal error: deletePhysicalVolumes TimeoutException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[0]));
            return result;
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removeStoragePoolsFromDB(int[] pPoolAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removeStoragePoolsFromDB", (Object[])new Object[]{pPoolAutoIDs});
        DBConnection mConn = null;
        Result mReturn = new Result();
        mReturn.setSRMMessage("HWN020001I", new String[]{"removeStoragePoolsFromDB"});
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"PoolAutoIDs", (Object)pPoolAutoIDs, (LogTraceHelper)mLTH);
            mConn = ServiceUtils.getConnection();
            long mTimeoutValue = this.getTimeout(mConn, mLTH);
            mLTH.traceInfo("Timeout for deletion :" + mTimeoutValue);
            Object mObjResult = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deleteStoragePools", (Object[])new Object[]{pPoolAutoIDs}, (long)mTimeoutValue, (LogTraceHelper)mLTH);
            mReturn.setResults(new Object[]{mObjResult});
            Result result = mReturn;
            return result;
        }
        catch (DiskManagerExecException pEx) {
            mLTH.traceError("Internal error: removeStoragePoolsFromDB DiskManagerExecException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[]{pEx.getMessage()}));
            return result;
        }
        catch (DiskManagerTimeoutException pEx) {
            mLTH.traceError("Internal error: removeStoragePoolsFromDB TimeoutException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[0]));
            return result;
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removePortsFromDB(int[] pPortAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removePortsFromDB", (Object[])new Object[]{pPortAutoIDs});
        DBConnection mConn = null;
        Result mReturn = new Result();
        mReturn.setSRMMessage("HWN020001I", new String[]{"removePortsFromDB"});
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"PortAutoIDs", (Object)pPortAutoIDs, (LogTraceHelper)mLTH);
            mConn = ServiceUtils.getConnection();
            long mTimeoutValue = this.getTimeout(mConn, mLTH);
            mLTH.traceInfo("Timeout for deletion :" + mTimeoutValue);
            Object mObjResult = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deletePorts", (Object[])new Object[]{pPortAutoIDs}, (long)mTimeoutValue, (LogTraceHelper)mLTH);
            mReturn.setResults(new Object[]{mObjResult});
            Result result = mReturn;
            return result;
        }
        catch (DiskManagerExecException pEx) {
            mLTH.traceError("Internal error: removePortsFromDB DiskManagerExecException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[]{pEx.getMessage()}));
            return result;
        }
        catch (DiskManagerTimeoutException pEx) {
            mLTH.traceError("Internal error: removePortsFromDB TimeoutException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[0]));
            return result;
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removeStorageVolumesFromDB(int[] pVolumeIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removeStorageVolumeFromDB", (Object[])new Object[]{pVolumeIDs});
        DBConnection mConn = null;
        Result mReturn = new Result();
        mReturn.setSRMMessage("HWN020001I", new String[]{"removeStorageVolumeFromDB"});
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"VolumeIDs", (Object)pVolumeIDs, (LogTraceHelper)mLTH);
            mConn = ServiceUtils.getConnection();
            long mTimeoutValue = this.getTimeout(mConn, mLTH);
            mLTH.traceInfo("Timeout for deletion :" + mTimeoutValue);
            Object mObjResult = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deleteStorageVolumes", (Object[])new Object[]{pVolumeIDs}, (long)mTimeoutValue, (LogTraceHelper)mLTH);
            mReturn.setResults(new Object[]{mObjResult});
            Result result = mReturn;
            return result;
        }
        catch (DiskManagerExecException pEx) {
            mLTH.traceError("Internal error: removeStorageVolumeFromDB DiskManagerExecException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[]{pEx.getMessage()}));
            return result;
        }
        catch (DiskManagerTimeoutException pEx) {
            mLTH.traceError("Internal error: removeStorageVolumeFromDB TimeoutException", (Throwable)pEx);
            Result result = mReturn = new Result(0, new SRMMessage("HWN021503E", new String[0]));
            return result;
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] deleteStorageSubsystems(String[] pSubsystemIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deleteStorageSubsystems", (Object[])new Object[]{pSubsystemIDs});
        Object mResult = null;
        DBConnection mConn = null;
        Result[] mReturn = new Result[pSubsystemIDs.length];
        try {
            int bLoop;
            ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemIDs", (Object)pSubsystemIDs, (LogTraceHelper)mLTH);
            for (int i = 0; i < pSubsystemIDs.length; ++i) {
                try {
                    if (!this.checkSubsystemDataInUse(pSubsystemIDs[i])) continue;
                    throw DiskMessageHelper.getServerException((String)"HWN021672E", (Object)pSubsystemIDs[i], (LogTraceHelper)mLTH);
                }
                catch (IDParseException e) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException e) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                }
            }
            mConn = ServiceUtils.getConnection();
            long mTimeoutValue = this.getTimeout(mConn, mLTH);
            mLTH.traceInfo("Timeout for deletion :" + mTimeoutValue);
            ExecGroup mEG = DiskThreadManager.getExecutionGroup();
            Long[] mExecutionID = new Long[pSubsystemIDs.length];
            for (bLoop = 0; bLoop < pSubsystemIDs.length; ++bLoop) {
                Object[] bParamArray = null;
                bParamArray = new Object[]{pSubsystemIDs[bLoop]};
                mExecutionID[bLoop] = mEG.execute((Object)new SubSystemDeletion(), "deleteStorageSubsystem", bParamArray, mLTH);
            }
            mEG.waitForCompletion(mTimeoutValue);
            for (bLoop = 0; bLoop < pSubsystemIDs.length; ++bLoop) {
                Throwable mExecutionError = mEG.getExecutionError(mExecutionID[bLoop]);
                if (mExecutionError == null) {
                    Object mExecutionResult = mEG.getExecutionResult(mExecutionID[bLoop]);
                    mReturn[bLoop] = (Result)mExecutionResult;
                    continue;
                }
                Result mResultError = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                if (mExecutionError instanceof Exception) {
                    Exception pEx = (Exception)mExecutionError;
                    mLTH.traceError("Internal error: deleteStorageSubsystems (" + pSubsystemIDs[bLoop] + ")", (Throwable)pEx);
                    mResultError.setResults((Object[])new String[]{pEx.toString()});
                }
                mReturn[bLoop] = mResultError;
            }
        }
        catch (DiskManagerExecException pEx) {
            mLTH.traceError("Internal error: deleteStorageSubsystems DiskManagerExecException", (Throwable)pEx);
            Result mResultTimeout = new Result(0, new SRMMessage("HWN021503E", new String[0]));
        }
        catch (DiskManagerTimeoutException pEx) {
            mLTH.traceError("Internal error: deleteStorageSubsystems TimeoutException", (Throwable)pEx);
            Result mResultTimeout = new Result(0, new SRMMessage("HWN021503E", new String[0]));
            for (int bLoop = 0; bLoop < pSubsystemIDs.length; ++bLoop) {
                mReturn[bLoop] = mResultTimeout;
            }
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mResult);
        }
        return mReturn;
    }
}

