/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.io.InvalidClassException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.api.IDiskMonitorService;
import org.eclipse.aperi.disk.api.impl.DiskCliDispatcher;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.AffectedHostAnalyzer;
import org.eclipse.aperi.disk.monitor.DiskDriveCreationHandler;
import org.eclipse.aperi.disk.monitor.DiskDriveDeletionHandler;
import org.eclipse.aperi.disk.monitor.DiskDriveModificationHandler;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskExpiringEventQueue;
import org.eclipse.aperi.disk.monitor.DiskFilterThread;
import org.eclipse.aperi.disk.monitor.DiskIndicationHandlerFactory;
import org.eclipse.aperi.disk.monitor.DiskWorkerThread;
import org.eclipse.aperi.disk.monitor.ESSPhysicalPackageCreationHandler;
import org.eclipse.aperi.disk.monitor.ESSPhysicalPackageDeletionHandler;
import org.eclipse.aperi.disk.monitor.ESSPhysicalPackageModificationHandler;
import org.eclipse.aperi.disk.monitor.ExtentCreationHandler;
import org.eclipse.aperi.disk.monitor.ExtentDeletionHandler;
import org.eclipse.aperi.disk.monitor.ExtentModificationHandler;
import org.eclipse.aperi.disk.monitor.FCPortCreationHandler;
import org.eclipse.aperi.disk.monitor.FCPortDeletionHandler;
import org.eclipse.aperi.disk.monitor.FCPortModificationHandler;
import org.eclipse.aperi.disk.monitor.PoolCreationHandler;
import org.eclipse.aperi.disk.monitor.PoolDeletionHandler;
import org.eclipse.aperi.disk.monitor.PoolModificationHandler;
import org.eclipse.aperi.disk.monitor.ProtocolControllerForUnitIndicationHandler;
import org.eclipse.aperi.disk.monitor.SubsystemCreationHandler;
import org.eclipse.aperi.disk.monitor.SubsystemDeletionHandler;
import org.eclipse.aperi.disk.monitor.SubsystemModificationHandler;
import org.eclipse.aperi.disk.monitor.VolumeCreationHandler;
import org.eclipse.aperi.disk.monitor.VolumeDeletionHandler;
import org.eclipse.aperi.disk.monitor.VolumeModificationHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DataPathAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskDriveAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskGroupAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExtentAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PoolAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.PortAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.StorageSystemAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.data.VolumeAlertPopulator;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicConnectionFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;

public class DiskMonitorService
implements IDiskMonitorService,
MessageListener,
ICliDispatcher {
    private static final long BUFFERQUEUEEXPIRATION = 60000L;
    private static final int BUFFERQUEUEDEPTH = 200;
    private DiskFilterThread cFilterThread = null;
    private DiskWorkerThread cWorkerThread = null;
    private DiskEventQueue cEntryQueue = null;
    private DiskExpiringEventQueue cCreationBufferQueue = null;
    private DiskExpiringEventQueue cDeletionBufferQueue = null;
    private DiskEventQueue cWorkerQueue = null;
    private Status cStatus = new Status(5, 6);
    private static Factory cFactory = null;
    private static TopicSubscriber cIndicationSubscriber = null;
    private MSTopicConnectionFactory cTopicConnector = null;

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "DiskMonitorService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiskMonitorService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiskMonitorService_Description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"startup", null);
        boolean mResult = true;
        try {
            mLTH.traceInfo("setting install status to INSTALLED");
            this.cStatus.setInstallStatus(5);
            mLTH.traceInfo("setting status to STARTING and RUNNING");
            this.cStatus.setRunStatus(9);
            this.cStatus.setRunStatus(8);
            mLTH.traceInfo("creating entry, buffer and work queue");
            this.cEntryQueue = new DiskEventQueue();
            this.cCreationBufferQueue = new DiskExpiringEventQueue(200, 60000L);
            this.cDeletionBufferQueue = new DiskExpiringEventQueue(200, 60000L);
            this.cWorkerQueue = new DiskEventQueue();
            mLTH.traceInfo("creating buffer thread");
            this.cFilterThread = new DiskFilterThread(this.cEntryQueue, this.cWorkerQueue, this.cCreationBufferQueue, this.cDeletionBufferQueue);
            mLTH.traceInfo("creating worker thread");
            this.cWorkerThread = new DiskWorkerThread(this.cWorkerQueue);
            try {
                DiskIndicationHandlerFactory.getInstance().registerHandler(VolumeCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(VolumeModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(VolumeDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(SubsystemCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(SubsystemModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(SubsystemDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ProtocolControllerForUnitIndicationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(PoolCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(PoolModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(PoolDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(FCPortCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(FCPortModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(FCPortDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ExtentCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ExtentModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ExtentDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ESSPhysicalPackageCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ESSPhysicalPackageModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(ESSPhysicalPackageDeletionHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(DiskDriveCreationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(DiskDriveModificationHandler.class);
                DiskIndicationHandlerFactory.getInstance().registerHandler(DiskDriveDeletionHandler.class);
            }
            catch (InvalidClassException pEx) {
                mLTH.traceError("registration for CIMIndicationHandler failed because of " + pEx.getMessage(), (Throwable)pEx);
                mResult = false;
            }
            try {
                mLTH.traceInfo("creating factory");
                cFactory = FactoryFactory.createFactory((int)2, null);
                mLTH.traceInfo("subscribing for CIMIndicationEvents on pub/sub using listener");
                cIndicationSubscriber = cFactory.createSubscriber(CIMIndicationEvent.class.getName(), null, null, (MessageListener)this);
            }
            catch (Exception pEx) {
                mLTH.traceError("subscription for CIMIndicationEvents on pub/sub failed because of " + pEx.getMessage(), (Throwable)pEx);
                mResult = false;
            }
            IEventMonitorService bEventMonitor = Processor.getEventMonitorProxy();
            bEventMonitor.registerAlertPopulator("diskdrive", (IPopulator)new DiskDriveAlertPopulator());
            bEventMonitor.registerAlertPopulator("diskgroup", (IPopulator)new DiskGroupAlertPopulator());
            bEventMonitor.registerAlertPopulator("storageextent", (IPopulator)new ExtentAlertPopulator());
            bEventMonitor.registerAlertPopulator("storagepool", (IPopulator)new PoolAlertPopulator());
            bEventMonitor.registerAlertPopulator("fcport", (IPopulator)new PortAlertPopulator());
            bEventMonitor.registerAlertPopulator("storagesystem", (IPopulator)new StorageSystemAlertPopulator());
            bEventMonitor.registerAlertPopulator("storagevolume", (IPopulator)new VolumeAlertPopulator());
            bEventMonitor.registerAlertPopulator("datapath", (IPopulator)new DataPathAlertPopulator());
        }
        finally {
            mLTH.exit((Object)new Boolean(mResult));
            return mResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        boolean mResult = true;
        try {
            mLTH.traceInfo("setting status to STOPPING");
            this.cStatus.setRunStatus(11);
            mLTH.traceInfo("shutting down filter and worker thread");
            if (this.cFilterThread.isAlive()) {
                this.cFilterThread.shutdown();
            }
            if (this.cWorkerThread.isAlive()) {
                this.cWorkerThread.shutdown();
            }
            if (!this.cEntryQueue.isEmpty()) {
                mLTH.traceInfo("shutting down entry queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cEntryQueue.shutdown();
            }
            if (!this.cCreationBufferQueue.isEmpty()) {
                mLTH.traceInfo("shutting down InstCreation buffer queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cCreationBufferQueue.shutdown();
            }
            if (!this.cDeletionBufferQueue.isEmpty()) {
                mLTH.traceInfo("shutting down InstDeletion buffer queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cDeletionBufferQueue.shutdown();
            }
            if (!this.cWorkerQueue.isEmpty()) {
                mLTH.traceInfo("shutting down worker queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cWorkerQueue.shutdown();
            }
            try {
                mLTH.traceInfo("unsubscring: closing subscriber and factory");
                cIndicationSubscriber.close();
                cFactory.close();
            }
            catch (Exception pEx) {
                mLTH.traceError("HWN099993E", (Throwable)pEx);
                mResult = false;
            }
            finally {
                mLTH.traceInfo("setting status to STOPPED");
                this.cStatus.setRunStatus(10);
            }
            IEventMonitorService bEventMonitor = Processor.getEventMonitorProxy();
            bEventMonitor.deregisterAlertPopulator("diskdrive");
            bEventMonitor.deregisterAlertPopulator("diskgroup");
            bEventMonitor.deregisterAlertPopulator("storageextent");
            bEventMonitor.deregisterAlertPopulator("storagepool");
            bEventMonitor.deregisterAlertPopulator("fcport");
            bEventMonitor.deregisterAlertPopulator("storagesystem");
            bEventMonitor.deregisterAlertPopulator("storagevolume");
            bEventMonitor.deregisterAlertPopulator("datapath");
        }
        finally {
            mLTH.exit((Object)new Boolean(mResult));
            return mResult;
        }
    }

    public String getDescription() {
        return "Disk Monitor: This service handles disk related events.";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("getAffectedHostTest", new Integer(RoleChecker.DISK_VIEWER));
        return roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message pMessage) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"onMessage", (Object[])new Object[]{pMessage});
        try {
            ObjectMessage mObjMsg = (ObjectMessage)pMessage;
            SRMEvent mEvent = (SRMEvent)mObjMsg.getObject();
            if (mEvent instanceof CIMIndicationEvent) {
                mLTH.traceInfo("adding indication to entry queue");
                this.cEntryQueue.add((CIMIndicationEvent)mEvent);
            } else {
                mLTH.traceInfo("ignoring non-indication event");
            }
        }
        catch (JMSException pEx) {
            mLTH.traceError("HWN099993E", (Throwable)pEx);
        }
        finally {
            mLTH.exit(null);
        }
    }

    public String dispatch(String method, String[] args) {
        return DiskCliDispatcher.dispatch(this, method, args);
    }

    public static void getAffectedHostTest(String pSSID, String pVID, String pPortID, String pPoolID, String pNID, String pEID, String pDGID, String pDDID) {
        HashMap bAnalysisResult;
        String mBadID = "0";
        String mNnID = null;
        List mHosts = null;
        if (pSSID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForStorageSystem((String)pSSID);
            System.out.println("StorageSystem with ID " + pSSID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForStorageSystem((String)pSSID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForStorageSystem((String)"0");
            System.out.println("StorageSystem with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForStorageSystem(mNnID);
            System.out.println("StorageSystem with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pVID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForVolume((String)pVID);
            System.out.println("Volume with ID " + pVID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForVolume((String)pVID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForVolume((String)"0");
            System.out.println("Volume with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForVolume(mNnID);
            System.out.println("Volume with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pPortID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPort((String)pPortID);
            System.out.println("Port with ID " + pPortID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForPort((String)pPortID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPort((String)"0");
            System.out.println("Port with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPort(mNnID);
            System.out.println("Port with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pPoolID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPool((String)pPoolID);
            System.out.println("Pool with ID " + pPoolID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForPool((String)pPoolID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPool((String)"0");
            System.out.println("Pool with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForPool(mNnID);
            System.out.println("Pool with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pNID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForNode((String)pNID);
            System.out.println("Node with ID " + pNID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForNode((String)pNID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForNode((String)"0");
            System.out.println("Node with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForNode(mNnID);
            System.out.println("Node with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pEID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForExtent((String)pEID);
            System.out.println("Extent with ID " + pEID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForExtent((String)pEID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForExtent((String)"0");
            System.out.println("Extent with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForExtent(mNnID);
            System.out.println("Extent with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pDGID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskGroup((String)pDGID);
            System.out.println("DiskGroup with ID " + pDGID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForDiskGroup((String)pDGID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskGroup((String)"0");
            System.out.println("DiskGroup with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskGroup(mNnID);
            System.out.println("DiskGroup with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
        if (pDDID != null) {
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskDrive((String)pDDID);
            System.out.println("DiskDrive with ID " + pDDID + " affecting Hosts " + mHosts.toString());
            if (mHosts.size() == 0) {
                bAnalysisResult = AffectedHostAnalyzer.analyzeAffectedHostsForDiskDrive((String)pDDID);
                DiskMonitorService.analyzeResult(bAnalysisResult);
            }
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskDrive((String)"0");
            System.out.println("DiskDrive with ID 0 affecting Hosts " + mHosts.toString());
            mHosts = AffectedHostAnalyzer.getAffectedHostsForDiskDrive(mNnID);
            System.out.println("DiskDrive with ID " + mNnID + " affecting Hosts " + mHosts.toString());
        }
    }

    private static void analyzeResult(HashMap bAnalysisResult) {
        Set bKeys = bAnalysisResult.keySet();
        for (String bKey : bKeys) {
            List bValues = (List)bAnalysisResult.get(bKey);
            System.out.println("Found related " + bKey + " with these IDs " + bValues.toString());
        }
    }
}

