/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMObjectPath;

public class CapabilityUpdatePostProcess
extends DiscoverProcess {
    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("CapabilityUpdatePostProcess", null, null, null, null, null)};
    }

    public CapabilityUpdatePostProcess() {
        this("CapabilityData Update Post Processing");
    }

    protected CapabilityUpdatePostProcess(String pName) {
        super(pName, false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"CapabilityUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            try {
                mCon = ServiceUtils.getConnection();
                StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
                String mRaidLevels = this.getRAIDLevels(mCon, mDeviceID);
                int mNumOfVols = this.getNumberOfVolumes(mStorageSubsystem);
                List mCapabilityDataIDs = this.getCapabilityObjects(mCon, mDeviceID);
                this.updateCapabilityObjects(mCon, mCapabilityDataIDs, mRaidLevels, mNumOfVols);
                mCon.commit();
                Result result = mReturn = new Result(0);
                return result;
            }
            catch (Exception pEx) {
                if (mCon != null) {
                    try {
                        mCon.rollback();
                    }
                    catch (SQLException pInnerEx) {
                        // empty catch block
                    }
                }
                mReturn = new Result(1);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
            }
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilityObjects(DBConnection pCon, List pCapabilityList, String pRaidLevel, int pNumOfVols) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"updateCapabilityObjects", (Object[])new Object[]{pCon, pCapabilityList, pRaidLevel, new Integer(pNumOfVols)});
        try {
            CapabilityData mCurrCDInst = new CapabilityData();
            Iterator mCDIt = pCapabilityList.iterator();
            while (mCDIt.hasNext()) {
                int mCDID = (Integer)mCDIt.next();
                mCurrCDInst.clear();
                mCurrCDInst.setCapabilityDataId(mCDID);
                mCurrCDInst.retrieve(pCon);
                if (mCurrCDInst.getNumVolumes() > 0L) {
                    pNumOfVols = 0;
                    mLTH.traceInfo("NumberVolumes already set to :" + mCurrCDInst.getNumVolumes());
                }
                mCurrCDInst.clear();
                mCurrCDInst.setCapabilityDataId(mCDID);
                mCurrCDInst.setRaidLevels(pRaidLevel);
                if (pNumOfVols > 0) {
                    mCurrCDInst.setNumVolumes((long)pNumOfVols);
                    mLTH.traceInfo("NumberVolumes set to :" + pNumOfVols);
                }
                mCurrCDInst.update(pCon);
            }
        }
        finally {
            mLTH.exit((Object)"void");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCapabilityObjects(DBConnection pCon, int pDeviceID) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getCapabilityObjects", (Object[])new Object[]{pCon, new Integer(pDeviceID)});
        ArrayList<Integer> mReturn = new ArrayList<Integer>();
        try {
            String mSchema = pCon.getSchema();
            String mSQLStatement = "select DISTINCT CAPABILITY_DATA_ID from " + mSchema + "." + CimkeySubsystem.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + pDeviceID + ")";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            DBResultSet mDBResult = ComplexQuery.sqlQuery((DBConnection)pCon, (String)mSQLStatement, null);
            while (mDBResult.next()) {
                mReturn.add(new Integer(mDBResult.getInt(1)));
            }
            mDBResult.close();
            mLTH.traceHigh("Query result: " + DiskMessageHelper.toMsgString(mReturn));
            ArrayList<Integer> arrayList = mReturn;
            return arrayList;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    protected int getNumberOfVolumes(StorageSubsystem pSubSystem) throws SQLException {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRAIDLevels(DBConnection pCon, int pDeviceID) throws SQLException {
        String string;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getRAIDLevels", (Object[])new Object[]{pCon, new Integer(pDeviceID)});
        StringBuffer mReturnBuffer = new StringBuffer();
        String mReturn = null;
        try {
            String mSchema = pCon.getSchema();
            String mSQLStatement = "select DISTINCT REDUNDANCY from " + mSchema + "." + StorageVolume.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + pDeviceID + ")";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            DBResultSet mDBResult = ComplexQuery.sqlQuery((DBConnection)pCon, (String)mSQLStatement, null);
            while (mDBResult.next()) {
                mReturnBuffer.append(mDBResult.getInt(1));
                mReturnBuffer.append(",");
            }
            mDBResult.close();
            mLTH.traceHigh("Query result: " + mReturnBuffer.toString());
            mReturn = mReturnBuffer.toString();
            string = mReturn = mReturn.trim().length() > 0 ? mReturn.substring(0, mReturn.length() - 1) : "";
        }
        catch (Throwable throwable) {
            mLTH.exit(mReturn);
            throw throwable;
        }
        mLTH.exit((Object)mReturn);
        return string;
    }
}

