/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.interfaces.ParameterException;

public class DiskProbeDispatcher
extends DiscoverProcess
implements DiscoveryConstants {
    public DiskProbeDispatcher(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"SUBSYSTEMIDS_PARAM", "DEVICEIDS_PARAM", "COLLECTIONTYPE_PARAM"}, new String[]{String[].class.getName(), String[].class.getName(), Integer.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request pProbeRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"probeDiskDispatcher", (Object[])new Object[]{pParameters});
        try {
            String mProbeProcessName;
            IDiscover mDiscoverProxy = (IDiscover)DiskActivator._serviceHelper.bindLocal("DiscoverService");
            String[] mSubsystemIDs = (String[])pParameters.get("SUBSYSTEMIDS_PARAM");
            String[] mDeviceIDs = (String[])pParameters.get("DEVICEIDS_PARAM");
            Integer mCollectionType = (Integer)pParameters.get("COLLECTIONTYPE_PARAM");
            switch (mCollectionType) {
                case 2: {
                    mProbeProcessName = "collectDataFromStorageSubsystem";
                    break;
                }
                case 4: {
                    mProbeProcessName = "collectSHWIDsFromStorageSubsystem";
                    break;
                }
                default: {
                    mProbeProcessName = "collectCompleteStorageSubsystem";
                }
            }
            for (int mLoop = 0; mLoop < mSubsystemIDs.length; ++mLoop) {
                Hashtable<String, String> mParams = new Hashtable<String, String>();
                mParams.put("SUBSYSTEMID", mSubsystemIDs[mLoop]);
                mParams.put("DEVICEID", mDeviceIDs[mLoop]);
                HashMap<String, Object[]> mDispParams = new HashMap<String, Object[]>();
                mDispParams.put("Request", new Object[]{mProbeProcessName, mParams});
                String mResult = this.getDiscoverRouterService().perform(Discover.frontEndProcessHandler, mDispParams, new Integer(pProbeRequest.getId()).toString())[0];
                mLTH.traceInfo("frontEndProcessHandler called with :" + mParams);
            }
        }
        finally {
            mLTH.exit(null);
        }
        return new Result(0);
    }
}

