/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMObjectPath;

public class ISAssignedGenericUpdatePostProcess
extends DiscoverProcess {
    public ISAssignedGenericUpdatePostProcess() {
        this("IS_Assigned Update Post Processing");
    }

    protected ISAssignedGenericUpdatePostProcess(String pName) {
        super(pName, false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"IS_AssignedGenericUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("ISAssignedUpdatePostProcess", null, null, null, null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            ISAssignedGenericUpdatePostProcess.setIS_ASSIGNED(Integer.toString(mStorageSubsystem.getSubsystemId()), mCon);
            mReturn = new Result(0);
            mCon.commit();
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIS_ASSIGNED(String pSSID, DBConnection pCon) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"ISAssignedGenericUpdatePostProcess", (String)"setIS_ASSIGNED", (Object[])new Object[]{pCon, pSSID});
        try {
            String mSQLStatement = "update " + StorageVolume.getTablename() + "  set " + "IS_ASSIGNED" + " =  1  where " + "SVID" + " IN ( select DISTINCT " + "VOLUME_ID" + " from " + DataPath.getTablename() + " where  " + "SUBSYSTEM_ID" + " = " + pSSID + " )  ";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            int mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            pCon.commit();
            mLTH.traceInfo("Updated rows : " + mReturn);
            mSQLStatement = "update " + StorageVolume.getTablename() + "  set " + "IS_ASSIGNED" + " =  0  where " + "SVID" + " NOT IN ( select DISTINCT " + "VOLUME_ID" + " from " + DataPath.getTablename() + " where  " + "SUBSYSTEM_ID" + " = " + pSSID + " )  AND " + "SUBSYSTEM_ID" + " = " + pSSID;
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            mLTH.traceInfo("Updated rows : " + mReturn);
            pCon.commit();
        }
        finally {
            mLTH.exit(null);
        }
    }
}

