/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.DiskManagerRCs;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.OverheadUpdatePostProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericSubsystemProcess;
import org.eclipse.aperi.disk.collection.SubsystemPostCollectionProcess;
import org.eclipse.aperi.disk.collection.step.CommitStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeGenericArraySubsystemProcess
extends ProbeGenericSubsystemProcess
implements DiscoveryConstants,
DiskManagerRCs {
    protected static final String COLLECT_PHYSICALPACKAGE_FROM_ARRAY = "collectPhysicalPackageForArray";
    protected static final String COLLECT_PHYSICALPACKAGE_DISKDRIVE = "collectPhysicalPackage_DiskDrive";
    protected static final String COLLECT_PHYSICALPACKAGE_PHYSICALMEDIA = "collectPhysicalPackage_PhysicalMedia";

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("collectDataFromStorageSubsystem", null, "Array", null, null, null)};
    }

    public static void registerSteps(IDiscoverRouterService pRouter) {
        pRouter.addProcess(COLLECT_PHYSICALPACKAGE_FROM_ARRAY, (IDiscoverProcess)new AssociatorCIMQuery("Collect PhysicalPackage for Array Controller", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComputerSystemPackage", (String)"CIM_PhysicalPackage", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_PHYSICALPACKAGE_DISKDRIVE, (IDiscoverProcess)new AssociatorCIMQuery("Collect PhysicalPackage for Array: DiskDrive", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_Realizes", (String)"CIM_DiskDrive", null, null), "CIM_PhysicalPackage", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_PHYSICALPACKAGE_PHYSICALMEDIA, (IDiscoverProcess)new AssociatorCIMQuery("Collect PhysicalPackage for Array: PhysicalMedia", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_PackagedComponent", (String)"CIM_PhysicalMedia", null, null), "CIM_PhysicalPackage", CIMInstance.class.getName(), false));
        pRouter.addProcess("SubsystemPostCollectionProcess", (IDiscoverProcess)new SubsystemPostCollectionProcess());
        pRouter.addProcess("OverheadUpdatePostProcess", (IDiscoverProcess)new OverheadUpdatePostProcess());
    }

    public ProbeGenericArraySubsystemProcess() {
        super("collectDataFromStorageSubsystem", false);
    }

    public ProbeGenericArraySubsystemProcess(String description, boolean mainProcess) {
        super(description, mainProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        Result mResult;
        block24: {
            boolean mStatus;
            DiskCIMProcessor mProcessor;
            String mSubsystemID;
            String mSubSystemLogName;
            LogTraceHelper mLTH;
            block22: {
                mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)((Object)this), (String)"ProbeGenericArraySubsystemProcess.process", (Object[])new Object[]{pParameters});
                mResult = new Result(10010);
                mSubSystemLogName = (String)pParameters.get("SUBSYSTEMID");
                mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
                mLTH.logMsg("HWN021708I", new Object[]{mSubSystemLogName});
                pParameters = DiscoverUtils.setProbeTimeout((Map)pParameters, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Probe.Timeout.Array", (long)0L), (LogTraceHelper)mLTH);
                mProcessor = new DiskCIMProcessor(pDiscoverRequest.getScannerId());
                mStatus = false;
                CapabilityData mCapabData = (CapabilityData)pParameters.get("CAPABILITY");
                IStep collectNodesFromComputerSystem = this.getStepCollectNodesFromComputerSystem(mProcessor, mLTH);
                DiscoverStep collectFCPortsFromComputerSystem = new DiscoverStep("collectFCPortsFromComputerSystem", null, (CIMProcessor)mProcessor, mLTH);
                IStep collectPoolsFromComputerSystem = this.getStepCollectPoolsFromComputerSystem(mProcessor, mCapabData, mSubSystemLogName, mLTH);
                IStep collectVolumeSettings = this.getStepCollectVolumeSettings(mProcessor, mLTH);
                DiscoverStep collectClientSettingDataFromComputerSystem = new DiscoverStep("collectClientSettingDataFromComputerSystem", null, (CIMProcessor)mProcessor, mLTH);
                CIMObjectPath mCIMObjPath = (CIMObjectPath)pParameters.get("TL_CS");
                mProcessor.initializeForSubsystemProbe(pParameters);
                String mMigrated = this.checkAndHandleMigratedSubsystem(mSubsystemID);
                CIMInstance mCIMSubsystem = new CIMInstance(mCIMObjPath);
                pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                Hashtable mRefDBKeys = (Hashtable)mProcessor.getDBReferences().get(mCIMSubsystem.getClassName());
                mRefDBKeys.put("ref_subsystem_migrated", mMigrated);
                Hashtable<String, Hashtable> mDBKeys = new Hashtable<String, Hashtable>();
                mProcessor.start(pDiscoverRequest.getId());
                mStatus = true;
                try {
                    ProbeGenericArraySubsystemProcess.setCollectionStatus(mSubsystemID, 2, true, false);
                    if (mStatus) {
                        mLTH.logMsg("HWN021712I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10011);
                        mStatus = collectNodesFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021713I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10012);
                        mStatus = collectFCPortsFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021716I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10013);
                        mStatus = collectPoolsFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021717I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10014);
                        mStatus = collectVolumeSettings.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                    if (mStatus) {
                        mDBKeys = new Hashtable();
                        mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                        mProcessor.setDBReferences(mDBKeys);
                        mLTH.logMsg("HWN021718I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10015);
                        mStatus = collectClientSettingDataFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                }
                catch (Throwable bEx) {
                    this.checkException(bEx, mLTH, pParameters);
                    mStatus = false;
                }
                finally {
                    mProcessor.end(pDiscoverRequest.getId());
                }
                if (!mStatus) break block22;
                mLTH.logMsg("HWN021719I", new Object[]{mSubSystemLogName});
                mResult.setRc(10016);
                ProbePerfTracker.ProbeAction bProbePostProcessing = TrackProbePerformance.startProbeAction((String)this.getScannerId(pParameters), (int)ProbePerfTracker.POST_PROCESSING);
                this.getDiscoverRouterService().perform("SubsystemPostCollectionProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                this.getDiscoverRouterService().perform("OverheadUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                this.getDiscoverRouterService().perform("CapabilityUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                this.getDiscoverRouterService().perform("BackendControllerPostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)bProbePostProcessing);
                mResult.setRc(0);
            }
            Object var23_24 = null;
            try {
                ProbeGenericArraySubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
            }
            catch (Exception bEx2) {
                mResult.setRc(10017);
                mLTH.traceError("HWN021503E", (Throwable)bEx2);
                mLTH.logMsg("HWN021503E", null);
            }
            if (mProcessor != null) {
                mProcessor.shutdown(pDiscoverRequest.getId());
                mProcessor = null;
            }
            mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
            mLTH.exit((Object)mResult);
            {
                break block24;
                catch (Throwable bEx) {
                    this.checkException(bEx, mLTH, pParameters);
                    mStatus = false;
                    Object var23_25 = null;
                    try {
                        ProbeGenericArraySubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
                    }
                    catch (Exception bEx2) {
                        mResult.setRc(10017);
                        mLTH.traceError("HWN021503E", (Throwable)bEx2);
                        mLTH.logMsg("HWN021503E", null);
                    }
                    if (mProcessor != null) {
                        mProcessor.shutdown(pDiscoverRequest.getId());
                        mProcessor = null;
                    }
                    mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
                    mLTH.exit((Object)mResult);
                }
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                try {
                    ProbeGenericArraySubsystemProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 1, true, false);
                }
                catch (Exception bEx2) {
                    mResult.setRc(10017);
                    mLTH.traceError("HWN021503E", (Throwable)bEx2);
                    mLTH.logMsg("HWN021503E", null);
                }
                if (mProcessor != null) {
                    mProcessor.shutdown(pDiscoverRequest.getId());
                    mProcessor = null;
                }
                mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
                mLTH.exit((Object)mResult);
                throw throwable;
            }
        }
        return mResult;
    }

    public IStep getStepCollectPhysicalPackage(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectPhysicalPackage = new DiscoverStep(COLLECT_PHYSICALPACKAGE_FROM_ARRAY, "CIM_PhysicalPackage", (CIMProcessor)pProcessor, pLTH);
        DiscoverStep collectPhysicalPackage_DiskDrive = new DiscoverStep(COLLECT_PHYSICALPACKAGE_DISKDRIVE, null, (CIMProcessor)pProcessor, pLTH);
        DiscoverStep collectPhysicalPackage_PhysicalMedia = new DiscoverStep(COLLECT_PHYSICALPACKAGE_PHYSICALMEDIA, null, (CIMProcessor)pProcessor, pLTH);
        collectPhysicalPackage.addNextStep((IStep)collectPhysicalPackage_DiskDrive);
        collectPhysicalPackage.addNextStep((IStep)collectPhysicalPackage_PhysicalMedia);
        return collectPhysicalPackage;
    }

    public IStep getStepCollectNodesFromComputerSystem(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectNodesFromComputerSystem = new DiscoverStep("collectNodesFromComputerSystem", "CIM_ComputerSystemNodes", null, pLTH);
        DiscoverStep collectFCPortsFromNodes = new DiscoverStep("collectFCPortsFromNode", null, (CIMProcessor)pProcessor, pLTH);
        CommitStep mCS = new CommitStep(pProcessor);
        collectNodesFromComputerSystem.addNextStep((IStep)collectFCPortsFromNodes);
        collectNodesFromComputerSystem.addNextStep((IStep)mCS);
        return collectNodesFromComputerSystem;
    }
}

