/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeGenericVolumeProcess
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants {
    protected static final String COLLECT_POOL_FROM_VOLUME = "collectPoolFromVolume";
    protected static final String COLLECT_VOLUMESETTINGS_FROM_VOLUME = "collectVolumeSettingsFromVolume";
    protected static final String COLLECT_EXTENTDATA_FROM_STORAGEVOLUME = "collectExtentDataFromStorageVolume";

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("probeVolumeProcessName", null, null, null, null, null)};
    }

    public static void registerSteps(IDiscoverRouterService pRouter) {
        pRouter.addProcess(COLLECT_POOL_FROM_VOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect Pool from Volume", Query.associators((String)"CIM_StorageVolume", (String)"CIM_AllocatedFromStoragePool", (String)"CIM_StoragePool", null, null), "CIM_StorageVolume", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_VOLUMESETTINGS_FROM_VOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageSettings from Volume", Query.associators((String)"CIM_StorageVolume", (String)"CIM_ElementSettingData", (String)"CIM_StorageSetting", null, null), "CIM_StorageVolume", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_EXTENTDATA_FROM_STORAGEVOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData from Volume", Query.associatorNames((String)"CIM_StorageVolume", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", null, null), "CIM_StorageVolume", CIMInstance.class.getName(), false));
    }

    public ProbeGenericVolumeProcess() {
        super("probeVolumeProcessName", false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public ProbeGenericVolumeProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        int n;
        boolean status;
        String mSubSystemLogName;
        LogTraceHelper mLTH;
        block35: {
            mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)((Object)this), (String)"ProbeGenericVolumeProcess.process", (Object[])new Object[]{pParameters});
            mSubSystemLogName = (String)pParameters.get("SUBSYSTEMID");
            mLTH.logMsg("HWN021708I", new Object[]{mSubSystemLogName});
            DiskCIMProcessor mProcessor = new DiskCIMProcessor(pDiscoverRequest.getScannerId());
            mProcessor.initializeForSubsystemProbe(pParameters);
            status = true;
            try {
                CapabilityData mCapabData = (CapabilityData)pParameters.get("CAPABILITY");
                DiscoverStep collectPool = new DiscoverStep(COLLECT_POOL_FROM_VOLUME, null, (CIMProcessor)mProcessor);
                DiscoverStep collectVolumeSettings = new DiscoverStep(COLLECT_VOLUMESETTINGS_FROM_VOLUME, null, (CIMProcessor)mProcessor);
                DiscoverStep collectExtentData = new DiscoverStep(COLLECT_EXTENTDATA_FROM_STORAGEVOLUME, null, (CIMProcessor)mProcessor);
                String mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
                CIMObjectPath mSubsystemCOP = (CIMObjectPath)pParameters.get("TL_CS");
                String mVolumeID = (String)pParameters.get("VOLUMEID_PARAM");
                DBConnection con = ServiceUtils.getConnection();
                Object obj = pParameters.get("CIMOM");
                int mNamespaceID = -1;
                CIMInstance mCIMVolume = null;
                String mName = null;
                int mSVID = -1;
                int mFormat = -1;
                int mSubSystemID = -1;
                try {
                    Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                    Vector<String> bColums = new Vector<String>();
                    int mCimomID = -1;
                    bColums.add(new String("REG_CIMOM_ID"));
                    mWhereClause.put(TResRegisteredCimomTable.getColumnInfo((String)"SERVICE_URL"), (String)((Object[])obj)[0]);
                    DBResultSet bDBRes = DBQueryAssistant.performRetrieve((String)TResRegisteredCimomTable.getTablename(), (DBConnection)con, mWhereClause, bColums);
                    if (bDBRes.next()) {
                        mCimomID = bDBRes.getInt("REG_CIMOM_ID");
                    }
                    bDBRes.closeAll();
                    con.commit();
                    mWhereClause.clear();
                    bColums.clear();
                    bColums.add(new String("CIM_NAMESPACE_ID"));
                    mWhereClause.put(TResCimom2namespaceTable.getColumnInfo((String)"CIMOM_ID"), String.valueOf(mCimomID));
                    mWhereClause.put(TResCimom2namespaceTable.getColumnInfo((String)"NAMESPACE"), (String)((Object[])obj)[1]);
                    bDBRes = DBQueryAssistant.performRetrieve((String)TResCimom2namespaceTable.getTablename(), (DBConnection)con, mWhereClause, bColums);
                    if (bDBRes.next()) {
                        mNamespaceID = bDBRes.getInt("CIM_NAMESPACE_ID");
                    }
                    bDBRes.closeAll();
                    con.commit();
                    CimkeyVolume mCimVolume = ExternalKeyManager.getStorageVolumeCIM((int)Integer.parseInt(mVolumeID), (int)mNamespaceID, (DBConnection)con);
                    mWhereClause.clear();
                    bColums.clear();
                    bColums.add(new String("NAME_FORMAT"));
                    bColums.add(new String("SVID"));
                    bColums.add(new String("NAME"));
                    bColums.add(new String("SUBSYSTEM_ID"));
                    mWhereClause.put(TResStorageVolumeTable.getColumnInfo((String)"SVID"), String.valueOf(mCimVolume.getVolumeId()));
                    bDBRes = DBQueryAssistant.performRetrieve((String)TResStorageVolumeTable.getTablename(), (DBConnection)con, mWhereClause, bColums);
                    if (bDBRes.next()) {
                        mName = bDBRes.getString("NAME");
                        mFormat = bDBRes.getInt("NAME_FORMAT");
                        mSVID = bDBRes.getInt("SVID");
                        mSubSystemID = bDBRes.getInt("SUBSYSTEM_ID");
                    }
                    bDBRes.closeAll();
                    con.commit();
                    CIMObjectPath mCOP = ExternalKeyManager.getCIMObjectPath((CimkeyVolume)mCimVolume, (String)((String)((Object[])obj)[1]));
                    mCIMVolume = new CIMInstance(mCOP);
                    CIMInstance mCIMSubsystem = new CIMInstance(mSubsystemCOP);
                    pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                    pParameters.put("CIM_StorageVolume", mCIMVolume);
                    Hashtable mRefDBKeys = mProcessor.getDBReferences();
                    Hashtable mHashVolume = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mCIMVolume);
                    Hashtable mHashSubsystem = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mCIMSubsystem);
                    Hashtable<String, String> mRefVolumeDBKeys = new Hashtable<String, String>();
                    mRefVolumeDBKeys.put("ref_name", mName);
                    mRefVolumeDBKeys.put("ref_name_format", String.valueOf(mFormat));
                    mRefVolumeDBKeys.put("ref_storagevolume_id", String.valueOf(mSVID));
                    mRefVolumeDBKeys.put("ref_toplevelsystem_id", String.valueOf(mSubSystemID));
                    mRefDBKeys.put(mCIMVolume.getClassName(), mRefVolumeDBKeys);
                    pParameters.put(mCIMVolume.getClassName(), mRefVolumeDBKeys);
                    pParameters.put(mCIMSubsystem.getClassName(), mHashSubsystem);
                    con.commit();
                    con.close();
                    con = null;
                    mProcessor.start(pDiscoverRequest.getId());
                    if (status) {
                        mLTH.logMsg("HWN021716I", new Object[]{mSubSystemLogName});
                        status = collectPool.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                        mProcessor.doCommit(mLTH);
                    }
                    if (status) {
                        mLTH.logMsg("HWN021717I", new Object[]{mSubSystemLogName});
                        status = collectVolumeSettings.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                        mProcessor.doCommit(mLTH);
                    }
                    if (status) {
                        mLTH.logMsg("HWN021717I", new Object[]{mSubSystemLogName});
                        status = collectExtentData.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                    }
                }
                catch (SQLException e) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException bInnerEx) {
                        // empty catch block
                    }
                    mLTH.traceError("HWN021503E", (Throwable)e);
                    status = false;
                }
                catch (Throwable bEx) {
                    this.checkException(bEx, mLTH, pParameters);
                    status = false;
                }
                finally {
                    mProcessor.end(pDiscoverRequest.getId());
                }
                try {
                    if (status) {
                        mLTH.logMsg("HWN021719I", new Object[]{mSubSystemLogName});
                        this.getDiscoverRouterService().perform("SubsystemPostCollectionProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                    }
                }
                catch (Throwable bEx) {
                    try {
                        this.checkException(bEx, mLTH, pParameters);
                        status = false;
                        break block35;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (con != null && !con.isClosed()) {
                                con.close();
                            }
                        }
                        catch (SQLException e) {
                            mLTH.traceError("HWN021503E", (Throwable)e);
                            status = false;
                        }
                    }
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    mLTH.traceError("HWN021503E", (Throwable)e);
                    status = false;
                }
            }
            finally {
                if (mProcessor != null) {
                    mProcessor.shutdown(pDiscoverRequest.getId());
                    mProcessor = null;
                }
            }
        }
        mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
        mLTH.exit((Object)new Result(status ? 0 : 1));
        if (status) {
            n = 0;
            return new Result(n);
        }
        n = 1;
        return new Result(n);
    }

    public String getScannerId(Map pParameters) throws ParameterException {
        String prefix = "PS1";
        String[] mCIMOM = (String[])pParameters.get("CIMOM");
        if (mCIMOM == null || mCIMOM.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String mCIMOMServiceURL = mCIMOM[0];
        String mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
        if (mSubsystemID == null) {
            throw new ParameterException("Missing parameter: SUBSYSTEMID");
        }
        String mScannerId = prefix + ":" + mCIMOMServiceURL + "+" + mSubsystemID;
        return mScannerId;
    }
}

