/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.CreationClassName;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.SystemNames;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMEnumeration;

public class SubProbeVolume {
    ConfigurationParameter cParams;
    private static final String PROCESSID_PREFIX = "C";
    private VolumeManagement cVolumeManagement = null;

    public SubProbeVolume(ConfigurationParameter pParams, VolumeManagement pVolumeManagement) {
        this.cParams = pParams;
        this.cVolumeManagement = pVolumeManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapperResult persistVolumeOrPool(CIMInstance pInst, String pPoolString, CIMObjectPath pNewVolume) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"persistVolumeOrPool", (Object[])new Object[]{pInst, pPoolString, pNewVolume});
        MapperResult mRes = null;
        try {
            String bOriginalClassname = null;
            bOriginalClassname = pNewVolume != null ? "CIM_StorageVolume" : "CIM_StoragePool";
            DBConnection mCon = null;
            ChangeDetection mChangeDetection = null;
            Hashtable mParam = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)pInst);
            try {
                IDBAttributeMapper mMapper;
                mCon = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                mCon.setAutoCommit(false);
                StorageSubsystem mStorageSystem = this.cParams.getStorageSubsystem();
                StoragePool mSP = null;
                if (pPoolString != null) {
                    mSP = ExternalKeyManager.getStoragePool((String)pPoolString, (int)mStorageSystem.getSubsystemId(), (DBConnection)mCon);
                }
                mCon.commit();
                DBHelper.putObjectIntoHashtable(mParam, "ref_toplevelsystem_id", Integer.toString(mStorageSystem.getSubsystemId()));
                DBHelper.putObjectIntoHashtable(mParam, "ref_toplevelsystem_name", mStorageSystem.getName());
                DBHelper.putObjectIntoHashtable(mParam, "ref_toplevelsystem_nameformat", Integer.toString(mStorageSystem.getNameFormat()));
                DBHelper.putObjectIntoHashtable(mParam, "ref_namespace", this.cParams.getStorageSubsystemCIMOP().getNameSpace());
                DBHelper.putObjectIntoHashtable(mParam, "ref_serviceurl", this.cParams.getCimom().getServiceUrl());
                if (mSP != null) {
                    DBHelper.putObjectIntoHashtable(mParam, "ref_storagepool_id", Integer.toString(mSP.getPoolId()));
                    DBHelper.putObjectIntoHashtable(mParam, "ref_classname", mSP.getClassName());
                }
                if ((mMapper = MapperRouter.getMapperRouter().findMapper(pInst.getClassName(), this.cParams.getCapability().getSmisVersion(), mStorageSystem.getModel(), this.cParams.getCimom().getSoftwareLevel(), null, bOriginalClassname)) == null) {
                    mLTH.traceHigh("Could not retrieve mapper");
                    return mRes;
                }
                int mRetries = 0;
                int mDeadlockRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
                int mMaxRetryInterval = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
                while (mRetries < mDeadlockRetries) {
                    try {
                        mChangeDetection = new ChangeDetection(mCon);
                        mRes = mMapper.persist(mCon, mParam, null);
                        HashMap mTouchedEntities = new HashMap();
                        DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getInsertedRows()));
                        DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getUpdatedRows()));
                        mCon.commit();
                        mChangeDetection.complete(mCon, mTouchedEntities, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
                        mCon.commit();
                        if (mSP == null) return mRes;
                        this.cVolumeManagement.indicateModifiedEntity(TResStoragePoolTable.getTablename(), String.valueOf(mSP.getPoolId()));
                        return mRes;
                    }
                    catch (SQLException exp) {
                        if (!SQLExceptionHelper.isDeadlock((DBConnection)mCon, (SQLException)exp)) throw exp;
                        Random mRandomGen = new Random();
                        mLTH.traceWarning("Deadlock during retry (" + mRetries + "/" + mDeadlockRetries + ")");
                        ++mRetries;
                        try {
                            long mWaitInt = (long)mRandomGen.nextInt(mMaxRetryInterval) * (long)mRetries;
                            mLTH.traceHigh("Waiting for " + mWaitInt + "msecs before retrying deadlocked operations");
                            Thread.sleep(mWaitInt);
                        }
                        catch (InterruptedException pIE) {}
                        continue;
                        return mRes;
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (mCon == null) throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                    mCon.rollback();
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                }
                finally {
                    mChangeDetection.cancel();
                }
            }
            finally {
                if (mCon != null) {
                    try {
                        mCon.close();
                    }
                    catch (SQLException pEx) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                    }
                }
            }
        }
        finally {
            mLTH.exit(mRes);
        }
    }

    public Vector retrieveAssociatedExtents(CIMObjectPath pVolume) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"retrieveAssociatedExtents", (Object[])new Object[]{pVolume});
        Vector<String> mExtents = new Vector<String>();
        try {
            CIMEnumeration mCIMExtents = (CIMEnumeration)this.cParams.getCIMClientWrapper().associatorNames(pVolume, "CIM_BasedOn", "CIM_StorageExtent", null, null, mLTH);
            if (!mCIMExtents.hasMoreElements()) {
                mCIMExtents.close();
                mLTH.traceError("WARNING: No StorageExtents returned from CIMOM.", null);
                mLTH.traceError("If this message is generated when a volume with size 0 is created it can be ignored.", null);
                Vector<String> vector = mExtents;
                return vector;
            }
            while (mCIMExtents.hasMoreElements()) {
                CIMObjectPath mCurObj = (CIMObjectPath)mCIMExtents.nextElement();
                String mCurExtentID = this.getExtentIDFromCIMObjectPath(mCurObj);
                mExtents.add(mCurExtentID);
            }
            mCIMExtents.close();
            Vector<String> vector = mExtents;
            return vector;
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cParams.getCIMClientWrapper().toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cParams.getCIMClientWrapper(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (IOException e) {
            mLTH.traceError("Internal error: IOException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mExtents);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getExtentIDFromCIMObjectPath(CIMObjectPath pExtentPath) {
        LogTraceHelper mLTH;
        String mRes;
        block12: {
            mRes = null;
            DBConnection mCon = ServiceUtils.getConnection();
            mLTH = LogTraceHelper.entry((Object)this, (String)"getExtentIDFromCIMObjectPath", (Object[])new Object[]{pExtentPath});
            try {
                String mCreationClassName = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pExtentPath, (String)"CreationClassName");
                String mDeviceID = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pExtentPath, (String)"DeviceID");
                String mSystemCreationClassName = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pExtentPath, (String)"SystemCreationClassName");
                String mSystemName = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pExtentPath, (String)"SystemName");
                String mSchema = mCon.getSchema();
                String mSelectCreationClassName = "select ID from " + mSchema + "." + CreationClassName.getTablename() + " where " + "NAME" + " like '" + mCreationClassName + "'";
                String mSelectSystemCreationClassName = "select ID from " + mSchema + "." + CreationClassName.getTablename() + " where " + "NAME" + " like '" + mSystemCreationClassName + "'";
                String mSelectSystemName = "select SYSTEM_NAMES_ID from " + mSchema + "." + SystemNames.getTablename() + " where " + "SYSTEM_NAME" + " like '" + mSystemName + "'";
                String mCompleteSQL = "select STORAGE_EXTENT_ID from " + mSchema + "." + StorageExtent.getTablename() + " where " + "CREATION_CLASS_NAME_ID" + " in (" + mSelectCreationClassName + ") and " + "SYSTEM_CREATION_CLASS_NAME_ID" + " in (" + mSelectSystemCreationClassName + ") and " + "SYSTEM_NAMES_ID" + " in (" + mSelectSystemName + ") and " + "DEVICE_ID" + " like '" + mDeviceID + "'";
                mLTH.traceInfo("Sending DB2 complex query for ExtentCOP to ExtentID: " + mCompleteSQL);
                DBResultSet mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mCompleteSQL, null);
                while (mDBR.next()) {
                    mRes = mDBR.getString(1);
                }
                mDBR.close();
                mCon.commit();
                if (mCon == null) break block12;
            }
            catch (SQLException mEx) {
                try {
                    try {
                        mCon.rollback();
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
                    }
                    catch (SQLException bInnerEx) {
                        // empty catch block
                    }
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
                }
                catch (Throwable throwable) {
                    if (mCon != null) {
                        try {
                            mCon.close();
                        }
                        catch (SQLException pEx) {
                            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                        }
                    }
                    mLTH.exit(mRes);
                    throw throwable;
                }
            }
            try {
                mCon.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
        }
        mLTH.exit((Object)mRes);
        return mRes;
    }
}

