/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.collection.SubProbeVolume;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMEnumeration;

public class SubProbeVolumeDS
extends SubProbeVolume {
    public SubProbeVolumeDS(ConfigurationParameter pParams, VolumeManagement pVolumeManagement) {
        super(pParams, pVolumeManagement);
    }

    public Vector retrieveAssociatedExtents(CIMObjectPath pVolume) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"retrieveAssociatedExtents", (Object[])new Object[]{pVolume});
        Vector<String> mExtents = new Vector<String>();
        try {
            int bMaxRetries = 5;
            int bRetryCount = 0;
            CIMEnumeration mCIMExtents = null;
            do {
                try {
                    Thread.sleep(bRetryCount * 1000);
                }
                catch (Exception bEx) {
                    // empty catch block
                }
                if (mCIMExtents == null) continue;
                mCIMExtents.close();
            } while (!(mCIMExtents = (CIMEnumeration)this.cParams.getCIMClientWrapper().associatorNames(pVolume, "CIM_BasedOn", "CIM_StorageExtent", null, null, mLTH)).hasMoreElements() && ++bRetryCount <= bMaxRetries);
            if (!mCIMExtents.hasMoreElements()) {
                mCIMExtents.close();
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021531E", (Object)this.cParams.getCIMClientWrapper().toString(), (Object)this.cParams.getStorageSubsystemID(), (LogTraceHelper)mLTH);
                mLTH.traceError("No StorageExtents returned from CIMOM, Device is not reachable", (Throwable)bEx);
                throw bEx;
            }
            while (mCIMExtents.hasMoreElements()) {
                CIMObjectPath mCurObj = (CIMObjectPath)mCIMExtents.nextElement();
                String mCurExtentID = this.getExtentIDFromCIMObjectPath(mCurObj);
                mExtents.add(mCurExtentID);
            }
            mCIMExtents.close();
            Vector<String> vector = mExtents;
            return vector;
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cParams.getCIMClientWrapper().toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cParams.getCIMClientWrapper(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (IOException e) {
            mLTH.traceError("Internal error: IOException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mExtents);
        }
    }
}

