/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;

public class HardwareIDMangementSVC
extends HardwareIDMangement {
    public HardwareIDMangementSVC(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClientWrapper, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClientWrapper, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createStorageHardwareIDs(ArrayList pWWPNs, String[] pHardwareIDNames, CIMObjectPath pStorageClientSettingDataCOP) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageHardwareIDs", (Object[])new Object[]{pWWPNs, pHardwareIDNames, pStorageClientSettingDataCOP});
        ArrayList mSTHWIDs = null;
        try {
            mSTHWIDs = super.createStorageHardwareIDs(pWWPNs, null, pStorageClientSettingDataCOP);
            mSTHWIDs = this.createCollections(mSTHWIDs);
        }
        catch (Throwable throwable) {
            mLTH.exit(mSTHWIDs);
            throw throwable;
        }
        mLTH.exit((Object)mSTHWIDs);
        return mSTHWIDs;
    }

    private ArrayList createCollections(ArrayList pHWIDs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createCollections", (Object[])new Object[]{pHWIDs});
        ArrayList<StorageHardwareID> mNewSTHWIDs = new ArrayList<StorageHardwareID>();
        try {
            for (StorageHardwareID mHWID : pHWIDs) {
                Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
                Vector bOutParams = new Vector();
                String[] mCOPArray = this.putCOPsIntoString(new CIMObjectPath[]{mHWID.getStorageHardwareIDCOP()});
                bInParams.add(new CIMArgument("HardwareIDs", new CIMValue((Object)mCOPArray, CIMDataType.getPredefinedType((int)24))));
                this.invokeCIMMethod(this.getHardwareIDManagementService(), "CreateHardwareIDCollection", bInParams, bOutParams);
                for (int j = 0; j < bOutParams.size(); ++j) {
                    CIMArgument bOut = (CIMArgument)bOutParams.get(j);
                    if (!bOut.getName().equals("Collection")) continue;
                    CIMObjectPath bCollectionCOP = (CIMObjectPath)bOut.getValue().getValue();
                    Enumeration hardwareID = this.cCimClient.associators(bCollectionCOP, "CIM_MemberOfCollection", "CIM_ManagedElement", "Collection", "Member", true, true, null, mLTH);
                    if (!hardwareID.hasMoreElements()) {
                        ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                        mLTH.traceError("No StorageHardwareID for HardwareIDCollection found", (Throwable)bEx);
                        throw bEx;
                    }
                    while (hardwareID.hasMoreElements()) {
                        CIMInstance mNewHWID = (CIMInstance)hardwareID.nextElement();
                        CIMObjectPath mNewPath = mNewHWID.getObjectPath();
                        StorageHardwareID mHardwareID = new StorageHardwareID(mHWID.getWWPN(), mNewHWID, mNewPath);
                        mNewSTHWIDs.add(mHardwareID);
                    }
                }
            }
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mNewSTHWIDs);
        }
        return mNewSTHWIDs;
    }

    private String[] putCOPsIntoString(CIMObjectPath[] pCOPs) {
        String[] bCOPStrings = new String[pCOPs.length];
        for (int i = 0; i < bCOPStrings.length; ++i) {
            bCOPStrings[i] = pCOPs[i].toString();
            bCOPStrings[i] = bCOPStrings[i].substring(bCOPStrings[i].indexOf(":") + 1);
        }
        return bCOPStrings;
    }
}

