/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.IOGroup;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class MappingManagementSVC
extends MappingManagement {
    public MappingManagementSVC(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
        this.cCapablities = pCapablities;
    }

    public CIMObjectPath retrieveIOGroupOfProtocolController(ProtocolControllerToPrivileges pProtocolControllerToPrivileges) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveIOGroupsOfProtocolController", (Object[])new Object[0]);
        CIMObjectPath mIOGroup = null;
        try {
            Enumeration mIOGroupEnum = this.cCimClient.associatorNames(pProtocolControllerToPrivileges.getProtocolController(), "IBMTSSVC_SystemController", "IBMTSSVC_IOGroup", "PartComponent", "GroupComponent", mLTH);
            while (mIOGroupEnum.hasMoreElements()) {
                mIOGroup = (CIMObjectPath)mIOGroupEnum.nextElement();
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mIOGroup);
        }
        return mIOGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMObjectPath createProtocolControllerWithPorts(CIMObjectPath pIOGroupCOP, CIMObjectPath pInitiator, CIMObjectPath pPrivilege) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllerWithPorts", (Object[])new Object[]{pIOGroupCOP, pInitiator, pPrivilege});
        CIMObjectPath mProtocolController = null;
        try {
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            mInParams.add(new CIMArgument("Protocol", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
            mInParams.add(new CIMArgument("Ports", new CIMValue((Object)this.putCOPsIntoString(new CIMObjectPath[]{pIOGroupCOP}), CIMDataType.getPredefinedType((int)24))));
            mInParams.add(new CIMArgument("Identity", new CIMValue((Object)pInitiator, CIMDataType.getPredefinedType((int)14))));
            this.invokeCIMMethod(this.getControllerConfigurationService(), "CreateProtocolControllerWithPorts", mInParams, mOutParams);
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument bOut = (CIMArgument)mOutParams.get(i);
                if (bOut.getName().compareTo("ProtocolController") != 0) continue;
                mProtocolController = (CIMObjectPath)bOut.getValue().getValue();
            }
        }
        finally {
            mLTH.exit(mProtocolController);
        }
        return mProtocolController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createProtocolControllers(ArrayList pStorageHardwareIDs, ArrayList pIOGroupCOPs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllers", (Object[])new Object[]{pStorageHardwareIDs, pIOGroupCOPs});
        ArrayList<ProtocolControllerToPrivileges> mProtocolControllers = new ArrayList<ProtocolControllerToPrivileges>();
        try {
            ArrayList mStorageHardwareIDsWithoutCollection = new ArrayList();
            ArrayList mHardwareIDCollections = this.cPlugin.getHardwareIDManagement().retrieveCollectionsForStorageHardwareIDs(pStorageHardwareIDs, mStorageHardwareIDsWithoutCollection);
            for (int bIOGroupLoop = 0; bIOGroupLoop < pIOGroupCOPs.size(); ++bIOGroupLoop) {
                CIMObjectPath bProtocolControllerCOP;
                int i;
                for (i = 0; i < mHardwareIDCollections.size(); ++i) {
                    bProtocolControllerCOP = this.createProtocolControllerWithPorts((CIMObjectPath)pIOGroupCOPs.get(bIOGroupLoop), ((HardwareIDCollection)mHardwareIDCollections.get(i)).getHardwareIDCollectionCOP(), null);
                    ArrayList mHWIDsOfCollection = ((HardwareIDCollection)mHardwareIDCollections.get(i)).getStorageHardwareIDs();
                    ProtocolControllerToPrivileges mNewPC = new ProtocolControllerToPrivileges(bProtocolControllerCOP, new PrivilegeToWWPNs(null, mHWIDsOfCollection.toArray(new StorageHardwareID[mHWIDsOfCollection.size()])));
                    mNewPC.setIOGroup((CIMObjectPath)pIOGroupCOPs.get(bIOGroupLoop));
                    mProtocolControllers.add(mNewPC);
                }
                for (i = 0; i < mStorageHardwareIDsWithoutCollection.size(); ++i) {
                    bProtocolControllerCOP = this.createProtocolControllerWithPorts((CIMObjectPath)pIOGroupCOPs.get(bIOGroupLoop), ((StorageHardwareID)mStorageHardwareIDsWithoutCollection.get(i)).getStorageHardwareIDCOP(), null);
                    ProtocolControllerToPrivileges mProtocolController = new ProtocolControllerToPrivileges(bProtocolControllerCOP, new PrivilegeToWWPNs(null, (StorageHardwareID)mStorageHardwareIDsWithoutCollection.get(i)));
                    mProtocolController.setIOGroup((CIMObjectPath)pIOGroupCOPs.get(bIOGroupLoop));
                    mProtocolControllers.add(mProtocolController);
                }
            }
        }
        finally {
            mLTH.exit(mProtocolControllers);
        }
        return mProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getProtocolControllersForMappings(ArrayList pStorageHardwareIDs, ArrayList pNewStorageHardwareIDs, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getProtocolControllersForMappings", (Object[])new Object[]{pStorageHardwareIDs, pNewStorageHardwareIDs, pParams});
        ArrayList<ProtocolControllerToPrivileges> mProtocolControllersToUse = new ArrayList<ProtocolControllerToPrivileges>();
        try {
            ArrayList mOldStorageHardwareIDs = (ArrayList)pStorageHardwareIDs.clone();
            ArrayList mNewStorageHardwareIDs = new ArrayList();
            if (!pNewStorageHardwareIDs.isEmpty()) {
                for (int i = 0; i < pNewStorageHardwareIDs.size(); ++i) {
                    int bIndex = pStorageHardwareIDs.indexOf(pNewStorageHardwareIDs.get(i));
                    mNewStorageHardwareIDs.add(pStorageHardwareIDs.get(bIndex));
                    mOldStorageHardwareIDs.remove(pStorageHardwareIDs.get(bIndex));
                }
            }
            ArrayList mStorageHardwareIDsWithoutPCs = new ArrayList();
            ArrayList mExistingProtocolControllers = this.retrieveProtocolControllersForMappings(mOldStorageHardwareIDs, mStorageHardwareIDsWithoutPCs, pParams.getVolumeCOPs());
            for (int i = 0; i < mExistingProtocolControllers.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolControllerToPrivileges = (ProtocolControllerToPrivileges)mExistingProtocolControllers.get(i);
                bProtocolControllerToPrivileges.setIOGroup(this.retrieveIOGroupOfProtocolController(bProtocolControllerToPrivileges));
                if (!pParams.getDifferentIOGroupIDs().contains(bProtocolControllerToPrivileges.getIOGroupID())) continue;
                mProtocolControllersToUse.add(bProtocolControllerToPrivileges);
            }
            ArrayList mNewProtocolControllers = this.createProtocolControllersForSomeIOGroups(pParams, mProtocolControllersToUse, mOldStorageHardwareIDs, mStorageHardwareIDsWithoutPCs);
            mProtocolControllersToUse.addAll(mNewProtocolControllers);
            mStorageHardwareIDsWithoutPCs.addAll(mNewStorageHardwareIDs);
            mNewProtocolControllers = this.createProtocolControllers(mStorageHardwareIDsWithoutPCs, pParams.getDifferentIOGroupCOPs());
            mProtocolControllersToUse.addAll(mNewProtocolControllers);
            ArrayList<ProtocolControllerToPrivileges> arrayList = mProtocolControllersToUse;
            return arrayList;
        }
        finally {
            mLTH.exit(mProtocolControllersToUse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList createProtocolControllersForSomeIOGroups(AssignStorageVolumesParameter pParams, ArrayList pProtocolControllersToUse, ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutPCs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createProtocolControllersForSomeIOGroups", (Object[])new Object[]{pParams, pProtocolControllersToUse, pStorageHardwareIDs, pStorageHardwareIDsWithoutPCs});
        ArrayList mNewProtocolControllers = new ArrayList();
        try {
            IOGroup bIOGroup;
            ArrayList mWWPNsWithPC = new ArrayList();
            for (int i = 0; i < pProtocolControllersToUse.size(); ++i) {
                ProtocolControllerToPrivileges bControllerToPrivileges = (ProtocolControllerToPrivileges)pProtocolControllersToUse.get(i);
                mWWPNsWithPC.addAll(bControllerToPrivileges.getWWPNs());
            }
            if (mWWPNsWithPC.size() == pParams.getDifferentIOGroupIDs().size() * (pStorageHardwareIDs.size() - pStorageHardwareIDsWithoutPCs.size())) {
                ArrayList i = mNewProtocolControllers;
                return i;
            }
            if (pProtocolControllersToUse.size() > pParams.getDifferentIOGroupIDs().size() * (pStorageHardwareIDs.size() - pStorageHardwareIDsWithoutPCs.size())) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                mLTH.traceError("Retrieved more ProtocolControllers than expected", (Throwable)bEx);
                throw bEx;
            }
            ArrayList<IOGroup> mIOGroups = new ArrayList<IOGroup>();
            for (int i = 0; i < pProtocolControllersToUse.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolControllerToPrivileges = (ProtocolControllerToPrivileges)pProtocolControllersToUse.get(i);
                int bIndex = mIOGroups.indexOf(new IOGroup(bProtocolControllerToPrivileges.getIOGroupID()));
                if (bIndex == -1) {
                    bIOGroup = new IOGroup(bProtocolControllerToPrivileges.getIOGroupID());
                    bIOGroup.setIOGroupCOP(bProtocolControllerToPrivileges.getIOGroupCOP());
                    mIOGroups.add(bIOGroup);
                } else {
                    bIOGroup = (IOGroup)mIOGroups.get(bIndex);
                }
                bIOGroup.addProtocolControllerToPrivileges(bProtocolControllerToPrivileges);
            }
            for (int bIOGroupLoop = 0; bIOGroupLoop < mIOGroups.size(); ++bIOGroupLoop) {
                bIOGroup = (IOGroup)mIOGroups.get(bIOGroupLoop);
                List bWWPNsOfIOGroup = bIOGroup.getStorageHardwareIDs();
                ArrayList bStorageHardwareIDsWithoutPCForThisIOGroup = new ArrayList();
                for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                    if (bWWPNsOfIOGroup.contains(pStorageHardwareIDs.get(i))) continue;
                    bStorageHardwareIDsWithoutPCForThisIOGroup.add(pStorageHardwareIDs.get(i));
                }
                ArrayList<CIMObjectPath> bIOGroupCOPs = new ArrayList<CIMObjectPath>();
                bIOGroupCOPs.add(bIOGroup.getIOGroupCOP());
                mNewProtocolControllers.addAll(this.createProtocolControllers(bStorageHardwareIDsWithoutPCForThisIOGroup, bIOGroupCOPs));
            }
            if (pParams.getDifferentIOGroupIDs().size() != mIOGroups.size()) {
                Iterator bDifferentIOGroupIDIterator = pParams.getDifferentIOGroupIDs().iterator();
                Iterator bHandledIOGroupIterator = mIOGroups.iterator();
                ArrayList bUnhandledIOGroupCOPs = new ArrayList();
                while (bDifferentIOGroupIDIterator.hasNext()) {
                    boolean bContained = false;
                    Integer bCurrentIOGroupID = (Integer)bDifferentIOGroupIDIterator.next();
                    while (bHandledIOGroupIterator.hasNext()) {
                        IOGroup bHandledIOGroup = (IOGroup)bHandledIOGroupIterator.next();
                        if (!bHandledIOGroup.getIOGroupID().equals(bCurrentIOGroupID)) continue;
                        bContained = true;
                        break;
                    }
                    if (bContained) continue;
                    bUnhandledIOGroupCOPs.add(pParams.getDifferentIOGroupCOPs().get(pParams.getDifferentIOGroupIDs().indexOf(bCurrentIOGroupID)));
                }
                if (bUnhandledIOGroupCOPs.size() > 0) {
                    mNewProtocolControllers.addAll(this.createProtocolControllers(pStorageHardwareIDs, bUnhandledIOGroupCOPs));
                }
            }
        }
        finally {
            mLTH.exit(mNewProtocolControllers);
        }
        return mNewProtocolControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMObjectPath[] checkVolumesOfPC(CIMObjectPath[] pVolumeCOPs, ArrayList pAllVolumesOfPC) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"checkVolumesOfPC", (Object[])new Object[]{pVolumeCOPs, pAllVolumesOfPC});
        ArrayList<CIMObjectPath> volumesAttached = new ArrayList<CIMObjectPath>();
        try {
            for (int i = 0; i < pVolumeCOPs.length; ++i) {
                if (!pAllVolumesOfPC.contains(pVolumeCOPs[i])) continue;
                volumesAttached.add(pVolumeCOPs[i]);
            }
        }
        finally {
            mLTH.exit(volumesAttached);
        }
        return volumesAttached.toArray(new CIMObjectPath[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList attachDevices(ProtocolControllerToPrivileges pProtocolController, CIMObjectPath[] pVolumeCOPs, String[] pVolumeIDs, String[] pDeviceNumbers, AssignStorageVolumesParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"attachDevices", (Object[])new Object[]{pProtocolController, pVolumeCOPs, pVolumeIDs, pDeviceNumbers});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            ArrayList<CIMObjectPath> mVolumeCOPs = new ArrayList<CIMObjectPath>();
            ArrayList<String> mVolumeIDs = new ArrayList<String>();
            ArrayList<StorageVolume> mVolumes = new ArrayList<StorageVolume>();
            ArrayList<String> mDeviceNumbers = new ArrayList<String>();
            for (int i = 0; i < pParams.getVolumeIDs().length; ++i) {
                if (pProtocolController.getIOGroupID().intValue() != pParams.getIOGroupIDs()[i].intValue()) continue;
                mVolumeCOPs.add(pParams.getVolumeCOPs()[i]);
                mVolumeIDs.add(pParams.getVolumeIDs()[i]);
                mVolumes.add(pParams.getVolumes()[i]);
                mDeviceNumbers.add(pParams.getDeviceNumbers()[i]);
            }
            mNewVolumeAssignments = super.attachDevices(pProtocolController, mVolumeCOPs.toArray(new CIMObjectPath[0]), mVolumeIDs.toArray(new String[0]), mDeviceNumbers.toArray(new String[0]), pParams);
        }
        catch (Throwable throwable) {
            mLTH.exit(mNewVolumeAssignments);
            throw throwable;
        }
        mLTH.exit((Object)mNewVolumeAssignments);
        return mNewVolumeAssignments;
    }

    protected String[] putCOPsIntoString(CIMObjectPath[] pCOPs) {
        String[] bCOPStrings = new String[pCOPs.length];
        for (int i = 0; i < bCOPStrings.length; ++i) {
            bCOPStrings[i] = pCOPs[i].toString();
            bCOPStrings[i] = bCOPStrings[i].substring(bCOPStrings[i].indexOf(":") + 1);
        }
        return bCOPStrings;
    }
}

