/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMManagement;
import org.eclipse.aperi.disk.common.ExceptionHelper;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class PrivilegeManagement
extends CIMManagement {
    private CIMObjectPath cPrivilegeManagementService;

    public PrivilegeManagement(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMObjectPath retrieveAssociatedControllerConfigurationService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveAssociatedControllerConfigurationService", null);
        try {
            this.cPrivilegeManagementService = this.retrieveAssociatedService("CIM_PrivilegeManagementService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        finally {
            mLTH.exit((Object)this.cPrivilegeManagementService);
        }
        return this.cPrivilegeManagementService;
    }

    public CIMObjectPath getPrivilege() {
        return null;
    }

    public ArrayList retrievePrivilegesForProtocolController(CIMObjectPath pProtocolController, ArrayList pPrivilegesToWWPNs) throws ServerException {
        ArrayList mPrivilegeToWWPNs = new ArrayList();
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrievePrivilegesForProtocolController", (Object[])new Object[]{pProtocolController});
        try {
            Enumeration mPrivileges = this.cCimClient.associatorNames(pProtocolController, null, "CIM_AuthorizedPrivilege", "TargetElement", "Privilege", this.cLogTraceHelper);
            while (mPrivileges.hasMoreElements()) {
                PrivilegeToWWPNs bPrivilegeToWWPN = new PrivilegeToWWPNs((CIMObjectPath)mPrivileges.nextElement());
                int bIndex = pPrivilegesToWWPNs.indexOf(bPrivilegeToWWPN);
                if (bIndex != -1) {
                    mPrivilegeToWWPNs.add(pPrivilegesToWWPNs.get(bIndex));
                    continue;
                }
                bPrivilegeToWWPN = this.cPlugin.getHardwareIDManagement().retrieveInitiatorsOfPrivilege(bPrivilegeToWWPN);
                mPrivilegeToWWPNs.add(bPrivilegeToWWPN);
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mPrivilegeToWWPNs);
        }
        return mPrivilegeToWWPNs;
    }

    public ArrayList retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(ArrayList pStorageHardwareIDsOrCollections, ArrayList pStorageHardwareIDsOrCollectionsWithoutPrivileges) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections", (Object[])new Object[]{pStorageHardwareIDsOrCollections, pStorageHardwareIDsOrCollectionsWithoutPrivileges});
        ArrayList<PrivilegeToWWPNs> mAssociatedPrivileges = new ArrayList<PrivilegeToWWPNs>();
        try {
            for (int i = 0; i < pStorageHardwareIDsOrCollections.size(); ++i) {
                CIMObjectPath bInitiatorCOP = pStorageHardwareIDsOrCollections.get(i) instanceof StorageHardwareID ? ((StorageHardwareID)pStorageHardwareIDsOrCollections.get(i)).getStorageHardwareIDCOP() : ((HardwareIDCollection)pStorageHardwareIDsOrCollections.get(i)).getHardwareIDCollectionCOP();
                Enumeration bPrivileges = this.cCimClient.associatorNames(bInitiatorCOP, "CIM_AuthorizedSubject", "CIM_AuthorizedPrivilege", "PrivilegedElement", "Privilege", this.cLogTraceHelper);
                if (!bPrivileges.hasMoreElements()) {
                    if (pStorageHardwareIDsOrCollectionsWithoutPrivileges == null) {
                        ServerException bEx = ExceptionHelper.generateHardwareIDsHaveNoMappingsException(pStorageHardwareIDsOrCollections.get(i), this.cPlugin.getParams().getStorageSubsystemID(), mLTH);
                        throw bEx;
                    }
                    pStorageHardwareIDsOrCollectionsWithoutPrivileges.add(pStorageHardwareIDsOrCollections.get(i));
                    continue;
                }
                while (bPrivileges.hasMoreElements()) {
                    PrivilegeToWWPNs mPrivToWWPN;
                    CIMObjectPath bPrivilege = (CIMObjectPath)bPrivileges.nextElement();
                    int bIndex = mAssociatedPrivileges.indexOf(new PrivilegeToWWPNs(bPrivilege));
                    if (bIndex == -1) {
                        mPrivToWWPN = new PrivilegeToWWPNs(bPrivilege, pStorageHardwareIDsOrCollections.get(i));
                        mAssociatedPrivileges.add(mPrivToWWPN);
                        continue;
                    }
                    mPrivToWWPN = (PrivilegeToWWPNs)mAssociatedPrivileges.get(bIndex);
                    mPrivToWWPN.addInitiator(pStorageHardwareIDsOrCollections.get(i));
                    mAssociatedPrivileges.add(bIndex, mPrivToWWPN);
                }
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mAssociatedPrivileges);
        }
        return mAssociatedPrivileges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrievePrivilegesForHardwareIDsOfCollections(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutPrivileges) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrievePrivilegesForHardwareIDsOfCollections", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutPrivileges});
        ArrayList mAssociatedPrivileges = new ArrayList();
        try {
            ArrayList mHardwareIDsWithoutCollection = new ArrayList();
            ArrayList bStorageHardwareIDCollections = this.cPlugin.getHardwareIDManagement().retrieveCollectionsForStorageHardwareIDs(pStorageHardwareIDs, mHardwareIDsWithoutCollection);
            if (!mHardwareIDsWithoutCollection.isEmpty()) {
                if (pStorageHardwareIDsWithoutPrivileges == null) {
                    ServerException bEx = ExceptionHelper.generateHardwareIDsHaveNoMappingsException(mHardwareIDsWithoutCollection.get(0), this.cPlugin.getParams().getStorageSubsystemID(), mLTH);
                    throw bEx;
                }
                pStorageHardwareIDsWithoutPrivileges.addAll(mHardwareIDsWithoutCollection);
            }
            ArrayList mHardwareIDCollectionsWithoutPrivilege = null;
            if (pStorageHardwareIDsWithoutPrivileges != null) {
                mHardwareIDCollectionsWithoutPrivilege = new ArrayList();
            }
            ArrayList mPrivileges = this.retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(bStorageHardwareIDCollections, mHardwareIDCollectionsWithoutPrivilege);
            mAssociatedPrivileges.addAll(mPrivileges);
            if (mHardwareIDCollectionsWithoutPrivilege != null && !mHardwareIDCollectionsWithoutPrivilege.isEmpty()) {
                for (int i = 0; i < mHardwareIDCollectionsWithoutPrivilege.size(); ++i) {
                    pStorageHardwareIDsWithoutPrivileges.addAll(((HardwareIDCollection)mHardwareIDCollectionsWithoutPrivilege.get(i)).getStorageHardwareIDs());
                }
            }
        }
        finally {
            mLTH.exit(mAssociatedPrivileges);
        }
        return mAssociatedPrivileges;
    }

    public ArrayList assignAccess(ProtocolControllerToPrivileges pProtocolController, ArrayList pStorageHardwareIDs, AssignmentParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"assignAccess", (Object[])new Object[]{pProtocolController, pStorageHardwareIDs, this.cToken});
        ArrayList mNewVolumeAssignments = new ArrayList();
        String[] mFCPortWWPNs = null;
        String[] mDeviceNumbers = null;
        int i = 0;
        try {
            mFCPortWWPNs = this.cPlugin.getMappingManagement().getFCPortWWPNs(pProtocolController.getProtocolController());
            mDeviceNumbers = this.cPlugin.getMappingManagement().getDeviceNumbers(pProtocolController.getProtocolController(), pParams.getVolumeCOPs());
            CIMObjectPath[] mPrivileges = new CIMObjectPath[pStorageHardwareIDs.size()];
            for (i = 0; i < mPrivileges.length; ++i) {
                Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
                Vector mOutParams = new Vector();
                mInParams.add(new CIMArgument("Subject", new CIMValue((Object)((StorageHardwareID)pStorageHardwareIDs.get(i)).getStorageHardwareIDCOP(), CIMDataType.getPredefinedType((int)14))));
                mInParams.add(new CIMArgument("Target", new CIMValue((Object)pProtocolController.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                mInParams.add(new CIMArgument("PrivilegeGranted", new CIMValue((Object)new Boolean(true), CIMDataType.getPredefinedType((int)9))));
                mInParams.add(new CIMArgument("Activities", new CIMValue((Object)new UnsignedInt16[]{new UnsignedInt16(5), new UnsignedInt16(6)}, CIMDataType.getPredefinedType((int)18))));
                this.invokeCIMMethod(this.getPrivilegeManagementService(), "AssignAccess", mInParams, mOutParams);
                for (int j = 0; j < mOutParams.size(); ++j) {
                    CIMArgument bOut = (CIMArgument)mOutParams.get(j);
                    if (bOut.getName().compareTo("Privilege") != 0) continue;
                    mPrivileges[i] = (CIMObjectPath)bOut.getValue().getValue();
                }
            }
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(mFCPortWWPNs, pStorageHardwareIDs, pParams.getVolumeIDs(), mDeviceNumbers, pParams, this.cPlugin.getHardwareIDManagement(), pProtocolController.getProtocolController(), this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ConfigurationResultHelper.processPartialMaskingFailure(pStorageHardwareIDs, pParams, mNewVolumeAssignments, i, pParams.getVolumeIDs(), mDeviceNumbers, mFCPortWWPNs, this.cPlugin.getHardwareIDManagement(), pProtocolController.getProtocolController(), e, this.cToken);
            throw e;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    public ArrayList removeAccess(ProtocolControllerToPrivileges pProtocolController, ArrayList pStorageHardwareIDs, AssignmentParameter pParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"removeAccess", (Object[])new Object[]{pProtocolController, pStorageHardwareIDs, this.cToken});
        ArrayList mNewVolumeAssignments = new ArrayList();
        int i = 0;
        try {
            ArrayList mPrivileges = pProtocolController.getPrivilegeToWWPNs();
            ArrayList<PrivilegeToWWPNs> mRemovedPrivileges = new ArrayList<PrivilegeToWWPNs>();
            for (i = 0; i < mPrivileges.size(); ++i) {
                PrivilegeToWWPNs bPrivilegeToWWPNs = (PrivilegeToWWPNs)mPrivileges.get(i);
                for (int j = 0; j < pStorageHardwareIDs.size(); ++j) {
                    if (!bPrivilegeToWWPNs.getWWPNs().contains(((StorageHardwareID)pStorageHardwareIDs.get(j)).getWWPN())) continue;
                    Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
                    Vector mOutParams = new Vector();
                    mInParams.add(new CIMArgument("Subject", new CIMValue((Object)((StorageHardwareID)pStorageHardwareIDs.get(i)).getStorageHardwareIDCOP(), CIMDataType.getPredefinedType((int)14))));
                    mInParams.add(new CIMArgument("Target", new CIMValue((Object)pProtocolController.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                    mInParams.add(new CIMArgument("Privilege", new CIMValue((Object)bPrivilegeToWWPNs.getPrivilege(), CIMDataType.getPredefinedType((int)14))));
                    this.invokeCIMMethod(this.getPrivilegeManagementService(), "RemoveAccess", mInParams, mOutParams);
                    mRemovedPrivileges.add(bPrivilegeToWWPNs);
                }
            }
            mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(mRemovedPrivileges, pParams.getVolumeIDs(), this.cToken));
            pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ConfigurationResultHelper.processPartialUnmaskingFailure(pProtocolController.getPrivilegeToWWPNs(), pParams, mNewVolumeAssignments, i, pParams.getVolumeIDs(), e, this.cToken);
            throw e;
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrievePrivilegesForInitiators(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutPrivileges) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrievePrivilegesForInitiators", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutPrivileges});
        ArrayList mPrivileges = null;
        try {
            boolean mMustHaveAssociatedPrivileges = pStorageHardwareIDsWithoutPrivileges == null;
            boolean mSupportsCollections = ((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerSuppColl() == 1;
            ArrayList mHWIDsOrCollectionsWithoutPrivilege = null;
            if (mSupportsCollections || pStorageHardwareIDsWithoutPrivileges != null) {
                mHWIDsOrCollectionsWithoutPrivilege = new ArrayList();
            }
            mPrivileges = this.retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(pStorageHardwareIDs, mHWIDsOrCollectionsWithoutPrivilege);
            if (mHWIDsOrCollectionsWithoutPrivilege != null && !mHWIDsOrCollectionsWithoutPrivilege.isEmpty()) {
                if (mSupportsCollections) {
                    ArrayList bStorageHardwareIDsInCollectionWithoutPrivilege = null;
                    if (!mMustHaveAssociatedPrivileges) {
                        bStorageHardwareIDsInCollectionWithoutPrivilege = new ArrayList();
                    }
                    ArrayList bPrivilegesOfCollections = this.retrievePrivilegesForHardwareIDsOfCollections(mHWIDsOrCollectionsWithoutPrivilege, bStorageHardwareIDsInCollectionWithoutPrivilege);
                    if (bStorageHardwareIDsInCollectionWithoutPrivilege != null && !bStorageHardwareIDsInCollectionWithoutPrivilege.isEmpty()) {
                        pStorageHardwareIDsWithoutPrivileges.addAll(bStorageHardwareIDsInCollectionWithoutPrivilege);
                    } else if (pStorageHardwareIDsWithoutPrivileges != null) {
                        pStorageHardwareIDsWithoutPrivileges.clear();
                    }
                    for (int i = 0; i < bPrivilegesOfCollections.size(); ++i) {
                        if (mPrivileges.contains(bPrivilegesOfCollections.get(i))) continue;
                        mPrivileges.add(bPrivilegesOfCollections.get(i));
                    }
                } else {
                    pStorageHardwareIDsWithoutPrivileges.addAll(mHWIDsOrCollectionsWithoutPrivilege);
                }
            }
            mPrivileges = this.removeWrongPrivileges(mPrivileges);
        }
        catch (Throwable throwable) {
            mLTH.exit(mPrivileges);
            throw throwable;
        }
        mLTH.exit((Object)mPrivileges);
        return mPrivileges;
    }

    private ArrayList removeWrongPrivileges(ArrayList pPrivileges) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"removeWrongPrivileges", (Object[])new Object[]{pPrivileges});
        ArrayList mReturnedPrivileges = new ArrayList();
        try {
            CIMObjectPath mReferenceService = this.getPrivilegeManagementService();
            for (int i = 0; i < pPrivileges.size(); ++i) {
                CIMObjectPath bPrivilegeCOP = ((PrivilegeToWWPNs)pPrivileges.get(i)).getPrivilege();
                Enumeration bPrivilegeServices = this.cCimClient.associatorNames(bPrivilegeCOP, "CIM_ConcreteDependency", "CIM_PrivilegeManagementService", "Dependent", "Antecedent", this.cLogTraceHelper);
                while (bPrivilegeServices.hasMoreElements()) {
                    CIMObjectPath bPrivilegeService = (CIMObjectPath)bPrivilegeServices.nextElement();
                    if (!bPrivilegeService.equals((Object)mReferenceService)) continue;
                    mReturnedPrivileges.add(pPrivileges.get(i));
                }
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturnedPrivileges);
        }
        return mReturnedPrivileges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath getPrivilegeManagementService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getPrivilegeManagementService", (Object[])new Object[]{null});
        try {
            if (this.cPrivilegeManagementService == null) {
                this.retrieveAssociatedControllerConfigurationService();
            }
        }
        finally {
            mLTH.exit((Object)this.cPrivilegeManagementService);
        }
        return this.cPrivilegeManagementService;
    }
}

