/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.collection.SubProbeVolume;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMManagement;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelperCreateAndUpdate;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;

public class VolumeManagement
extends CIMManagement {
    protected CIMObjectPath cStorageConfigurationService;
    private static final String PROCESSID_PREFIX = "C";
    private static IEventMonitorService eventMonitor = null;

    public VolumeManagement(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath retrieveAssociatedStorageConfigurationService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveAssociatedStorageConfigurationService", null);
        try {
            if (this.cStorageConfigurationService == null) {
                this.cStorageConfigurationService = this.retrieveAssociatedService("CIM_StorageConfigurationService", "CIM_HostedService", "Antecedent", "Dependent");
            }
            CIMObjectPath cIMObjectPath = this.cStorageConfigurationService;
            return cIMObjectPath;
        }
        finally {
            mLTH.exit((Object)this.cStorageConfigurationService);
        }
    }

    public ArrayList retrieveVolumesOfProtocolController(CIMObjectPath pProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveVolumesOfProtocolController", (Object[])new Object[]{pProtocolController});
        ArrayList<CIMObjectPath> mAssociatedVolumes = new ArrayList<CIMObjectPath>();
        try {
            Enumeration mVolumes = this.cCimClient.associatorNames(pProtocolController, "CIM_ProtocolControllerForUnit", "CIM_StorageVolume", "Antecedent", "Dependent", this.cLogTraceHelper);
            while (mVolumes.hasMoreElements()) {
                CIMObjectPath bVolume = (CIMObjectPath)mVolumes.nextElement();
                mAssociatedVolumes.add(bVolume);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mAssociatedVolumes);
        }
        return mAssociatedVolumes;
    }

    public long[] getSupportedSizeRange(CIMObjectPath pStoragePoolCIMOP, int pDataRedundancy, int pPackageRedundancy, short pDeltaReservation) throws ServerException {
        String cMethodName = "getSupportedSizeRange";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)cMethodName, (Object[])new Object[]{pStoragePoolCIMOP, String.valueOf(pDataRedundancy), String.valueOf(pDataRedundancy), String.valueOf(pDeltaReservation)});
        long[] result = null;
        try {
            Enumeration mEnum = this.cCimClient.associatorNames(pStoragePoolCIMOP, "CIM_ElementCapabilities", "CIM_StorageCapabilities", "ManagedElement", "Capabilities", this.cLogTraceHelper);
            CIMObjectPath mStorageCapCIMOP = null;
            if (mEnum.hasMoreElements()) {
                mStorageCapCIMOP = (CIMObjectPath)mEnum.nextElement();
            }
            if (mStorageCapCIMOP != null) {
                CIMInstance mSettingInst = this.getSetting(mStorageCapCIMOP, pDataRedundancy, pPackageRedundancy, pDeltaReservation);
                long[] lArray = this.getSupportedSizeRange(pStoragePoolCIMOP, mSettingInst.getObjectPath());
                return lArray;
            }
            long[] lArray = result;
            return lArray;
        }
        catch (CIMException e) {
            throw DiskMessageHelper.getServerException((String)"HWN021529E", (Object)cMethodName, null, (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException pDTe) {
            throw DiskMessageHelper.getServerException((String)"HWN021529E", (Object)cMethodName, null, (Object)pDTe.toString(), (Throwable)pDTe, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMInstance getSetting(CIMObjectPath pStorageCapCIMOP, int pDataRedundancy, int pPackageRedundancy, short pDeltaReservation) throws DiskManagerTimeoutException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getSetting", (Object[])new Object[]{pStorageCapCIMOP, new Integer(pDataRedundancy), new Integer(pPackageRedundancy), new Short(pDeltaReservation)});
        CIMInstance mSettingInst = null;
        try {
            Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
            Vector bOutParams = new Vector();
            UnsignedInt16 bSettingType = new UnsignedInt16(2);
            CIMArgument arg1 = new CIMArgument("SettingType");
            arg1.setValue(new CIMValue((Object)bSettingType, CIMDataType.getPredefinedType((int)2)));
            bInParams.add(arg1);
            this.invokeCIMMethod(pStorageCapCIMOP, "CreateSetting", bInParams, bOutParams);
            CIMObjectPath mSettingCIMOP = null;
            for (int idx = 0; idx < bOutParams.size(); ++idx) {
                CIMArgument out = (CIMArgument)bOutParams.get(idx);
                if (out.getName().compareTo("NewSetting") != 0) continue;
                mSettingCIMOP = (CIMObjectPath)out.getValue().getValue();
            }
            mSettingInst = this.cCimClient.getInstance(mSettingCIMOP, false, true, true, this.cLogTraceHelper);
            if (((UnsignedInt16)mSettingInst.getProperty("DataRedundancyGoal").getValue().getValue()).intValue() != pDataRedundancy) {
                mSettingInst.setProperty("DataRedundancyGoal", new CIMValue((Object)new UnsignedInt16(pDataRedundancy), CIMDataType.getPredefinedType((int)2)));
            }
            if (((UnsignedInt16)mSettingInst.getProperty("PackageRedundancyGoal").getValue().getValue()).intValue() != pPackageRedundancy) {
                mSettingInst.setProperty("PackageRedundancyGoal", new CIMValue((Object)new UnsignedInt16(pDataRedundancy), CIMDataType.getPredefinedType((int)2)));
            }
            if (((UnsignedInt8)mSettingInst.getProperty("DeltaReservationGoal").getValue().getValue()).shortValue() != pDeltaReservation) {
                mSettingInst.setProperty("DeltaReservationGoal", new CIMValue((Object)new UnsignedInt8(pDeltaReservation), CIMDataType.getPredefinedType((int)0)));
            }
            this.cCimClient.setInstance(mSettingCIMOP, mSettingInst, mLTH);
        }
        catch (Throwable throwable) {
            mLTH.exit(mSettingInst);
            throw throwable;
        }
        mLTH.exit((Object)mSettingInst);
        return mSettingInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getSupportedSizes(CIMObjectPath pStoragePoolCIMOP, CIMObjectPath pStgSettingCIMOP) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getSupportedSizes", (Object[])new Object[]{pStoragePoolCIMOP, pStgSettingCIMOP});
        long[] mResult = new long[]{-1L, -1L, -1L};
        try {
            Vector<CIMArgument> inParams = new Vector<CIMArgument>();
            Vector outParams = new Vector();
            UnsignedInt16 elementType = new UnsignedInt16(3);
            CIMArgument arg1 = new CIMArgument("ElementType");
            arg1.setValue(new CIMValue((Object)elementType, CIMDataType.getPredefinedType((int)2)));
            inParams.add(arg1);
            if (pStgSettingCIMOP != null) {
                CIMArgument arg2 = new CIMArgument("Goal");
                arg2.setValue(new CIMValue((Object)pStgSettingCIMOP, CIMDataType.getPredefinedType((int)14)));
                inParams.add(arg2);
            }
            this.invokeCIMMethod(pStoragePoolCIMOP, "GetSupportedSizes", inParams, outParams);
            Vector bSizes = (Vector)CIMInstanceHelper.getCIMPropertyValue(outParams, (String)"Sizes");
            mResult = new long[bSizes.size() + 3];
            long min = ((Number)bSizes.elementAt(0)).longValue();
            long max = ((Number)bSizes.elementAt(0)).longValue();
            for (int i = 0; i < bSizes.size(); ++i) {
                mResult[3 + i] = ((Number)bSizes.elementAt(i)).longValue();
                if (min > ((Number)bSizes.elementAt(i)).longValue()) {
                    min = ((Number)bSizes.elementAt(i)).longValue();
                }
                if (max >= ((Number)bSizes.elementAt(i)).longValue()) continue;
                max = ((Number)bSizes.elementAt(i)).longValue();
            }
            mResult[0] = min;
            mResult[1] = max;
            mResult[2] = -2L;
            long[] lArray = mResult;
            return lArray;
        }
        finally {
            mLTH.exit((Object)mResult);
        }
    }

    public long[] getSupportedSizeRange(CIMObjectPath pStoragePoolCIMOP, CIMObjectPath pStgSettingCIMOP) throws ServerException {
        String cMethodName = "getSupportedSizeRange";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)cMethodName, (Object[])new Object[]{pStoragePoolCIMOP, pStgSettingCIMOP});
        long[] result = new long[3];
        try {
            Vector<CIMArgument> inParams = new Vector<CIMArgument>();
            Vector outParams = new Vector();
            UnsignedInt16 elementType = new UnsignedInt16(3);
            CIMArgument arg1 = new CIMArgument("ElementType");
            arg1.setValue(new CIMValue((Object)elementType, CIMDataType.getPredefinedType((int)2)));
            inParams.add(arg1);
            CIMArgument arg2 = new CIMArgument("Goal");
            arg2.setValue(new CIMValue((Object)pStgSettingCIMOP, CIMDataType.getPredefinedType((int)14)));
            inParams.add(arg2);
            this.invokeCIMMethod(pStoragePoolCIMOP, "GetSupportedSizeRange", inParams, outParams);
            result[0] = -1L;
            result[1] = -1L;
            result[2] = -1L;
            for (int i = 0; i < outParams.size(); ++i) {
                CIMArgument out = (CIMArgument)outParams.get(i);
                if (out.getName().compareTo("MinimumVolumeSize") == 0) {
                    result[0] = CIMInstanceHelper.getPropertyLongValue((CIMArgument)out);
                    continue;
                }
                if (out.getName().compareTo("MaximumVolumeSize") == 0) {
                    result[1] = CIMInstanceHelper.getPropertyLongValue((CIMArgument)out);
                    continue;
                }
                if (out.getName().compareTo("VolumeSizeDivisor") != 0) continue;
                result[2] = CIMInstanceHelper.getPropertyLongValue((CIMArgument)out);
            }
            long[] lArray = result;
            return lArray;
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021529E", (Object)cMethodName, null, (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult createStorageVolume(String pStoragePoolID, CapabilityData pCapData, StorageSubsystem pStorageSubsystem, CIMOM pCimom, CIMObjectPath pStoragePoolCIMOP, String pVolumeName, long pSize) {
        String cMethodName = "createStorageVolume";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)cMethodName, (Object[])new Object[]{pStoragePoolID, pCapData, pStorageSubsystem, pCimom, pStoragePoolCIMOP, pVolumeName, String.valueOf(pSize)});
        AsyncResult mResult = new AsyncResult(-1, -1);
        VolumeID mRes = new VolumeID();
        mRes.setStoragePoolID(pStoragePoolID);
        try {
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            CIMArgument arg1 = new CIMArgument("ElementName");
            arg1.setValue(new CIMValue((Object)pVolumeName, CIMDataType.getPredefinedType((int)8)));
            mInParams.add(arg1);
            UnsignedInt16 elementType = new UnsignedInt16(2);
            CIMArgument arg2 = new CIMArgument("ElementType");
            arg2.setValue(new CIMValue((Object)elementType, CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg2);
            Object stgSettingCOP = null;
            CIMArgument arg3 = new CIMArgument("Goal");
            arg3.setValue(new CIMValue(stgSettingCOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg3);
            CIMArgument arg4 = new CIMArgument("Size");
            arg4.setValue(new CIMValue((Object)new UnsignedInt64(String.valueOf(pSize)), CIMDataType.getPredefinedType((int)6)));
            mInParams.add(arg4);
            CIMArgument arg5 = new CIMArgument("InPool");
            arg5.setValue(new CIMValue((Object)pStoragePoolCIMOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg5);
            this.invokeAsyncCIMMethod(this.retrieveAssociatedStorageConfigurationService(), "CreateOrModifyElementFromStoragePool", mInParams, mOutParams, "TheElement", "CIM_StorageVolume", new CIMObjectPath());
            CIMInstance bNewVolInst = null;
            CIMInstance bPoolInst = null;
            CIMObjectPath newVolumeCIMOP = null;
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument out = (CIMArgument)mOutParams.get(i);
                if (out.getName().compareTo("TheElement") != 0 || out.getValue() == null) continue;
                newVolumeCIMOP = (CIMObjectPath)out.getValue().getValue();
                bNewVolInst = this.retrieveCIMInstance(newVolumeCIMOP);
            }
            if (bNewVolInst != null) {
                bPoolInst = this.retrieveCIMInstance(pStoragePoolCIMOP);
            }
            SubProbeVolume mSubProbe = new SubProbeVolume(this.cPlugin.getParams(), this);
            MapperResult bRes = mSubProbe.persistVolumeOrPool(bNewVolInst, pStoragePoolID, newVolumeCIMOP);
            Hashtable mInsertVals = bRes.getAllRows();
            Hashtable mNewEntry = (Hashtable)mInsertVals.get(StorageVolume.getTablename());
            String bVolName = (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"NAME"));
            String bVolNameFormat = (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"NAME_FORMAT"));
            ((CreateStorageVolumesParameter)this.cPlugin.getParams()).setVolumeElementName((String)mNewEntry.get(StorageVolume.getColumnInfo((String)"DISPLAY_NAME")));
            mRes.setStorageVolumeID(ExternalKeyConverter.frameKeyStorageVolume((String)bVolName, (short)Short.parseShort(bVolNameFormat), (String)pStorageSubsystem.getName(), (short)pStorageSubsystem.getNameFormat()));
            bRes = mSubProbe.persistVolumeOrPool(bPoolInst, pStoragePoolID, null);
            this.indicateCreatedEntity(TResStorageVolumeTable.getTablename(), (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"SVID")));
            this.indicateModifiedEntity(TResStoragePoolTable.getTablename(), (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"POOL_ID")));
            DiskManager.getInstance().probeStorageVolume(ExternalKeyConverter.excapeDelimiter((String)pStorageSubsystem.getName()) + "+" + String.valueOf(pStorageSubsystem.getNameFormat()), mRes.getStorageVolumeID(), 2);
            mResult.setStatus(1);
            mResult.setRc(0);
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(new SRMMessage("HWN020001I", new String[]{cMethodName}));
        }
        catch (CIMException ce) {
            SRMMessage message = new SRMMessage("HWN021515E", new String[]{"getInstance", this.cCimClient.toString(), ce.toString()});
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(message);
            mResult.setRc(10001);
            mResult.setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"getInstance", (Object)this.cCimClient.toString(), (Object)ce.toString(), (Throwable)ce, (LogTraceHelper)mLTH)));
        }
        catch (DiskManagerTimeoutException e) {
            SRMMessage message = new SRMMessage("HWN021652E", new String[]{this.cCimClient.toString(), e.toString()});
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(message);
            mResult.setRc(10001);
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            mResult.setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH)));
        }
        catch (ServerException e) {
            SRMMessage message = new SRMMessage("HWN021503E", new String[0]);
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(message);
            mResult.setRc(10001);
            mResult.setReturnException((Exception)((Object)e));
        }
        catch (Exception e) {
            SRMMessage message = new SRMMessage("HWN021503E", new String[0]);
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(message);
            mResult.setRc(10001);
            mResult.setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
        }
        finally {
            if (mResult.getRc() == 0) {
                mResult.setStatus(1);
            } else {
                mResult.setStatus(0);
            }
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStorageVolume(String pStorageVolumeID, CIMObjectPath storageVolumeCIMOP, StorageVolume pStorageVolume) throws ServerException {
        String cMethodName = "deleteStorageVolume";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)cMethodName, (Object[])new Object[]{pStorageVolumeID, storageVolumeCIMOP, pStorageVolume});
        try {
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            CIMArgument arg1 = new CIMArgument("TheElement");
            arg1.setValue(new CIMValue((Object)storageVolumeCIMOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg1);
            this.invokeAsyncCIMMethod(this.retrieveAssociatedStorageConfigurationService(), "ReturnToStoragePool", mInParams, mOutParams, "TheElement", "CIM_StorageVolume", new CIMObjectPath());
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult modifyStorageVolumeSize(ModifyStorageVolumeParameter pModifyVol) throws ServerException {
        String cMethodName = "modifyStorageVolumeSize";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)cMethodName, (Object[])new Object[]{pModifyVol});
        AsyncResult mResult = new AsyncResult(-1, -1);
        Object[] mRes = new Object[1];
        try {
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            Object bElementName = null;
            CIMArgument arg1 = new CIMArgument("ElementName");
            arg1.setValue(new CIMValue(bElementName, CIMDataType.getPredefinedType((int)8)));
            mInParams.add(arg1);
            CIMArgument arg2 = new CIMArgument("ElementType");
            arg2.setValue(new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg2);
            Object bStgSettingCOP = null;
            CIMArgument arg3 = new CIMArgument("Goal");
            arg3.setValue(new CIMValue(bStgSettingCOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg3);
            CIMArgument arg4 = new CIMArgument("Size");
            arg4.setValue(new CIMValue((Object)new UnsignedInt64(String.valueOf(pModifyVol.getNewSize())), CIMDataType.getPredefinedType((int)6)));
            mInParams.add(arg4);
            Object storagePoolCIMOP = null;
            CIMArgument arg5 = new CIMArgument("InPool");
            arg5.setValue(new CIMValue(storagePoolCIMOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg5);
            CIMArgument arg6 = new CIMArgument("TheElement");
            arg6.setValue(new CIMValue((Object)pModifyVol.getStorageVolumeCIM(), CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg6);
            this.retrieveAssociatedStorageConfigurationService();
            this.invokeCIMMethod(this.cStorageConfigurationService, "ReturnToStoragePool", mInParams, mOutParams);
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument out = (CIMArgument)mOutParams.get(i);
                if (out.getName().compareTo("TheElement") != 0) continue;
            }
            CIMInstance bNewVolInst = null;
            CIMInstance bPoolInst = null;
            CIMObjectPath newVolumeCIMOP = null;
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument out = (CIMArgument)mOutParams.get(i);
                if (out.getName().compareTo("TheElement") != 0) continue;
                newVolumeCIMOP = (CIMObjectPath)out.getValue().getValue();
                bNewVolInst = this.cCimClient.getInstance(newVolumeCIMOP, true, false, true, this.cLogTraceHelper);
            }
            CIMObjectPath pStoragePoolCIMOP = null;
            if (bNewVolInst != null) {
                bPoolInst = this.cCimClient.getInstance(pStoragePoolCIMOP, true, false, true, this.cLogTraceHelper);
            }
            SubProbeVolume mSubProbe = new SubProbeVolume(this.cPlugin.getParams(), this);
            mSubProbe.persistVolumeOrPool(bNewVolInst, null, newVolumeCIMOP);
            mSubProbe.persistVolumeOrPool(bPoolInst, null, null);
            StorageVolume mStorageVolume = pModifyVol.getStorageVolume();
            this.indicateModifiedEntity(TResStorageVolumeTable.getTablename(), String.valueOf(mStorageVolume.getSvid()));
            this.indicateModifiedEntity(TResStoragePoolTable.getTablename(), String.valueOf(mStorageVolume.getPoolId()));
            DiskManager.getInstance().probeStorageVolume(String.valueOf(pModifyVol.getStorageSubsystem().getName() + "+" + String.valueOf(pModifyVol.getStorageSubsystem().getNameFormat())), String.valueOf(mStorageVolume.getSvid()), 2);
            mResult.setSRMMessage("HWN020001I", new String[]{cMethodName});
            mResult.setStatus(1);
            mResult.setRc(0);
        }
        catch (CIMException ce) {
            SRMMessage message = new SRMMessage("HWN021515E", new String[0]);
            mResult.setRc(10001);
            mResult.setStatus(0);
            mRes[0] = message;
            mResult.setResults(mRes);
        }
        catch (DiskManagerTimeoutException dtEx) {
            mResult.setRc(10001);
            mResult.setStatus(0);
            DiskMessageHelper.getServerException((String)"HWN021515E", (Object)dtEx.getMessage(), (LogTraceHelper)mLTH);
        }
        catch (SQLException sqlEx) {
            mResult.setRc(10001);
            mResult.setStatus(0);
            DiskMessageHelper.getServerException((String)"HWN021515E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        mResult.setResults(mRes);
        return mResult;
    }

    public boolean protocolControllerHasVolumes(CIMObjectPath pProtocolController) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"protocolControllerHasVolumes", (Object[])new Object[]{pProtocolController});
        boolean mResult = false;
        try {
            Enumeration mVolumes = this.cCimClient.associatorNames(pProtocolController, "CIM_ProtocolControllerForUnit", "CIM_StorageVolume", "Antecedent", "Dependent", this.cLogTraceHelper);
            if (mVolumes.hasMoreElements()) {
                mResult = true;
            }
            boolean bl = mResult;
            return bl;
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)new Boolean(mResult));
        }
    }

    public String getCurrentJobID() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMObjectPath getCIMOPVolumeDS(String volumeCIMOPDS, String pNameSpace) throws IndexOutOfBoundsException {
        CIMObjectPath cIMObjectPath;
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getCIMOPVolumeDS", (Object[])new Object[]{volumeCIMOPDS, pNameSpace});
        CIMObjectPath mCOP = null;
        CimkeyVolume bCkVol = new CimkeyVolume();
        try {
            int classNameIdx = volumeCIMOPDS.indexOf(46);
            if (classNameIdx != -1) {
                String className = volumeCIMOPDS.substring(0, classNameIdx);
                String propertyList = volumeCIMOPDS.substring(classNameIdx + 1);
                String[] propertyStrArray = propertyList.split(",");
                for (int i = 0; i < propertyStrArray.length; ++i) {
                    int equalsIdx = propertyStrArray[i].indexOf(61);
                    if (equalsIdx == -1) continue;
                    String propName = propertyStrArray[i].substring(0, equalsIdx);
                    String propVal = propertyStrArray[i].substring(equalsIdx + 2, propertyStrArray[i].length() - 1);
                    if (propName.equalsIgnoreCase("DeviceID")) {
                        bCkVol.setDeviceId(propVal);
                        continue;
                    }
                    if (propName.equalsIgnoreCase("CreationClassName")) {
                        bCkVol.setCreationClassName(propVal);
                        continue;
                    }
                    if (propName.equalsIgnoreCase("SystemCreationClassName")) {
                        bCkVol.setSystemCreationClassName(propVal);
                        continue;
                    }
                    if (!propName.equalsIgnoreCase("SystemName")) continue;
                    bCkVol.setSystemNames(propVal);
                }
            }
            cIMObjectPath = mCOP = ExternalKeyManager.getCIMObjectPath((CimkeyVolume)bCkVol, (String)pNameSpace);
        }
        catch (Throwable throwable) {
            mLTH.exit(mCOP);
            throw throwable;
        }
        mLTH.exit((Object)mCOP);
        return cIMObjectPath;
    }

    protected static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiskActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public void indicateCreatedEntity(String pTableName, String pAutoID) {
        VolumeManagement.getEventMonitorProxy().handleNewDevice(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), pTableName, pAutoID);
        VolumeManagement.getEventMonitorProxy().handleDeviceStateChange(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), pTableName, pAutoID, 0, 1);
        VolumeManagement.getEventMonitorProxy().handleModelUpdate(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
    }

    public void indicateRemovedEntity(String pTableName, String pAutoID) {
        VolumeManagement.getEventMonitorProxy().handleDeviceStateChange(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), pTableName, pAutoID, 1, 0);
        VolumeManagement.getEventMonitorProxy().handleModelUpdate(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
    }

    public void indicateModifiedEntity(String pTableName, String pAutoID) {
        VolumeManagement.getEventMonitorProxy().handleModelUpdate(this.cToken != null ? this.cToken.getJobId() : PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVolumeFromDB(StorageVolume pVolume, HashMap pTouchedEntities, DBConnection pDBConnection) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"removeVolumeFromDB", (Object[])new Object[]{pVolume, pTouchedEntities, pDBConnection});
        boolean mSuccess = false;
        try {
            mLTH.traceInfo("Delete VOLUME2EXTENT");
            Hashtable<ColumnInfo, String> mWhereVolumeExtent = new Hashtable<ColumnInfo, String>();
            mWhereVolumeExtent.put(TResVolume2extentTable.getColumnInfo((String)"VOLUME_ID"), Integer.toString(pVolume.getSvid()));
            DBQueryAssistant.performDelete((String)TResVolume2extentTable.getTablename(), (DBConnection)pDBConnection, mWhereVolumeExtent);
            mLTH.traceInfo("Delete CIMKEYVOLUME");
            Hashtable<ColumnInfo, String> mWhereCIMKeyVolume = new Hashtable<ColumnInfo, String>();
            mWhereCIMKeyVolume.put(TResCimkeyVolumeTable.getColumnInfo((String)"VOLUME_ID"), Integer.toString(pVolume.getSvid()));
            DBQueryAssistant.performDelete((String)TResCimkeyVolumeTable.getTablename(), (DBConnection)pDBConnection, mWhereCIMKeyVolume);
            mLTH.traceInfo("Delete STORAGEVOLUME");
            pVolume.delete(pDBConnection);
            pDBConnection.commit();
            LinkedList<String> list = new LinkedList<String>();
            list.add(String.valueOf(pVolume.getSvid()));
            pTouchedEntities.put(TResStorageVolumeTable.getTablename(), list);
            this.indicateRemovedEntity(TResStorageVolumeTable.getTablename(), String.valueOf(pVolume.getSvid()));
            mSuccess = true;
        }
        catch (Exception e) {
            DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
            try {
                pDBConnection.rollback();
            }
            catch (SQLException e2) {
                DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e2, (LogTraceHelper)mLTH);
            }
            DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)new Boolean(mSuccess));
        }
        return mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePool(DeleteStorageVolumesParameter pParameter, StorageVolume pVolume, CIMObjectPath pVolumeCOP, HashMap pTouchedEntities) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"updatePool", (Object[])new Object[]{pParameter, pVolume, pVolumeCOP, pTouchedEntities});
        boolean mSuccess = false;
        DBHelperCreateAndUpdate mDBHelper = null;
        StoragePool mPool = null;
        try {
            mDBHelper = new DBHelperCreateAndUpdate(pParameter.getToken());
            mPool = mDBHelper.getStoragePool(pVolume);
            String mPoolID = mPool.getInstanceId() + "+" + pParameter.getStorageSubsystemID();
            CIMObjectPath pStoragePoolCIMOP = ExternalKeyManager.getCIMObjectPath((StoragePool)mPool, (String)pVolumeCOP.getNameSpace());
            CIMInstance bPoolInst = this.retrieveCIMInstance(pStoragePoolCIMOP);
            SubProbeVolume mSubProbe = new SubProbeVolume(this.cPlugin.getParams(), this);
            MapperResult bRes = mSubProbe.persistVolumeOrPool(bPoolInst, mPoolID, null);
            LinkedList<String> list = new LinkedList<String>();
            list.add(String.valueOf(mPool.getPoolId()));
            pTouchedEntities.put(TResStoragePoolTable.getTablename(), list);
            this.indicateModifiedEntity(TResStoragePoolTable.getTablename(), String.valueOf(mPool.getPoolId()));
            mSuccess = true;
        }
        catch (CIMException e) {
            if (e.toString().indexOf("CIM_ERR_NOT_FOUND") == -1) {
                DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
                boolean pStoragePoolCIMOP = mSuccess;
                return pStoragePoolCIMOP;
            }
            DBConnection bDBCon = ServiceUtils.getConnection();
            try {
                mPool.delete(bDBCon);
                bDBCon.commit();
                mSuccess = true;
            }
            catch (SQLException e1) {
                try {
                    bDBCon.rollback();
                }
                catch (SQLException e2) {
                    DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e2, (LogTraceHelper)mLTH);
                }
                DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
        }
        catch (Exception e) {
            DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            if (mDBHelper != null) {
                mDBHelper.close();
            }
            mLTH.exit((Object)new Boolean(mSuccess));
        }
        return mSuccess;
    }

    public boolean processChangeDetection(DBConnection pDBConnection, HashMap pTouchedEntities) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"processChangeDetection", (Object[])new Object[]{pDBConnection, pTouchedEntities});
        boolean mSuccess = false;
        try {
            ChangeDetection mChangeDetection = new ChangeDetection(pDBConnection);
            mChangeDetection.complete(pDBConnection, (Map)pTouchedEntities, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
            pDBConnection.commit();
            boolean bl = mSuccess = true;
            return bl;
        }
        catch (Exception e) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)new Boolean(mSuccess));
        }
    }

    public ArrayList getCapabilitiesOfPool(CIMObjectPath pPoolCOP) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getCapabilitiesOfPool", (Object[])new Object[]{pPoolCOP});
        ArrayList<CIMObjectPath> mCapsOfPool = new ArrayList<CIMObjectPath>();
        try {
            Enumeration mCaps = this.cCimClient.associatorNames(pPoolCOP, "CIM_ElementCapabilities", "CIM_StorageCapabilities", null, null);
            while (mCaps.hasMoreElements()) {
                CIMObjectPath mCap = (CIMObjectPath)mCaps.nextElement();
                mCapsOfPool.add(mCap);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
        return mCapsOfPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath getSetting(CIMObjectPath pCapability) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getSetting", (Object[])new Object[]{pCapability});
        CIMObjectPath mSetting = null;
        try {
            Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
            Vector bOutParams = new Vector();
            bInParams.add(new CIMArgument("SettingType", new CIMValue((Object)"2", CIMDataType.getPredefinedType((int)2))));
            this.invokeCIMMethod(pCapability, "CreateSetting", bInParams, bOutParams);
            for (int j = 0; j < bOutParams.size(); ++j) {
                CIMArgument bOut = (CIMArgument)bOutParams.get(j);
                if (!bOut.getName().equals("NewSetting")) continue;
                mSetting = (CIMObjectPath)bOut.getValue().getValue();
            }
        }
        finally {
            mLTH.exit(null);
        }
        return mSetting;
    }
}

