/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.SubProbeVolumeDS;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.VolumeManagementESS;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt64;

public class VolumeManagementDS
extends VolumeManagementESS {
    public VolumeManagementDS(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
    }

    public AsyncResult[] createStorageVolumesInBunches(StoragePool pStoragePool, CapabilityData pCapData, StorageSubsystem pStorageSubsystem, CIMOM pCimom, CIMObjectPath pStoragePoolCIMOP, String[] pVolumeNames, long pSize, int pNumVolumes) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageVolumesInBunches", (Object[])new Object[]{pStoragePool, pCapData, pStorageSubsystem, pCimom, pStoragePoolCIMOP, pVolumeNames, String.valueOf(pSize), String.valueOf(pNumVolumes)});
        AsyncResult[] mResult = new AsyncResult[pNumVolumes];
        try {
            DiskMessageHelper.getSRMMessage((String)"HWN021690I", (Object)new Integer(pNumVolumes), (Object)new Long(pSize), (Object)pStoragePool.getDisplayName(), (Object)pStorageSubsystem.getDisplayName(), (LogTraceHelper)mLTH);
            String[] mVolumeNames = null;
            int mNumberVolumesToCreate = pNumVolumes;
            int mNumberVolumesCreated = 0;
            int mNumberVolumesProcessed = 0;
            int mMaxNumberVolumes = pStorageSubsystem.getType().equalsIgnoreCase("DS8000") ? DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.DS8000VolumeCreationBunchLimit", (int)20) : DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.DS6000VolumeCreationBunchLimit", (int)20);
            while (mNumberVolumesToCreate > 0) {
                int mNumberVolumesOfThisBatchJob = mNumberVolumesToCreate > mMaxNumberVolumes ? mMaxNumberVolumes : mNumberVolumesToCreate;
                if (pVolumeNames != null) {
                    mVolumeNames = new String[mNumberVolumesOfThisBatchJob];
                    System.arraycopy(pVolumeNames, mNumberVolumesCreated, mVolumeNames, 0, mNumberVolumesOfThisBatchJob);
                }
                String mStoragePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)pStoragePool, (StorageSubsystem)pStorageSubsystem);
                AsyncResult[] mFinishedCreations = this.createStorageVolumes(mStoragePoolID, pCapData, pStorageSubsystem, pCimom, pStoragePoolCIMOP, mVolumeNames, pSize, mNumberVolumesOfThisBatchJob);
                System.arraycopy(mFinishedCreations, 0, mResult, mNumberVolumesCreated, mNumberVolumesOfThisBatchJob);
                ArrayList mFailed = ResultHelper.checkForFailureResults((AsyncResult[])mFinishedCreations);
                if (mFailed.size() != 0) {
                    mNumberVolumesCreated = mNumberVolumesCreated + mNumberVolumesOfThisBatchJob - mFailed.size();
                    DiskMessageHelper.getSRMMessage((String)"HWN021692E", (Object)new Integer(mNumberVolumesCreated), (Object)new Integer(pNumVolumes), (Object)new Long(pSize), (Object)pStoragePool.getDisplayName(), (Object)pStorageSubsystem.getDisplayName(), (LogTraceHelper)mLTH);
                    for (int i = mNumberVolumesProcessed + mNumberVolumesOfThisBatchJob - mFailed.size(); i < mResult.length; ++i) {
                        mResult[i] = (AsyncResult)mFailed.get(0);
                    }
                    AsyncResult[] asyncResultArray = mResult;
                    return asyncResultArray;
                }
                mNumberVolumesToCreate -= mNumberVolumesOfThisBatchJob;
                mNumberVolumesProcessed += mNumberVolumesOfThisBatchJob;
                DiskMessageHelper.getSRMMessage((String)"HWN021691I", (Object)new Integer(mNumberVolumesCreated += mNumberVolumesOfThisBatchJob), (Object)new Integer(pNumVolumes), (Object)new Long(pSize), (Object)pStoragePool.getDisplayName(), (Object)pStorageSubsystem.getDisplayName(), (LogTraceHelper)mLTH);
            }
            AsyncResult[] asyncResultArray = mResult;
            return asyncResultArray;
        }
        catch (Exception e) {
            if (e instanceof ServerException) {
                throw (ServerException)((Object)e);
            }
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult[] createStorageVolumes(String pStoragePoolID, CapabilityData pCapData, StorageSubsystem pStorageSubsystem, CIMOM pCimom, CIMObjectPath pStoragePoolCIMOP, String[] pVolumeNames, long pSize, int pNumVolumes) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageVolumes", (Object[])new Object[]{pStoragePoolID, pCapData, pStorageSubsystem, pCimom, pStoragePoolCIMOP, pVolumeNames, String.valueOf(pSize), String.valueOf(pNumVolumes)});
        String[] OPERATION = new String[]{"CreateStorageVolumesOnDS"};
        AsyncResult[] mResult = new AsyncResult[pNumVolumes];
        DBConnection con = null;
        int idx = 0;
        try {
            MapperResult bRes;
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            for (idx = 0; idx < mResult.length; ++idx) {
                mResult[idx] = new AsyncResult(-1, -1);
            }
            idx = 0;
            con = ServiceUtils.getConnection();
            boolean nullCheck = false;
            for (int volNamesIdx = 0; volNamesIdx < pVolumeNames.length; ++volNamesIdx) {
                if (pVolumeNames[volNamesIdx] != null) continue;
                nullCheck = true;
                break;
            }
            if (nullCheck) {
                pVolumeNames = null;
            }
            CIMArgument arg1 = new CIMArgument("ElementNames");
            arg1.setValue(new CIMValue((Object)pVolumeNames, CIMDataType.getPredefinedType((int)24)));
            mInParams.add(arg1);
            UnsignedInt16 elementType = new UnsignedInt16(2);
            CIMArgument arg2 = new CIMArgument("ElementType");
            arg2.setValue(new CIMValue((Object)elementType, CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg2);
            Object stgSettingCOP = null;
            CIMArgument arg3 = new CIMArgument("Goal");
            arg3.setValue(new CIMValue(stgSettingCOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg3);
            CIMArgument arg5 = new CIMArgument("DataType");
            arg5.setValue(new CIMValue((Object)new UnsignedInt16(3), CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg5);
            CIMArgument arg6 = new CIMArgument("Size");
            arg6.setValue(new CIMValue((Object)new UnsignedInt64(String.valueOf(pSize)), CIMDataType.getPredefinedType((int)6)));
            mInParams.add(arg6);
            CIMArgument arg7 = new CIMArgument("InPool");
            arg7.setValue(new CIMValue((Object)pStoragePoolCIMOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg7);
            Object theElements = null;
            CIMArgument arg8 = new CIMArgument("TheElements");
            arg8.setValue(new CIMValue(theElements, CIMDataType.getPredefinedType((int)24)));
            mInParams.add(arg8);
            CIMArgument arg9 = new CIMArgument("NrOfVolumes");
            arg9.setValue(new CIMValue((Object)new UnsignedInt16(pNumVolumes), CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg9);
            this.retrieveAssociatedStorageConfigurationService();
            this.invokeCIMMethod(this.cStorageConfigurationService, "CreateOrModifyVolumesFromStoragePool", mInParams, mOutParams);
            CIMInstance[] mNewVolumeCIMInst = null;
            CIMObjectPath[] mNewVolumeCIMOP = null;
            String[] theElementRetVals = null;
            String[] results = null;
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument out = (CIMArgument)mOutParams.get(i);
                if (out.getName().compareTo("TheElements") == 0) {
                    Vector vTheElementRetVals = (Vector)out.getValue().getValue();
                    theElementRetVals = vTheElementRetVals.toArray(new String[vTheElementRetVals.size()]);
                }
                if (out.getName().compareTo("Results") != 0) continue;
                Vector vResults = (Vector)out.getValue().getValue();
                results = vResults.toArray(new String[vResults.size()]);
            }
            if (results != null && results.length > 0 && theElementRetVals != null && theElementRetVals.length <= results.length) {
                mNewVolumeCIMInst = new CIMInstance[theElementRetVals.length];
                mNewVolumeCIMOP = new CIMObjectPath[theElementRetVals.length];
                for (idx = 0; idx < theElementRetVals.length; ++idx) {
                    if (!results[idx].equals("0")) continue;
                    mNewVolumeCIMOP[idx] = this.getCIMOPVolumeDS(theElementRetVals[idx], this.cCimClient.getNameSpace().getNameSpace());
                    mNewVolumeCIMInst[idx] = this.retrieveCIMInstance(mNewVolumeCIMOP[idx]);
                }
            } else {
                throw DiskMessageHelper.getServerException((String)"HWN021515E", null, (LogTraceHelper)mLTH);
            }
            SubProbeVolumeDS mSubProbe = new SubProbeVolumeDS(this.cPlugin.getParams(), this);
            for (idx = 0; idx < mResult.length; ++idx) {
                VolumeID mRes = null;
                try {
                    if (idx < mNewVolumeCIMInst.length) {
                        bRes = mSubProbe.persistVolumeOrPool(mNewVolumeCIMInst[idx], pStoragePoolID, mNewVolumeCIMOP[idx]);
                        Hashtable mKeyReferences = bRes.getKeyReferences();
                        String bVolName = (String)mKeyReferences.get("ref_name");
                        String bVolNameFormat = (String)mKeyReferences.get("ref_name_format");
                        mResult[idx].setStatus(1);
                        mResult[idx].setRc(0);
                        mResult[idx].setSRMMessage(new SRMMessage("HWN020001I", OPERATION));
                        mRes = new VolumeID();
                        mRes.setStoragePoolID(pStoragePoolID);
                        mRes.setStorageVolumeID(ExternalKeyConverter.frameKeyStorageVolume((String)bVolName, (short)Short.parseShort(bVolNameFormat), (String)pStorageSubsystem.getName(), (short)pStorageSubsystem.getNameFormat()));
                        mResult[idx].setResults((Object[])new VolumeID[]{mRes});
                        this.indicateCreatedEntity(TResStorageVolumeTable.getTablename(), (String)mKeyReferences.get("ref_storagevolume_id"));
                        DiskManager.getInstance().probeStorageVolume(String.valueOf(pStorageSubsystem.getName() + "+" + String.valueOf(pStorageSubsystem.getNameFormat())), mRes.getStorageVolumeID(), 2);
                        continue;
                    }
                    mResult[idx].setStatus(0);
                    mResult[idx].setSRMMessage(new SRMMessage("HWN021601E", OPERATION));
                    mResult[idx].setRc(10001);
                    mResult[idx].setResults((Object[])new VolumeID[]{mRes});
                    mResult[idx].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021514E", (Object)"CreateOrModifyVolumesFromStoragePool", (Object)pCimom.getServiceUrl(), (Object)results[idx], (LogTraceHelper)mLTH)));
                    continue;
                }
                catch (Exception e) {
                    mResult[idx].setStatus(0);
                    mResult[idx].setSRMMessage(new SRMMessage("HWN021601E", OPERATION));
                    mResult[idx].setRc(10001);
                    mResult[idx].setResults((Object[])new VolumeID[]{mRes});
                    mResult[idx].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
                }
            }
            CIMInstance bPoolInst = this.retrieveCIMInstance(pStoragePoolCIMOP);
            bRes = mSubProbe.persistVolumeOrPool(bPoolInst, pStoragePoolID, null);
            Hashtable mInsertVals = bRes.getAllRows();
            Hashtable mNewEntry = (Hashtable)mInsertVals.get(StoragePool.getTablename());
            this.indicateModifiedEntity(TResStoragePoolTable.getTablename(), (String)mNewEntry.get(StoragePool.getColumnInfo((String)"POOL_ID")));
        }
        catch (Exception e) {
            for (int i = idx; i < mResult.length; ++i) {
                mResult[i].setStatus(0);
                VolumeID mRes = new VolumeID();
                mRes.setStoragePoolID(pStoragePoolID);
                mRes.setStorageVolumeID(null);
                mResult[i].setRc(10001);
                mResult[i].setResults((Object[])new VolumeID[]{mRes});
                if (e instanceof SQLException) {
                    mResult[i].setSRMMessage(new SRMMessage("HWN021503E", new String[0]));
                    mResult[i].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
                    continue;
                }
                if (e instanceof CIMException) {
                    mResult[i].setSRMMessage(new SRMMessage("HWN021515E", new String[0]));
                    mResult[i].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
                    continue;
                }
                if (e instanceof DiskManagerTimeoutException) {
                    mResult[i].setSRMMessage(new SRMMessage("HWN021652E", new String[]{this.cCimClient.toString(), e.toString()}));
                    mResult[i].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH)));
                    mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
                    continue;
                }
                if (e instanceof ServerException) {
                    mResult[i].setSRMMessage(((ServerException)((Object)e)).getSRMMessage());
                    mResult[i].setReturnException(e);
                    continue;
                }
                mResult[i].setSRMMessage(new SRMMessage("HWN021503E", new String[0]));
                mResult[i].setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
            }
        }
        finally {
            block30: {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException pEx) {
                        if (!mLTH.isTraceHighEnabled()) break block30;
                        mLTH.traceWarning(pEx.getMessage());
                    }
                }
            }
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }
}

