/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.regex.PatternSyntaxException;
import org.eclipse.aperi.disk.control.IStorageConfigurationManagementPlugin;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public class StorageConfigurationPluginExtensionMgr
extends AbstractExtensionMgr {
    private static StorageConfigurationPluginExtensionMgr singleton = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.disk.storageConfiguration";
    private static final String CONFIGURATION_ELEMENT = "StorageConfigurationPlugin";
    private static final String ATTR_PROFILE = "profile";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VENDOR = "vendor";
    private static final String ATTR_SMIS = "SMIS";
    private static final String ATTR_NAME = "name";

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    public StorageConfigurationPluginExtensionMgr() {
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        reg.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public static synchronized StorageConfigurationPluginExtensionMgr getExtensionMgr() {
        if (singleton == null) {
            singleton = new StorageConfigurationPluginExtensionMgr();
        }
        return singleton;
    }

    public void dispose() {
        super.dispose();
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public IStorageConfigurationPlugin getPlugin(ConfigurationParameter pParams) {
        IExtensionPoint mPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (mPoint == null) {
            return null;
        }
        IExtension[] bExtensions = mPoint.getExtensions();
        for (int bExtIndex = 0; bExtIndex < bExtensions.length; ++bExtIndex) {
            IConfigurationElement[] bCES = bExtensions[bExtIndex].getConfigurationElements();
            for (int bConfigIndex = 0; bConfigIndex < bCES.length; ++bConfigIndex) {
                if (!bCES[bConfigIndex].getName().equals(CONFIGURATION_ELEMENT)) continue;
                IConfigurationElement bCE = bCES[bConfigIndex];
                String sName = bCE.getAttribute(ATTR_NAME);
                String sSMIS = bCE.getAttribute(ATTR_SMIS);
                String sType = bCE.getAttribute(ATTR_TYPE);
                String sVendor = bCE.getAttribute(ATTR_VENDOR);
                String sProfile = bCE.getAttribute(ATTR_PROFILE);
                if (!StorageConfigurationPluginExtensionMgr.matchesStringPattern(pParams.getCapability().getSmisVersion(), sSMIS) || !StorageConfigurationPluginExtensionMgr.matchesStringPattern(pParams.getStorageSubsystem().getType(), sType)) continue;
                IStorageConfigurationManagementPlugin plugin = null;
                try {
                    plugin = (IStorageConfigurationManagementPlugin)this.getExtensionImpl(bExtensions[bExtIndex].getUniqueIdentifier());
                    if (plugin != null) {
                        plugin.setParams(pParams);
                    }
                    return plugin;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return plugin;
                }
            }
        }
        return null;
    }

    protected static boolean matchesStringPattern(String string, String pattern) {
        if (pattern == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        try {
            return string.trim().toUpperCase().matches(pattern.trim().toUpperCase());
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }
}

