/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangementSVC;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementSVC;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.CIM.VolumeManagementSVC;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginSVC
extends StorageConfigurationPlugin {
    public VolumeManagement getVolumeManagement() {
        if (this.cVolumeManagement == null) {
            this.cVolumeManagement = new VolumeManagementSVC(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cVolumeManagement;
    }

    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = new MappingManagementSVC(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    public HardwareIDMangement getHardwareIDManagement() {
        if (this.cHardwareIDManagement == null) {
            this.cHardwareIDManagement = new HardwareIDMangementSVC(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cHardwareIDManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public AsyncResult[] createSVCVDisks(CreateSVCStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        mAsyncResult = null;
        mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"createSVCVDisks", (Object[])new Object[]{pParam});
        try {
            mResult = new Vector<AsyncResult>();
            mStoragePoolCIMOPs = pParam.getStoragePoolCIMOPs();
            mStoragePools = pParam.getStoragePools();
            mVolumeNames = pParam.getVolumeNames();
            mSizes = pParam.getSizes();
            bCimClient = null;
            idx = 0;
            try {
                bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
                bCimClient.setTimeout(1200000L);
                pParam.setCIMClientWrapper(bCimClient);
                for (idx = 0; idx < mStoragePoolCIMOPs.length; ++idx) {
                    DiskMessageHelper.getSRMMessage((String)"HWN021675I", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    bAsyncRes = new AsyncResult(-1, -1);
                    bSizesSupported = this.getVolumeManagement().getSupportedSizeRange(mStoragePoolCIMOPs[idx], null);
                    storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[idx], (StorageSubsystem)pParam.getStorageSubsystem());
                    bFinalSize = this.checkVolumeSize(mSizes[idx], bSizesSupported, mResult, bAsyncRes, storagePoolID, pParam.getStorageSubsystemID(), pParam.getToken());
                    bMDiskCIMOPs /* !! */  = null;
                    bMDiskCIMOPs /* !! */  = pParam.getVirtualizationType() == 0 ? pParam.getMDiskCIMOPs() : (pParam.getVirtualizationType() == 1 || pParam.getVirtualizationType() == 2 ? new CIMObjectPath[]{pParam.getMDiskCIMOPs()[idx]} : null);
                    bAsyncRes = ((VolumeManagementSVC)this.getVolumeManagement()).createStorageVolume(storagePoolID, mStoragePoolCIMOPs[idx], mVolumeNames[idx], bFinalSize, bMDiskCIMOPs /* !! */ , pParam.isFormatOnCreate(), pParam.getVirtualizationType(), pParam.getIoGroup());
                    DiskMessageHelper.getSRMMessage((String)"HWN021676I", (Object)pParam.getVolumeElementName(), (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    mResult.add(bAsyncRes);
                }
                ** if (bCimClient == null) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    DiskMessageHelper.getSRMMessage((String)"HWN021677E", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                    bException = null;
                    bRC = 10001;
                    for (i = 0; i < mResult.size(); ++i) {
                        bFailureResult = (AsyncResult)mResult.elementAt(i);
                        if (bFailureResult.getReturnException() == null) continue;
                        bException = (ServerException)bFailureResult.getReturnException();
                        bRC = bFailureResult.getRc();
                        for (j = i; j < mResult.size(); ++j) {
                            mResult.removeElementAt(j);
                        }
                        break;
                    }
                    for (i = idx; i < mStoragePoolCIMOPs.length; ++i) {
                        storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[i], (StorageSubsystem)pParam.getStorageSubsystem());
                        bResult = new AsyncResult();
                        if (bException != null) {
                            this.setVolumeCreationSubjobFailed(bResult, storagePoolID, bException, bRC, mLTH);
                        } else if (e instanceof ServerException) {
                            this.setVolumeCreationSubjobFailed(bResult, storagePoolID, (ServerException)e, 10001, mLTH);
                        } else {
                            bException2 = DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                            this.setVolumeCreationSubjobFailed(bResult, storagePoolID, bException2, 10001, mLTH);
                        }
                        mResult.add(bResult);
                    }
                    ** if (bCimClient == null) goto lbl-1000
                }
                catch (Throwable var18_25) {
                    if (bCimClient != null) {
                        CIMClientPool.returnClient(bCimClient);
                        bCimClient = null;
                    }
                    throw var18_25;
                }
lbl-1000:
                // 1 sources

                {
                    CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                    bCimClient = null;
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                bCimClient = null;
            }
lbl-1000:
            // 2 sources

            {
            }
            var11_11 = mAsyncResult = mResult.toArray(new AsyncResult[mResult.size()]);
        }
        catch (Throwable var19_26) {
            mLTH.exit(mAsyncResult);
            throw var19_26;
        }
        mLTH.exit((Object)mAsyncResult);
        return var11_11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult modifyStoragePoolSize(ModifyStoragePoolParameter pParam) throws NotAvailableException, Exception {
        AsyncResult mResult = new AsyncResult(10001, -1);
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"modifyStoragePoolSize", (Object[])new Object[]{pParam});
        try {
            DiskMessageHelper.getSRMMessage((String)"HWN021687I", (Object)pParam.getStoragePool().getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
            CIMClientWrapper bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
            try {
                bCimClient.setTimeout(1200000L);
                pParam.setCIMClientWrapper(bCimClient);
                mResult = ((VolumeManagementSVC)this.getVolumeManagement()).modifyStoragePoolSize(pParam);
                DiskMessageHelper.getSRMMessage((String)"HWN021688I", (Object)pParam.getStoragePool().getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
            }
            catch (ServerException e) {
                DiskMessageHelper.getSRMMessage((String)"HWN021689E", (Object)pParam.getStoragePool().getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                mResult.setSRMMessage(e.getSRMMessage());
                mResult.setStatus(0);
                mResult.setRc(10007);
            }
            catch (Exception e) {
                SRMMessage mMsg = DiskMessageHelper.getSRMMessage((String)"HWN021689E", (Object)pParam.getStoragePool().getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                mResult.setSRMMessage(mMsg);
                mResult.setStatus(0);
                mResult.setRc(10001);
            }
            finally {
                if (bCimClient != null) {
                    CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                    bCimClient = null;
                }
            }
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAssignAccess(AssignStorageVolumesParameter pParam) throws ServerException {
        block10: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"validateAssignAccess", (Object[])new Object[]{pParam});
            try {
                super.validateAssignAccess(pParam);
                try {
                    DBConnection mConnection = ServiceUtils.getConnection();
                    try {
                        this.setIoGroups(pParam, mConnection, mLTH);
                        ArrayList mInitiatorPorts = pParam.getInitiatorPortList();
                        ArrayList mAffectedInitiatorPorts = this.retrieveAffectedInitiatorPorts(mConnection, pParam);
                        List mCollateralPorts = this.extractUniquePorts(mInitiatorPorts, mAffectedInitiatorPorts);
                        if (mCollateralPorts.size() <= 0) break block10;
                        mInitiatorPorts.addAll(mCollateralPorts);
                        String[] mCollateralWWPNs = this.convertPortListToStringArray(mCollateralPorts);
                        ArrayList mInitiatorWWPNs = pParam.getInitiatorWWPNs();
                        mInitiatorWWPNs.addAll(Arrays.asList(mCollateralWWPNs));
                        pParam.setInitiatorPorts(mInitiatorPorts);
                        pParam.setInitiatorWWPNs(mInitiatorWWPNs);
                        if (pParam.isForce()) {
                            SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021605I", null, null, (LogTraceHelper)mLTH);
                            AsyncResult mResult = pParam.getAsyncResult();
                            mResult.setSRMMessage(tpcMsg);
                            pParam.setAsyncResult(mResult);
                            break block10;
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021606E", (Object)mCollateralWWPNs, (Object)"", (LogTraceHelper)mLTH);
                    }
                    finally {
                        if (mConnection != null) {
                            mConnection.close();
                        }
                    }
                }
                catch (SQLException sqlEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            finally {
                mLTH.exit(null);
            }
        }
    }

    private ArrayList retrieveAffectedInitiatorPorts(DBConnection pConnection, AssignmentParameter pParam) {
        Port[] mOriginalInitiatorPorts = pParam.getInitiatorPorts();
        ArrayList mOriginalInitiatorWWPNs = pParam.getInitiatorWWPNs();
        HardwareIDMangement mHwIdMgmt = new HardwareIDMangement(this, pParam.getCIMClientWrapper(), pParam.getStorageSubsystemCIMOP(), String.valueOf(pParam.getStorageSubsystem().getSubsystemId()), pParam.getToken());
        ArrayList mOriginalHwIds = mHwIdMgmt.retrieveStorageHardwareIDs(mOriginalInitiatorWWPNs, false);
        ArrayList mFinalHwIds = new ArrayList();
        ArrayList mCollections = mHwIdMgmt.retrieveCollectionsForStorageHardwareIDs(mOriginalHwIds, mFinalHwIds);
        for (int i = 0; i < mCollections.size(); ++i) {
            mFinalHwIds.addAll(mHwIdMgmt.retrieveStorageHardwareIDsOfHardwareIDCollection((HardwareIDCollection)mCollections.get(i)));
        }
        ArrayList<Port> mFinalInitiatorPorts = new ArrayList<Port>();
        for (int i = 0; i < mFinalHwIds.size(); ++i) {
            StorageHardwareID mId = (StorageHardwareID)mFinalHwIds.get(i);
            try {
                mFinalInitiatorPorts.add(ExternalKeyManager.getPort((String)mId.getWWPN(), (int)pParam.getStorageSubsystem().getSubsystemId(), (DBConnection)pConnection));
                continue;
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        return mFinalInitiatorPorts;
    }

    private void setIoGroups(AssignStorageVolumesParameter pParam, DBConnection pConnection, LogTraceHelper pLTH) throws SQLException {
        StorageVolume[] mStorageVols = pParam.getVolumes();
        Integer[] bIOGroupIDs = new Integer[mStorageVols.length];
        CIMObjectPath[] bIOGroupCOPs = new CIMObjectPath[mStorageVols.length];
        for (int i = 0; i < mStorageVols.length; ++i) {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(IoGroup.class, (String)"IO_GROUP_ID", (LogTraceHelper)pLTH);
            mWhereClause.put(mInfo, String.valueOf(mStorageVols[i].getIoGroupId()));
            IoGroup.IoGroupCursor mCursor = IoGroup.getCursor((DBConnection)pConnection, mWhereClause, null);
            if (!mCursor.next()) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)"No io group entry for SVC volume in db", (LogTraceHelper)pLTH);
            }
            IoGroup ioGroup = mCursor.getObject();
            bIOGroupIDs[i] = new Integer(ioGroup.getGroupId());
            bIOGroupCOPs[i] = ExternalKeyManager.getIOGroupCIMObjectPath((String)pParam.getStorageSubsystem().getIpAddress(), (String)ioGroup.getGroupId(), (String)"IBMTSSVC_IOGroup", (String)pParam.getStorageSubsystemCIMOP().getNameSpace());
        }
        pParam.setIOGroups(bIOGroupIDs, bIOGroupCOPs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateUnAssignAccess(AssignmentParameter pParam) throws ServerException {
        block10: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"validateUnAssignAccess", (Object[])new Object[]{pParam});
            try {
                super.validateUnAssignAccess(pParam);
                try {
                    DBConnection mConnection = ServiceUtils.getConnection();
                    try {
                        Port[] mOriginalInitiatorPorts = pParam.getInitiatorPorts();
                        ArrayList mAffectedInitiatorPorts = this.retrieveAffectedInitiatorPorts(mConnection, pParam);
                        String[] mAffectedInitiatorPortWWPNs = this.convertPortListToStringArray(mAffectedInitiatorPorts);
                        pParam.setInitiatorPorts(mAffectedInitiatorPorts);
                        pParam.setInitiatorWWPNs(mAffectedInitiatorPortWWPNs);
                        if (mOriginalInitiatorPorts.length >= mAffectedInitiatorPorts.size()) break block10;
                        List mAdditionalPorts = this.extractUniquePorts(Arrays.asList(mOriginalInitiatorPorts), mAffectedInitiatorPorts);
                        if (pParam.isForce()) {
                            SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021603W", null, null, (LogTraceHelper)mLTH);
                            AsyncResult mResult = pParam.getAsyncResult();
                            mResult.setSRMMessage(tpcMsg);
                            pParam.setAsyncResult(mResult);
                            break block10;
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021604E", (Object)mAffectedInitiatorPortWWPNs, (Object)this.convertPortListToStringArray(mAdditionalPorts), (Object)pParam.getVolumeIDs(), (Object)"", (LogTraceHelper)mLTH);
                    }
                    finally {
                        if (mConnection != null) {
                            mConnection.close();
                        }
                    }
                }
                catch (SQLException sqlEx) {
                    mLTH.traceError("SQLException during db traversal.", (Throwable)sqlEx);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            finally {
                mLTH.exit(null);
            }
        }
    }
}

