/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.VolumeAssignmentModifyParams;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class AssignmentParameter
extends ConfigurationParameter {
    public static int MASK = 2;
    public static int MAP = 1;
    public static int MASK_AND_MAP = 3;
    protected ArrayList cInitiatorPorts;
    protected ArrayList cInitiatorPortWWPNs = new ArrayList();
    protected ArrayList cInitiatorCOPs = new ArrayList();
    protected Port[] cTargetPorts;
    protected CIMObjectPath[] cTargetPortCOPs;
    protected String[] cTargetPortWWPNs;
    protected String[] cTargetPortIDs;
    protected Capabilities cPCCaps;
    protected boolean cForce;
    protected int cMappingMode;
    protected ArrayList cMappingsToModify = new ArrayList();

    public AssignmentParameter() {
    }

    public AssignmentParameter(StorageSubsystem pStorageSubsystem, CIMObjectPath pStorageSystemCIMOP) {
        super(pStorageSubsystem, pStorageSystemCIMOP);
    }

    public ArrayList getInitiatorWWPNs() {
        return this.cInitiatorPortWWPNs;
    }

    public String[] getInitiatorWWPNsArray() {
        return this.cInitiatorPortWWPNs.toArray(new String[this.cInitiatorPortWWPNs.size()]);
    }

    public void setInitiatorWWPNs(ArrayList pWWPNs) {
        this.cInitiatorPortWWPNs = pWWPNs;
    }

    public void setInitiatorWWPNs(String[] pWWPNs) {
        this.cInitiatorPortWWPNs = new ArrayList<String>(Arrays.asList(pWWPNs));
    }

    public CIMObjectPath[] getTargetPortCOPs() {
        return this.cTargetPortCOPs;
    }

    public void setTargetPortCOPs(CIMObjectPath[] ports) {
        this.cTargetPortCOPs = ports;
    }

    public void setPCCaps(Capabilities pCaps) {
        this.cPCCaps = pCaps;
    }

    public String[] getTargetPortWWPNs() {
        return this.cTargetPortWWPNs;
    }

    public void setTargetPortWWPNs(String[] pPortWWPNs) {
        this.cTargetPortWWPNs = pPortWWPNs;
    }

    public boolean isForce() {
        return this.cForce;
    }

    public void setForce(boolean pForce) {
        this.cForce = pForce;
    }

    public int getMappingMode() {
        return this.cMappingMode;
    }

    public void setMappingMode(int pMappingMode) {
        this.cMappingMode = pMappingMode;
    }

    public Port[] getInitiatorPorts() {
        return this.cInitiatorPorts != null ? this.cInitiatorPorts.toArray(new Port[this.cInitiatorPorts.size()]) : null;
    }

    public ArrayList getInitiatorPortList() {
        return this.cInitiatorPorts;
    }

    public Port[] getTargetPorts() {
        return this.cTargetPorts;
    }

    public void setInitiatorPorts(ArrayList list) {
        this.cInitiatorPorts = list;
    }

    public void setTargetPorts(Port[] pPorts) {
        this.cTargetPorts = pPorts;
    }

    public String[] getTargetPortIDs() {
        return this.cTargetPortIDs;
    }

    public void setTargetPortIDs(String[] pTargetPortIDs) {
        this.cTargetPortIDs = pTargetPortIDs;
    }

    public ArrayList getInitiatorCOPs() {
        return this.cInitiatorCOPs;
    }

    public void setInitiatorCOPs(ArrayList pList) {
        this.cInitiatorCOPs = pList;
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.prepareToString());
        sb.append("Initiator Port WWPNs: {");
        sb.append(OutputHelper.listToCS((List)this.cInitiatorPortWWPNs));
        sb.append("}");
        return sb.toString();
    }

    public ArrayList getMappingsToModify() {
        return this.cMappingsToModify;
    }

    public void addMappingsToModify(VolumeAssignmentModifyParams pMapping) {
        this.cMappingsToModify.add(pMapping);
    }
}

