/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class HardwareIDCollection {
    private CIMObjectPath cHardwareIDCollectionCOP;
    private CIMInstance cHardwareIDCollectionInstance;
    private ArrayList cStorageHardwareIDs = new ArrayList();

    public HardwareIDCollection(CIMObjectPath pHardwareIDCollectionCOP) {
        this.cHardwareIDCollectionCOP = pHardwareIDCollectionCOP;
    }

    public CIMObjectPath getHardwareIDCollectionCOP() {
        return this.cHardwareIDCollectionCOP;
    }

    public void setHardwareIDCollectionCOP(CIMObjectPath pHardwareIDCollectionCOP) {
        this.cHardwareIDCollectionCOP = pHardwareIDCollectionCOP;
    }

    public ArrayList getStorageHardwareIDs() {
        return this.cStorageHardwareIDs;
    }

    public void addStorageHardwareID(StorageHardwareID pStorageHardwareID) {
        if (!this.cStorageHardwareIDs.contains(pStorageHardwareID)) {
            this.cStorageHardwareIDs.add(pStorageHardwareID);
        }
    }

    public void addStorageHardwareIDs(ArrayList pStorageHardwareIDs) {
        for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
            this.addStorageHardwareID((StorageHardwareID)pStorageHardwareIDs.get(i));
        }
    }

    public void setStorageHardwareIDs(ArrayList pStorageHardwareIDs) {
        this.cStorageHardwareIDs = pStorageHardwareIDs;
    }

    public boolean containsStorageHardwareID(StorageHardwareID pStorageHardwareID) {
        return this.cStorageHardwareIDs.contains(pStorageHardwareID);
    }

    public boolean containsStorageHardwareID(String pWWPN) {
        for (int i = 0; i < this.cStorageHardwareIDs.size(); ++i) {
            if (!((StorageHardwareID)this.cStorageHardwareIDs.get(i)).getWWPN().equalsIgnoreCase(pWWPN)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getWWPNs() {
        ArrayList<String> mWWPNs = new ArrayList<String>();
        for (int i = 0; i < this.cStorageHardwareIDs.size(); ++i) {
            mWWPNs.add(((StorageHardwareID)this.cStorageHardwareIDs.get(i)).getWWPN());
        }
        return mWWPNs;
    }

    public CIMInstance getHardwareIDCollectionInstance() {
        return this.cHardwareIDCollectionInstance;
    }

    public void setHardwareIDCollectionInstance(CIMInstance pHardwareIDCollectionInstance) {
        this.cHardwareIDCollectionInstance = pHardwareIDCollectionInstance;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(OutputHelper.toStringHeader(this.getClass()));
        sb.append(this.prepareToString());
        sb.append(OutputHelper.toStringFooter(this.getClass()));
        return sb.toString();
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Hardware ID Collection COP: ");
        if (this.cHardwareIDCollectionCOP != null) {
            sb.append(this.cHardwareIDCollectionCOP.toString());
        } else {
            sb.append("null");
        }
        sb.append("; WWPNs: {");
        sb.append(OutputHelper.listToCS((List)this.getWWPNs()));
        sb.append("}");
        return sb.toString();
    }
}

