/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class PrivilegeToWWPNs {
    private CIMObjectPath cPrivilege;
    private ArrayList cHardwareIDCollections = new ArrayList();
    private ArrayList cStorageHardwareIDs = new ArrayList();

    public PrivilegeToWWPNs(CIMObjectPath pPrivilegeCOP) {
        this.cPrivilege = pPrivilegeCOP;
    }

    public PrivilegeToWWPNs(CIMObjectPath pPrivilegeCOP, StorageHardwareID[] pStorageHardwareIDs) {
        this.cPrivilege = pPrivilegeCOP;
        for (int i = 0; i < pStorageHardwareIDs.length; ++i) {
            this.cStorageHardwareIDs.add(pStorageHardwareIDs[i]);
        }
    }

    public PrivilegeToWWPNs(CIMObjectPath pPrivilegeCOP, StorageHardwareID pStorageHardwareID) {
        this.cPrivilege = pPrivilegeCOP;
        this.cStorageHardwareIDs.add(pStorageHardwareID);
    }

    public PrivilegeToWWPNs(CIMObjectPath pPrivilegeCOP, HardwareIDCollection pHardwareIDCollection) {
        this.cPrivilege = pPrivilegeCOP;
        this.cHardwareIDCollections.add(pHardwareIDCollection);
    }

    public PrivilegeToWWPNs(CIMObjectPath pPrivilegeCOP, Object pStorageHardwareIDOrHardwareIDCollection) {
        this.cPrivilege = pPrivilegeCOP;
        if (pStorageHardwareIDOrHardwareIDCollection instanceof StorageHardwareID) {
            this.cStorageHardwareIDs.add(pStorageHardwareIDOrHardwareIDCollection);
            return;
        }
        if (pStorageHardwareIDOrHardwareIDCollection instanceof HardwareIDCollection) {
            this.cHardwareIDCollections.add(pStorageHardwareIDOrHardwareIDCollection);
            return;
        }
        throw new RuntimeException("Invalid Class, use StorageHardwareID or HardwareIDCollection");
    }

    public boolean equals(PrivilegeToWWPNs pPrivilegeToWWPNs) {
        return pPrivilegeToWWPNs.getPrivilege().equals((Object)this.cPrivilege);
    }

    public boolean equals(Object pPrivilegeToWWPNs) {
        if (!(pPrivilegeToWWPNs instanceof PrivilegeToWWPNs)) {
            return false;
        }
        return ((PrivilegeToWWPNs)pPrivilegeToWWPNs).getPrivilege().equals((Object)this.cPrivilege);
    }

    public boolean containsStorageHardwareID(StorageHardwareID pStorageHardwareID) {
        return this.cStorageHardwareIDs.contains(pStorageHardwareID);
    }

    public boolean containsStorageHardwareIDInstance(CIMInstance pStorageHardwareIDInstance) {
        for (int i = 0; i < this.cStorageHardwareIDs.size(); ++i) {
            StorageHardwareID bStorageHardwareID = (StorageHardwareID)this.cStorageHardwareIDs.get(i);
            if (!bStorageHardwareID.getStorageHardwareIDInstance().equals((Object)pStorageHardwareIDInstance)) continue;
            return true;
        }
        return false;
    }

    public CIMObjectPath getPrivilege() {
        return this.cPrivilege;
    }

    public void setPrivilege(CIMObjectPath pPrivilege) {
        this.cPrivilege = pPrivilege;
    }

    public ArrayList getStorageHardwareIDs() {
        return this.cStorageHardwareIDs;
    }

    public void addStorageHardwareID(StorageHardwareID pStorageHardwareID) {
        if (!this.cStorageHardwareIDs.contains(pStorageHardwareID)) {
            this.cStorageHardwareIDs.add(pStorageHardwareID);
        }
    }

    public void addStorageHardwareIDs(ArrayList pStorageHardwareIDs) {
        for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
            this.cStorageHardwareIDs.add(pStorageHardwareIDs.get(i));
        }
    }

    public void addStorageHardwareIDCollection(HardwareIDCollection pHardwareIDCollection) {
        if (!this.cStorageHardwareIDs.contains(pHardwareIDCollection)) {
            this.cStorageHardwareIDs.add(pHardwareIDCollection);
        }
    }

    public void addInitiator(Object pInitiator) {
        if (pInitiator instanceof StorageHardwareID) {
            this.cStorageHardwareIDs.add(pInitiator);
            return;
        }
        if (pInitiator instanceof HardwareIDCollection) {
            this.cHardwareIDCollections.add(pInitiator);
            return;
        }
        throw new RuntimeException("Invalid Class, use StorageHardwareID or HardwareIDCollection");
    }

    public ArrayList getWWPNs() {
        int i;
        ArrayList<String> mWWPNs = new ArrayList<String>();
        for (i = 0; i < this.cStorageHardwareIDs.size(); ++i) {
            mWWPNs.add(((StorageHardwareID)this.cStorageHardwareIDs.get(i)).getWWPN());
        }
        for (i = 0; i < this.cHardwareIDCollections.size(); ++i) {
            mWWPNs.addAll(((HardwareIDCollection)this.cHardwareIDCollections.get(i)).getWWPNs());
        }
        return mWWPNs;
    }

    public ArrayList getHardwareIDCollections() {
        return this.cHardwareIDCollections;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(OutputHelper.toStringHeader(this.getClass()));
        sb.append(this.prepareToString());
        sb.append(OutputHelper.toStringFooter(this.getClass()));
        return sb.toString();
    }

    public List getAllStorageHardwareIDs() {
        int i;
        ArrayList<StorageHardwareID> mHWIDs = new ArrayList<StorageHardwareID>();
        for (i = 0; i < this.cStorageHardwareIDs.size(); ++i) {
            mHWIDs.add((StorageHardwareID)this.cStorageHardwareIDs.get(i));
        }
        for (i = 0; i < this.cHardwareIDCollections.size(); ++i) {
            mHWIDs.addAll(((HardwareIDCollection)this.cHardwareIDCollections.get(i)).getStorageHardwareIDs());
        }
        return mHWIDs;
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Privilege COP: ");
        if (this.cPrivilege != null) {
            sb.append(this.cPrivilege.toString());
        } else {
            sb.append("null");
        }
        sb.append("; WWPNs: {");
        sb.append(OutputHelper.listToCS((List)this.getWWPNs()));
        sb.append("}");
        return sb.toString();
    }
}

