/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProtocolControllerToPrivileges {
    private CIMObjectPath cProtocolController;
    private ArrayList cPrivilegeToWWPNs = new ArrayList();
    private CIMObjectPath cIOGroupCOP;
    private Integer cIOGroupID;

    public ProtocolControllerToPrivileges(CIMObjectPath pProtocolController, ArrayList pPrivilegeToWWPNs) {
        this.cProtocolController = pProtocolController;
        this.cPrivilegeToWWPNs = pPrivilegeToWWPNs;
    }

    public ProtocolControllerToPrivileges(CIMObjectPath pProtocolController) {
        this.cProtocolController = pProtocolController;
    }

    public ProtocolControllerToPrivileges(CIMObjectPath pProtocolController, PrivilegeToWWPNs[] pPrivilegeToWWPNs) {
        this.cProtocolController = pProtocolController;
        for (int i = 0; i < pPrivilegeToWWPNs.length; ++i) {
            this.cPrivilegeToWWPNs.add(pPrivilegeToWWPNs[i]);
        }
    }

    public ProtocolControllerToPrivileges(CIMObjectPath pProtocolController, PrivilegeToWWPNs pPrivilegeToWWPNs) {
        this.cProtocolController = pProtocolController;
        this.cPrivilegeToWWPNs.add(pPrivilegeToWWPNs);
    }

    public boolean equals(ProtocolControllerToPrivileges pPCToPrivileges) {
        return pPCToPrivileges.getProtocolController().equals((Object)this.cProtocolController);
    }

    public boolean equals(Object pPCToPrivileges) {
        if (!(pPCToPrivileges instanceof ProtocolControllerToPrivileges)) {
            return false;
        }
        return ((ProtocolControllerToPrivileges)pPCToPrivileges).getProtocolController().equals((Object)this.cProtocolController);
    }

    public boolean containsPrivilege(PrivilegeToWWPNs pPrivilegeToWWPNs) {
        return this.cPrivilegeToWWPNs.contains(pPrivilegeToWWPNs);
    }

    public ArrayList getPrivilegeToWWPNs() {
        return this.cPrivilegeToWWPNs;
    }

    public void setPrivilegeToWWPNs(ArrayList pPrivilegeToWWPNs) {
        this.cPrivilegeToWWPNs = pPrivilegeToWWPNs;
    }

    public CIMObjectPath getProtocolController() {
        return this.cProtocolController;
    }

    public void setProtocolController(CIMObjectPath pProtocolController) {
        this.cProtocolController = pProtocolController;
    }

    public void add(PrivilegeToWWPNs pPrivelegeToWWPNs) {
        if (!this.cPrivilegeToWWPNs.contains(pPrivelegeToWWPNs)) {
            this.cPrivilegeToWWPNs.add(pPrivelegeToWWPNs);
        }
    }

    public ArrayList getWWPNs() {
        ArrayList mWWPNs = new ArrayList();
        for (int i = 0; i < this.cPrivilegeToWWPNs.size(); ++i) {
            PrivilegeToWWPNs mPrivilegeToWWPN = (PrivilegeToWWPNs)this.cPrivilegeToWWPNs.get(i);
            mWWPNs.addAll(mPrivilegeToWWPN.getWWPNs());
        }
        return mWWPNs;
    }

    public List getStorageHardwareIDs() {
        ArrayList mHWIDs = new ArrayList();
        for (int i = 0; i < this.cPrivilegeToWWPNs.size(); ++i) {
            PrivilegeToWWPNs mPrivilegeToWWPN = (PrivilegeToWWPNs)this.cPrivilegeToWWPNs.get(i);
            mHWIDs.addAll(mPrivilegeToWWPN.getAllStorageHardwareIDs());
        }
        return mHWIDs;
    }

    public CIMObjectPath getIOGroupCOP() {
        return this.cIOGroupCOP;
    }

    public void setIOGroup(CIMObjectPath pIOGroupCOP) {
        this.cIOGroupCOP = pIOGroupCOP;
        String bName = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pIOGroupCOP, (String)"Name");
        bName = bName.substring(bName.indexOf(":") + 1, bName.length());
        this.cIOGroupID = new Integer(bName);
    }

    public Integer getIOGroupID() {
        return this.cIOGroupID;
    }

    public void setIOGroupID(Integer pGroupID) {
        this.cIOGroupID = pGroupID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(OutputHelper.toStringHeader(this.getClass()));
        sb.append(this.prepareToString());
        sb.append(OutputHelper.toStringFooter(this.getClass()));
        return sb.toString();
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Protocol Controller: ");
        if (this.cProtocolController != null) {
            sb.append(this.cProtocolController.toString());
        } else {
            sb.append("null");
        }
        if (this.cIOGroupID != null) {
            sb.append("; I/O Group ID: ");
            sb.append(this.cIOGroupID.toString());
        }
        sb.append("; WWPNs: {");
        sb.append(OutputHelper.listToCS((List)this.getWWPNs()));
        sb.append("}");
        return sb.toString();
    }
}

