/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.SubprofileConstants;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelperDummy;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.UnsignedInt16;

public class Capabilities
implements DiscoveryConstants,
CIMNames,
SubprofileConstants {
    private String cSMISVersion = null;
    private String cSMISProfile = null;
    private String cSMISSubProfile = null;
    private boolean cVolumeCreationSupported = false;
    private boolean cVolumeDeletionSupported = false;
    private boolean cAssignAccessSuported = false;
    private boolean cRemoveAccessSupported = false;
    private boolean cExtendDataAvailable = false;
    private boolean cDriveDataAvailable = false;
    private boolean cRemoteServiceAccessPontDataAvailable = false;
    private boolean cVolumeExpansionSupported = false;
    private boolean cVolumeShrinkingSupported = false;
    private int cNumberOfVolumesSuporrted = 0;
    private String[] cRaidLevelSupported = null;
    private boolean cTargetPortRestrictionSupported = false;
    private int cPortsPerView = 0;
    private boolean cOneHardwareIDPerView = false;
    private boolean cProtocolControllerRequirersAuthorizedIdentity = false;
    private boolean cProtocolControllerSupportsCollection = false;
    private boolean cUniqueUnitNumberPerPort = false;
    private boolean cAttachDeviceSupported = false;
    private boolean cExposePathSupported = false;
    private boolean cSPCAllowsNoLUs = false;
    private boolean cSPCAllowsNoTargets = false;
    private boolean cSPCAllowsNoInitiators = false;
    private boolean cSPCSupportsDefaultViews = false;
    private boolean cClientSelectableDeviceNumbers = false;
    private int cMaxMapCount = 0;

    public Capabilities() {
        this.setSMISVersion("");
        this.setSMISSubProfile("");
        this.setSMISProfile("");
    }

    public Capabilities(CIMInstance pCap, Request pRequest) {
        this.insertCapabilities(pCap, pRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSubProfile(String pSubProfile) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"checkSubProfile", (Object[])new Object[]{pSubProfile});
        try {
            this.setSMISSubProfile(pSubProfile);
            if (pSubProfile != null) {
                String mSubProfile = CIMInstanceHelper.convertSubProfile((String)pSubProfile, (LogTraceHelper)mLTH);
                if (mSubProfile.indexOf("LC") >= 0) {
                    this.setVolumeCreationSupported(true);
                    this.setVolumeDeletionSupported(true);
                } else {
                    this.setVolumeCreationSupported(false);
                    this.setVolumeDeletionSupported(false);
                }
                if (mSubProfile.indexOf("LMM") >= 0 || mSubProfile.indexOf("MM") >= 0) {
                    this.setAssignAccessSuported(true);
                    this.setRemoveAccessSupported(true);
                } else {
                    this.setAssignAccessSuported(false);
                    this.setRemoveAccessSupported(false);
                }
                if (mSubProfile.indexOf("EM") >= 0 || mSubProfile.indexOf("EC") >= 0) {
                    this.setExtendDataAvailable(true);
                } else {
                    this.setExtendDataAvailable(false);
                }
                if (mSubProfile.indexOf("DD") >= 0 || mSubProfile.indexOf("DDL") >= 0) {
                    this.setDriveDataAvailable(true);
                } else {
                    this.setDriveDataAvailable(false);
                }
                if (mSubProfile.indexOf("AP") >= 0) {
                    this.setRemoteServiceAccessPontDataAvailable(true);
                } else {
                    this.setRemoteServiceAccessPontDataAvailable(false);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public void setSVC() {
        this.setVolumeExpansionSupported(true);
        this.setVolumeShrinkingSupported(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCapabilities(CIMInstance pCap, Request pRequest) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pRequest, (Object)this, (String)"insertCapabilities", (Object[])new Object[]{pCap.toString()});
        try {
            this.setNumberOfVolumesSuporrted(0);
            this.setVolumeExpansionSupported(false);
            this.setVolumeShrinkingSupported(false);
            this.setPortsPerView(((UnsignedInt16)CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"PortsPerView")).intValue());
            if (this.getPortsPerView() == 2 || this.getPortsPerView() == 3) {
                this.setTargetPortRestrictionSupported(true);
            }
            this.handleOneHardwareIDPerView(pCap, mLTH);
            this.handleProtocollControllerRequiresAuthorizedIdentity(pCap);
            this.handleControllerSupportsCollection(pCap, mLTH);
            this.handleUniqueUnitNumberPerPort(pCap, mLTH);
            this.handleAttachDeviceSupported(pCap);
            this.handleExposePathSupported(pCap);
            this.handleSPCAllowNoLUs(pCap);
            this.handleSPCAllowsNoTargets(pCap);
            this.handleSPCAllowsNoInitiators(pCap);
            this.handleSPCSupportsDefaultView(pCap);
            this.handleClientSelectableDeviceNumbers(pCap);
            this.handleMaxMapCount(pCap);
        }
        finally {
            mLTH.exit((Object)"");
        }
    }

    private void handleMaxMapCount(CIMInstance pCap) {
        Object mValue = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"MaximumMapCount");
        if (mValue != null) {
            this.setMaxMapCount(((UnsignedInt16)mValue).intValue());
        } else {
            this.setMaxMapCount(0);
        }
    }

    private void handleClientSelectableDeviceNumbers(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"ClientSelectableDeviceNumbers");
        if (mObject == null) {
            this.setClientSelectableDeviceNumbers(false);
        } else {
            this.setClientSelectableDeviceNumbers((Boolean)mObject);
        }
    }

    private void handleSPCSupportsDefaultView(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"SPCSupportsDefaultViews");
        if (mObject == null) {
            this.setSPCSupportsDefaultViews(false);
        } else {
            this.setSPCSupportsDefaultViews((Boolean)mObject);
        }
    }

    private void handleSPCAllowsNoInitiators(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"SPCAllowsNoInitiators");
        if (mObject == null) {
            this.setSPCAllowsNoInitiators(false);
        } else {
            this.setSPCAllowsNoInitiators((Boolean)mObject);
        }
    }

    private void handleSPCAllowsNoTargets(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"SPCAllowsNoTargets");
        if (mObject == null) {
            this.setSPCAllowsNoTargets(false);
        } else {
            this.setSPCAllowsNoTargets((Boolean)mObject);
        }
    }

    private void handleSPCAllowNoLUs(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"SPCAllowsNoLUs");
        if (mObject == null) {
            this.setSPCAllowsNoLUs(false);
        } else {
            this.setSPCAllowsNoLUs((Boolean)mObject);
        }
    }

    private void handleExposePathSupported(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"ExposePathsSupported");
        if (mObject == null) {
            this.setExposePathSupported(false);
        } else {
            this.setExposePathSupported((Boolean)mObject);
        }
    }

    private void handleAttachDeviceSupported(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"AttachDeviceSupported");
        if (mObject == null) {
            this.setAttachDeviceSupported(false);
        } else {
            this.setAttachDeviceSupported((Boolean)mObject);
        }
    }

    private void handleUniqueUnitNumberPerPort(CIMInstance pCap, LogTraceHelper mLTH) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"UniqueUnitNumbersPerPort");
        if (mObject == null) {
            mLTH.traceInfo("no UniqueUnitNumbersPerPort found");
        } else {
            this.setUniqueUnitNumberPerPort((Boolean)mObject);
        }
    }

    private void handleControllerSupportsCollection(CIMInstance pCap, LogTraceHelper mLTH) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"ProtocolControllerSupportsCollections");
        if (mObject == null) {
            mLTH.traceInfo("no ProtocolControllerSupportsCollections found");
        } else {
            this.setProtocolControllerSupportsCollection((Boolean)mObject);
        }
    }

    private void handleProtocollControllerRequiresAuthorizedIdentity(CIMInstance pCap) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"ProtocolControllerRequiresAuthorizedIdentity");
        if (mObject == null) {
            this.setProtocolControllerRequirersAuthorizedIdentity(false);
        } else {
            this.setProtocolControllerRequirersAuthorizedIdentity((Boolean)mObject);
        }
    }

    private void handleOneHardwareIDPerView(CIMInstance pCap, LogTraceHelper mLTH) {
        Object mObject = CIMInstanceHelper.getCIMProperyValue((CIMInstance)pCap, (String)"OneHardwareIDPerView");
        if (mObject == null) {
            mLTH.traceInfo("no OneHardwareIDPerView found");
        } else {
            this.setOneHardwareIDPerView((Boolean)mObject);
        }
    }

    public Hashtable toHashtable(LogTraceHelper pLTH) {
        Hashtable<String, Object> mReturn = new Hashtable<String, Object>();
        mReturn.put("ACCESS_ASSIGNMENT", Boolean.toString(this.isAssignAccessSuported()));
        mReturn.put("ACCESS_POINT", Boolean.toString(this.isRemoteServiceAccessPontDataAvailable()));
        mReturn.put("ACCESS_UNASSIGNMENT", Boolean.toString(this.isRemoveAccessSupported()));
        mReturn.put("ATTACH_DEVICE", Boolean.toString(this.isAttachDeviceSupported()));
        mReturn.put("CONTROLLER_REQ_IDENTITY", Boolean.toString(this.isProtocolControllerRequirersAuthorizedIdentity()));
        mReturn.put("CONTROLLER_SUPP_COLL", Boolean.toString(this.isProtocolControllerSupportsCollection()));
        mReturn.put("DISK_DATA", Boolean.toString(this.isDriveDataAvailable()));
        mReturn.put("EXPOSE_PATH", Boolean.toString(this.isExposePathSupported()));
        mReturn.put("EXTENT_DATA", Boolean.toString(this.isExtendDataAvailable()));
        mReturn.put("NUM_VOLUMES", Integer.toString(this.getNumberOfVolumesSuporrted()));
        mReturn.put("ONE_HW_ID_PER_VIEW", Boolean.toString(this.isOneHardwareIDPerView()));
        mReturn.put("PORTS_PER_VIEW", Integer.toString(this.getPortsPerView()));
        if (this.getRaidLevelSupported() != null) {
            mReturn.put("RAID_LEVELS", this.getRaidLevelSupported());
        }
        mReturn.put("SMIS_PROFILE", this.getSMISProfile());
        mReturn.put("SMIS_SUB_PROFILES", CIMInstanceHelper.convertSubProfile((String)this.getSMISSubProfile(), (LogTraceHelper)pLTH));
        mReturn.put("SMIS_VERSION", this.getSMISVersion());
        mReturn.put("SPC_ALLOWS_DEFAULT_VIEWS", Boolean.toString(this.isSPCSupportsDefaultViews()));
        mReturn.put("SPC_ALLOWS_NO_INITIATORS", Boolean.toString(this.isSPCAllowsNoInitiators()));
        mReturn.put("SPC_ALLOWS_NO_LUS", Boolean.toString(this.isSPCAllowsNoLUs()));
        mReturn.put("SPC_ALLOWS_NO_TGTS", Boolean.toString(this.isSPCAllowsNoTargets()));
        mReturn.put("TARGET_PORT_RESTRICTION", Boolean.toString(this.isTargetPortRestrictionSupported()));
        mReturn.put("UNIQUE_NUM_PER_PORT", Boolean.toString(this.isUniqueUnitNumberPerPort()));
        mReturn.put("VOLUME_CREATION", Boolean.toString(this.isVolumeCreationSupported()));
        mReturn.put("VOLUME_DELETION", Boolean.toString(this.isVolumeDeletionSupported()));
        mReturn.put("VOLUME_EXPANSION", Boolean.toString(this.isVolumeExpansionSupported()));
        mReturn.put("VOLUME_SHRINKING", Boolean.toString(this.isVolumeShrinkingSupported()));
        mReturn.put("CLNT_SELCTBL_DEVNO", Boolean.toString(this.isClientSelectableDeviceNumbers()));
        return mReturn;
    }

    public boolean isAssignAccessSuported() {
        return this.cAssignAccessSuported;
    }

    public void setAssignAccessSuported(boolean pAssignAccessSuported) {
        this.cAssignAccessSuported = pAssignAccessSuported;
    }

    public boolean isAttachDeviceSupported() {
        return this.cAttachDeviceSupported;
    }

    public void setAttachDeviceSupported(boolean pAttachDeviceSupported) {
        this.cAttachDeviceSupported = pAttachDeviceSupported;
    }

    public boolean isDriveDataAvailable() {
        return this.cDriveDataAvailable;
    }

    public void setDriveDataAvailable(boolean pDriveDataAvailable) {
        this.cDriveDataAvailable = pDriveDataAvailable;
    }

    public boolean isExposePathSupported() {
        return this.cExposePathSupported;
    }

    public void setExposePathSupported(boolean pExposePathSupported) {
        this.cExposePathSupported = pExposePathSupported;
    }

    public boolean isExtendDataAvailable() {
        return this.cExtendDataAvailable;
    }

    public void setExtendDataAvailable(boolean pExtendDataAvailable) {
        this.cExtendDataAvailable = pExtendDataAvailable;
    }

    public int getNumberOfVolumesSuporrted() {
        return this.cNumberOfVolumesSuporrted;
    }

    public void setNumberOfVolumesSuporrted(int pNumberOfVolumesSuporrted) {
        this.cNumberOfVolumesSuporrted = pNumberOfVolumesSuporrted;
    }

    public boolean isOneHardwareIDPerView() {
        return this.cOneHardwareIDPerView;
    }

    public void setOneHardwareIDPerView(boolean pOneHardwareIDPerView) {
        this.cOneHardwareIDPerView = pOneHardwareIDPerView;
    }

    public int getPortsPerView() {
        return this.cPortsPerView;
    }

    public void setPortsPerView(int pPortsPerView) {
        this.cPortsPerView = pPortsPerView;
    }

    public boolean isProtocolControllerRequirersAuthorizedIdentity() {
        return this.cProtocolControllerRequirersAuthorizedIdentity;
    }

    public void setProtocolControllerRequirersAuthorizedIdentity(boolean pProtocolControllerRequirersAuthorizedIdentity) {
        this.cProtocolControllerRequirersAuthorizedIdentity = pProtocolControllerRequirersAuthorizedIdentity;
    }

    public boolean isProtocolControllerSupportsCollection() {
        return this.cProtocolControllerSupportsCollection;
    }

    public void setProtocolControllerSupportsCollection(boolean pProtocolControllerSupportsCollection) {
        this.cProtocolControllerSupportsCollection = pProtocolControllerSupportsCollection;
    }

    public String[] getRaidLevelSupported() {
        return this.cRaidLevelSupported;
    }

    public void setRaidLevelSupported(String[] pRaidLevelSupported) {
        this.cRaidLevelSupported = pRaidLevelSupported;
    }

    public boolean isRemoteServiceAccessPontDataAvailable() {
        return this.cRemoteServiceAccessPontDataAvailable;
    }

    public void setRemoteServiceAccessPontDataAvailable(boolean pRemoteServiceAccessPontDataAvailable) {
        this.cRemoteServiceAccessPontDataAvailable = pRemoteServiceAccessPontDataAvailable;
    }

    public boolean isRemoveAccessSupported() {
        return this.cRemoveAccessSupported;
    }

    public void setRemoveAccessSupported(boolean pRemoveAccessSupported) {
        this.cRemoveAccessSupported = pRemoveAccessSupported;
    }

    public String getSMISProfile() {
        return this.cSMISProfile;
    }

    public void setSMISProfile(String pProfile) {
        this.cSMISProfile = pProfile;
    }

    public String getSMISSubProfile() {
        return this.cSMISSubProfile;
    }

    public void setSMISSubProfile(String pSubProfile) {
        this.cSMISSubProfile = pSubProfile;
    }

    public boolean isSPCAllowsNoInitiators() {
        return this.cSPCAllowsNoInitiators;
    }

    public void setSPCAllowsNoInitiators(boolean pAllowsNoInitiators) {
        this.cSPCAllowsNoInitiators = pAllowsNoInitiators;
    }

    public boolean isSPCAllowsNoLUs() {
        return this.cSPCAllowsNoLUs;
    }

    public void setSPCAllowsNoLUs(boolean pAllowsNoLUs) {
        this.cSPCAllowsNoLUs = pAllowsNoLUs;
    }

    public boolean isSPCAllowsNoTargets() {
        return this.cSPCAllowsNoTargets;
    }

    public void setSPCAllowsNoTargets(boolean pAllowsNoTargets) {
        this.cSPCAllowsNoTargets = pAllowsNoTargets;
    }

    public boolean isSPCSupportsDefaultViews() {
        return this.cSPCSupportsDefaultViews;
    }

    public void setSPCSupportsDefaultViews(boolean pSupportsDefaultViews) {
        this.cSPCSupportsDefaultViews = pSupportsDefaultViews;
    }

    public boolean isTargetPortRestrictionSupported() {
        return this.cTargetPortRestrictionSupported;
    }

    public void setTargetPortRestrictionSupported(boolean pTargetPortRestrictionSupported) {
        this.cTargetPortRestrictionSupported = pTargetPortRestrictionSupported;
    }

    public boolean isUniqueUnitNumberPerPort() {
        return this.cUniqueUnitNumberPerPort;
    }

    public void setUniqueUnitNumberPerPort(boolean pUniqueUnitNumberPerPort) {
        this.cUniqueUnitNumberPerPort = pUniqueUnitNumberPerPort;
    }

    public boolean isVolumeCreationSupported() {
        return this.cVolumeCreationSupported;
    }

    public void setVolumeCreationSupported(boolean pVolumeCreationSupported) {
        this.cVolumeCreationSupported = pVolumeCreationSupported;
    }

    public boolean isVolumeDeletionSupported() {
        return this.cVolumeDeletionSupported;
    }

    public void setVolumeDeletionSupported(boolean pVolumeDeletionSupported) {
        this.cVolumeDeletionSupported = pVolumeDeletionSupported;
    }

    public boolean isVolumeExpansionSupported() {
        return this.cVolumeExpansionSupported;
    }

    public void setVolumeExpansionSupported(boolean pVolumeExpansionSupported) {
        this.cVolumeExpansionSupported = pVolumeExpansionSupported;
    }

    public boolean isVolumeShrinkingSupported() {
        return this.cVolumeShrinkingSupported;
    }

    public void setVolumeShrinkingSupported(boolean pVolumeShrinkingSupported) {
        this.cVolumeShrinkingSupported = pVolumeShrinkingSupported;
    }

    public String getSMISVersion() {
        return this.cSMISVersion;
    }

    public void setSMISVersion(String pVersion) {
        this.cSMISVersion = pVersion;
    }

    public boolean isClientSelectableDeviceNumbers() {
        return this.cClientSelectableDeviceNumbers;
    }

    public void setClientSelectableDeviceNumbers(boolean pClientSelectableDeviceNumbers) {
        this.cClientSelectableDeviceNumbers = pClientSelectableDeviceNumbers;
    }

    public String toString() {
        LogTraceHelper mLTH = LogTraceHelperDummy.entry((Object)this, (String)"checkSubProfile", (Object[])new Object[0]);
        return this.toHashtable(mLTH).toString();
    }

    public int getMaxMapCount() {
        return this.cMaxMapCount;
    }

    public void setMaxMapCount(int pI) {
        this.cMaxMapCount = pI;
    }
}

