/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.ProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.sblim.wbem.cim.CIMInstance;

public class GenericNonDiskDiscoveryProcessPlugin
extends ProcessPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericNonDiskDiscoveryProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"GenericDiscoveryProcessPlugin", null);
        try {
            mLTH.objectCreation(GenericNonDiskDiscoveryProcessPlugin.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    public List collectDeviceData(String pObjectManagerID, String pCIMOMVersion) throws DiscoveryException {
        String mMethodName = "collectDeviceData";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pObjectManagerID});
        LinkedList mDeviceList = new LinkedList();
        LinkedList mReturn = new LinkedList();
        String mScannID = null;
        Response mResponse = null;
        Enumeration mObjMgrEnum = null;
        List mStorageProfileList = null;
        Iterator mStorageProfileIterator = null;
        try {
            if (pObjectManagerID == null) {
                mLTH.traceInfo("(ObjectManagerID) == null -> No connection to the CIMOM: " + ((String[])this.cParameters.get("CIMOM"))[0]);
                List list = null;
                return list;
            }
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(pObjectManagerID).get(0);
            if (!mObjectJob.isSuccessful()) {
                mLTH.traceInfo("ServerProfile not supported");
                List list = null;
                return list;
            }
            mScannID = mObjectJob.getResourceId();
            mResponse = mObjectJob.getResponse();
            mObjMgrEnum = (Enumeration)mResponse.getData();
            mStorageProfileList = this.getStorageProfiles();
            mStorageProfileIterator = mStorageProfileList.iterator();
            CIMInstance mProfileInstance = null;
            String mSubProfile = null;
            while (mStorageProfileIterator.hasNext()) {
                mProfileInstance = (CIMInstance)mStorageProfileIterator.next();
                mSubProfile = null;
                if (!this.isUsedProfile(mProfileInstance)) continue;
                List mSystemList = this.getSystemsForProfile(mProfileInstance);
                this.handleComputerSystem(mDeviceList, mProfileInstance, mSubProfile, mSystemList);
            }
            Iterator mDeviceIt = mDeviceList.iterator();
            int mCurrentDevice = 0;
            while (mDeviceIt.hasNext()) {
                Object[] mArray = (Object[])mDeviceIt.next();
                ++mCurrentDevice;
                this.getProductOfSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0], true);
                this.getSAPForSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.handleCluster(mArray);
                this.getSoftwareOfDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.getSpecificDataForDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                mLTH.traceInfo("NameSpace :" + ((StorageDeviceData)mArray[0]).getNameSpace());
                mLTH.traceInfo(((StorageDeviceData)mArray[0]).getDebugString());
                this.saveAllInformation(mLTH, mDeviceList, mReturn, mScannID, mCurrentDevice, mArray);
            }
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    private void saveAllInformation(LogTraceHelper mLTH, List mDeviceList, List mReturn, String mScannID, int mCurrentDevice, Object[] mArray) throws SQLException {
        Hashtable mSlpKeyReferences = this.saveNameSpace(mLTH, this.getMapperRouter(), mScannID, ((StorageDeviceData)mArray[0]).getNameSpace(), ((StorageDeviceData)mArray[0]).getCIMOMVersion());
        Hashtable mReturnValues = this.saveSubSystem(mArray, mLTH, this.getMapperRouter(), mScannID, mSlpKeyReferences);
        if (mReturnValues.size() > 0) {
            mReturnValues.putAll(mSlpKeyReferences);
            this.saveProduct(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
            this.saveNodes(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
            this.saveSoftware(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
            this.saveSpecificData((StorageDeviceData)mArray[0], mLTH, this.getMapperRouter(), ((StorageDeviceData)mArray[0]).getSMISVersion(), mScannID, mReturnValues);
            this.saveCapabilities(mArray, this.getMapperRouter(), mScannID, mReturnValues);
            this.cDiskCimProcessor.doCommit(mLTH);
            if (((StorageDeviceData)mArray[0]).getProfile().indexOf("Switch") >= 0) {
                CIMOMSelector.getSelector().activateCimomForSwitch(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), (String)mReturnValues.get("ref_switch_wwn"));
            } else if (((StorageDeviceData)mArray[0]).getProfile().indexOf("Storage Library") >= 0) {
                CIMOMSelector.getSelector().activateCimomForTapeLibrary(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_id")));
            } else {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)"unsupported profile found", (LogTraceHelper)mLTH);
            }
            mReturn.add((StorageDeviceData)mArray[0]);
        } else {
            mLTH.traceInfo("No additional info returned for SaveSubsystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCluster(Object[] mArray) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"handleCluste", (Object[])new Object[]{mArray});
        try {
            if (this.supportsSubProfile(((StorageDeviceData)mArray[0]).getSubProfile(), "Cluster")) {
                List mNodeList = this.getNodesOfCluster((CIMInstance)mArray[1]);
                Iterator mNodesIt = mNodeList.iterator();
                int mNodeCounter = 0;
                while (mNodesIt.hasNext()) {
                    CIMInstance mNodeInstance = (CIMInstance)mNodesIt.next();
                    this.getProductOfSystem(mNodeInstance, (StorageDeviceData)mArray[0], false);
                    this.getSAPForSystem(mNodeInstance, (StorageDeviceData)mArray[0]);
                    this.getSoftwareOfDevice(mNodeInstance, (StorageDeviceData)mArray[0]);
                    this.getSpecificDataForNode(mNodeInstance, (StorageDeviceData)mArray[0]);
                    ((StorageDeviceData)mArray[0]).setDataFromInstance("node_" + ++mNodeCounter, mNodeInstance, mLTH);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }
}

