/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskDriveIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskDriveDeletionHandler
extends DiskDriveIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_DiskDrive", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public DiskDriveDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        String mCimomId = this.getEvent().getCIMOM().getServiceId();
        String mNamespace = this.getEvent().getCIMNameSpace();
        CIMObjectPath mDiskCop = this.getEvent().getSourceCop();
        String mDeviceId = (String)mDiskCop.getKey("DeviceID").getValue().getValue();
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                String mPhysicalVolumeID = this.getPhysicalVolumeID(mConnection, mDiskCop);
                try {
                    DiskDriveIndicationHandler.changeDetectableAttributeForDiskDrive(mConnection, "0", new Integer(mPhysicalVolumeID));
                    mConnection.commit();
                    Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, PhysicalVolume.getTablename(), mPhysicalVolumeID, 1, 0);
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    pLTH.traceError("Database update failed, calling rollback()", (Throwable)e);
                    mConnection.rollback();
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException pE) {
            throw new RuntimeException(pE);
        }
        return HandlingResult.SUCCESS;
    }
}

