/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;

public class DiskMonitorHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getManagedSubsystems(DBConnection pConnection, String pCimomId, String pNamespace) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResCimom2namespaceTable.getColumnInfo((String)"CIMOM_ID"), pCimomId);
        mParameters.put(TResCimom2namespaceTable.getColumnInfo((String)"NAMESPACE"), pNamespace);
        String mQueryString = "SELECT SUBSYSTEM_ID FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE " + "CIM_NAMESPACE_ID" + " = (SELECT " + "CIM_NAMESPACE_ID" + " FROM " + TResCimom2namespaceTable.getTablename() + " WHERE " + "CIMOM_ID" + " = (?) AND " + "NAMESPACE" + " = (?))";
        DBResultSet mDbResult = ComplexQuery.sqlQuery((DBConnection)pConnection, (String)mQueryString, mParameters);
        try {
            ArrayList<Integer> mResult = new ArrayList<Integer>();
            while (mDbResult.next()) {
                mResult.add(new Integer(mDbResult.getInt(1)));
            }
            int[] mReturn = new int[mResult.size()];
            for (int i = 0; i < mReturn.length; ++i) {
                mReturn[i] = (Integer)mResult.get(i);
            }
            int[] nArray = mReturn;
            return nArray;
        }
        finally {
            if (mDbResult != null) {
                mDbResult.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVolumeId(DBConnection pConnection, CIMIndicationEvent pEvent, CIMObjectPath pVolumeCop) throws SQLException {
        String mCreationClassName = (String)pVolumeCop.getKey("CreationClassName").getValue().getValue();
        String mSystemCreationClassName = (String)pVolumeCop.getKey("SystemCreationClassName").getValue().getValue();
        String mSystemName = (String)pVolumeCop.getKey("SystemName").getValue().getValue();
        String mDeviceID = (String)pVolumeCop.getKey("DeviceID").getValue().getValue();
        Cimom2namespace mCimom2Namespace = new Cimom2namespace();
        mCimom2Namespace.setCimomId(Integer.parseInt(pEvent.getCIMOM().getServiceId()));
        String bTempNS = DiskMonitorHelper.removeLeadingSlash(pEvent.getCIMNameSpace());
        mCimom2Namespace.setNamespace(bTempNS);
        mCimom2Namespace.retrieve(pConnection);
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResCimkeyVolumeTable.getColumnInfo((String)"CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID((DBConnection)pConnection, (String)mCreationClassName)));
        mParameters.put(TResCimkeyVolumeTable.getColumnInfo((String)"SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID((DBConnection)pConnection, (String)mSystemCreationClassName)));
        mParameters.put(TResCimkeyVolumeTable.getColumnInfo((String)"SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID((DBConnection)pConnection, (String)mSystemName)));
        mParameters.put(TResCimkeyVolumeTable.getColumnInfo((String)"DEVICE_ID"), mDeviceID);
        mParameters.put(TResCimkeyVolumeTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), String.valueOf(mCimom2Namespace.getCimNamespaceId()));
        String mQueryString = "SELECT VOLUME_ID FROM " + TResCimkeyVolumeTable.getTablename() + " WHERE " + "CIM_NAMESPACE_ID" + " = (?) AND " + "CREATION_CLASS_NAME_ID" + " = (?) AND " + "DEVICE_ID" + " = (?) AND " + "SYSTEM_CREATION_CLASS_NAME_ID" + " = (?) AND " + "SYSTEM_NAMES_ID" + " = (?) FOR READ ONLY";
        System.out.println(pConnection.isClosed());
        DBResultSet mDbResult = ComplexQuery.sqlQuery((DBConnection)pConnection, (String)mQueryString, mParameters);
        try {
            if (!mDbResult.next()) {
                throw new NotFoundException("Volume " + pVolumeCop.toString() + " not in db.");
            }
            int mResult = mDbResult.getInt(1);
            if (mDbResult.next()) {
                throw new DbConstraintException("Multiple matches on single row query.");
            }
            int n = mResult;
            return n;
        }
        finally {
            if (mDbResult != null) {
                mDbResult.closeAll();
            }
        }
    }

    public static String removeLeadingSlash(String pString) {
        String bResult = pString;
        try {
            int bI = pString.indexOf(47);
            if (bI == 0) {
                bResult = pString.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bResult;
    }

    public static void deleteVolumes(DBConnection pConnection, int[] pAffectedVolumes) throws SQLException {
        for (int i = 0; i < pAffectedVolumes.length; ++i) {
            DiskMonitorHelper.deleteVolume(pConnection, pAffectedVolumes[i]);
        }
    }

    public static void deleteVolume(DBConnection pConnection, int pAffectedVolume) throws SQLException {
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.put(CimkeyVolume.getColumnInfo((String)"VOLUME_ID"), String.valueOf(pAffectedVolume));
        CimkeyVolume.deletes((DBConnection)pConnection, htWhere);
        htWhere.clear();
        htWhere.put(StorageVolume.getColumnInfo((String)"SVID"), String.valueOf(pAffectedVolume));
        StorageVolume.deletes((DBConnection)pConnection, htWhere);
        htWhere.clear();
        htWhere.put(Volume2extent.getColumnInfo((String)"VOLUME_ID"), String.valueOf(pAffectedVolume));
        Volume2extent.deletes((DBConnection)pConnection, htWhere);
        htWhere.clear();
        htWhere.put(DataPath.getColumnInfo((String)"VOLUME_ID"), String.valueOf(pAffectedVolume));
        DataPath.deletes((DBConnection)pConnection, htWhere);
    }

    public static void detachExtents(DBConnection pConn, String pIDtype, Integer pIDvalue) throws SQLException {
        Hashtable<ColumnInfo, Integer> mParams = new Hashtable<ColumnInfo, Integer>();
        mParams.put(TResStorageExtentTable.getColumnInfo((String)pIDtype), pIDvalue);
        String mSQL = "UPDATE " + TResStorageExtentTable.getTablename() + " SET " + pIDtype + " = CAST(NULL AS INTEGER) WHERE " + pIDtype + " = (?)";
        int mRc = ComplexQuery.sqlUpdate((DBConnection)pConn, (String)mSQL, mParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getKeyMapFromCOP(DBConnection pConn, CIMObjectPath pCOP) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"DiskMonitorHelper", (String)"getKeyMapFromCOP", (Object[])new Object[]{pConn, pCOP});
        HashMap<String, String> mResult = null;
        try {
            mResult = new HashMap<String, String>();
            Vector mKVP = pCOP.getKeys();
            for (int bI = 0; bI < mKVP.size(); ++bI) {
                CIMProperty bProp = (CIMProperty)mKVP.get(bI);
                if (bProp.getName().equalsIgnoreCase("SystemCreationClassName")) {
                    String bSCCN = (String)bProp.getValue().getValue();
                    mResult.put("SystemCreationClassName", Short.toString(Normalizer.SystemCreationClassNameGetID((DBConnection)pConn, (String)bSCCN)));
                }
                if (bProp.getName().equalsIgnoreCase("CreationClassName")) {
                    String bCCN = (String)bProp.getValue().getValue();
                    mResult.put("CreationClassName", Short.toString(Normalizer.CreationClassNameGetID((DBConnection)pConn, (String)bCCN)));
                }
                if (bProp.getName().equalsIgnoreCase("SystemName")) {
                    String bSN = (String)bProp.getValue().getValue();
                    mResult.put("SystemName", Short.toString(Normalizer.SystemNamesGetID((DBConnection)pConn, (String)bSN)));
                }
                if (!bProp.getName().equalsIgnoreCase("DeviceID")) continue;
                mResult.put("DeviceID", (String)bProp.getValue().getValue());
            }
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public static void addEntriesToInternalList(Map pTarget, Map pSource) {
        for (Map.Entry mSourceEntry : pSource.entrySet()) {
            LinkedList mTargetValue = (LinkedList)pTarget.get(mSourceEntry.getKey());
            if (mTargetValue == null) {
                mTargetValue = new LinkedList();
                pTarget.put(mSourceEntry.getKey(), mTargetValue);
            }
            mTargetValue.add(mSourceEntry.getValue());
        }
    }

    public static class DbConstraintException
    extends RuntimeException {
        private static final long serialVersionUID = -8730467849991399192L;

        public DbConstraintException(String pMessage) {
            super(pMessage);
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 2430267413862151992L;

        public NotFoundException(String pMessage) {
            super(pMessage);
        }
    }
}

