/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.PoolIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;

public class PoolDeletionHandler
extends PoolIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StoragePool", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public PoolDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        block14: {
            CIMObjectPath mPoolCop = this.getEvent().getSourceCop();
            CIMValue bVal = mPoolCop.getKey("InstanceID").getValue();
            String mInstanceId = (String)bVal.getValue();
            String mCimomId = this.getEvent().getCIMOM().getServiceId();
            String mNamespace = this.getEvent().getCIMNameSpace();
            try {
                DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    int[] mSubsystemIds = DiskMonitorHelper.getManagedSubsystems(mConnection, mCimomId, mNamespace);
                    StoragePool mPool = PoolDeletionHandler.getPool(mConnection, mInstanceId, mSubsystemIds);
                    if (mPool == null) break block14;
                    int[] mAffectedVolumes = PoolDeletionHandler.getAffectedVolumes(mConnection, mPool);
                    boolean bEntityHasDetectableAttribute = false;
                    if (StoragePool.getColumnInfo((String)"DETECTABLE") != null) {
                        bEntityHasDetectableAttribute = true;
                    }
                    try {
                        try {
                            if (bEntityHasDetectableAttribute) {
                                PoolIndicationHandler.changeDetectableAttributeForStoragePool(mConnection, "0", new Integer(mInstanceId));
                            } else {
                                PoolDeletionHandler.detachExtents(mConnection, mPool);
                                DiskMonitorHelper.deleteVolumes(mConnection, mAffectedVolumes);
                                mPool.delete(mConnection);
                            }
                            mConnection.commit();
                        }
                        catch (Exception e) {
                            mConnection.rollback();
                            throw new RuntimeException(e);
                        }
                        ArrayList<String> mVolumeIds = new ArrayList<String>();
                        for (int i = 0; i < mAffectedVolumes.length; ++i) {
                            mVolumeIds.add(Integer.toString(mAffectedVolumes[i]));
                        }
                        HashMap<String, AbstractList> mTouchedEntities = new HashMap<String, AbstractList>();
                        LinkedList<String> mIds = new LinkedList<String>();
                        mIds.add(Integer.toString(mPool.getPoolId()));
                        mTouchedEntities.put(TResStoragePoolTable.getTablename(), mIds);
                        mTouchedEntities.put(TResStorageVolumeTable.getTablename(), mVolumeIds);
                        Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, StoragePool.getTablename(), Integer.toString(mPool.getPoolId()), 1, 0);
                        Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return HandlingResult.SUCCESS;
    }
}

