/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.SubsystemIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.UnsignedInt16;

public class SubsystemCreationHandler
extends SubsystemIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_ComputerSystem", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_StorageSystem", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Cluster", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR4 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_Node", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData mR5 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_Cluster", "CIM_InstCreation");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR2, mR3, mR4, mR5};
    }

    public SubsystemCreationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"handle", null);
        try {
            CIMInstance mToplevelSystem;
            CIMInstance mSubsystem;
            int DEDICATED_Storage = 3;
            int DEDICATED_Switch = 5;
            int DEDICATED_Block_Server = 15;
            int DEDICATED_Storage_Virtualizer = 21;
            int DEDICATED_Media_Library = 22;
            DBConnection mConn = null;
            try {
                mSubsystem = this.getEvent().getSourceInstance();
                mToplevelSystem = this.getTopLevelSystemInstance(mSubsystem);
            }
            catch (CIMException pE) {
                throw new RuntimeException(pE);
            }
            catch (DiskManagerTimeoutException pE) {
                throw new RuntimeException(pE);
            }
            boolean isSwitch = false;
            boolean isTape = false;
            CIMProperty bDediV = mToplevelSystem.getProperty("Dedicated");
            Object bO = bDediV.getValue().getValue();
            if (bO instanceof Vector) {
                Vector bDedications = (Vector)bO;
                for (int bI = 0; bI < bDedications.size(); ++bI) {
                    UnsignedInt16 bUI16 = (UnsignedInt16)bDedications.get(bI);
                    if (bUI16.intValue() == 5) {
                        isSwitch = true;
                        mLTH.traceInfo("Found switch as top level system");
                        break;
                    }
                    if (bUI16.intValue() != 22) continue;
                    isTape = true;
                    mLTH.traceInfo("Found tape as top level system");
                    break;
                }
            }
            MapperRouter mRouter = MapperRouter.getMapperRouter();
            Hashtable mParamsToplevelSystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mToplevelSystem);
            String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
            mParamsToplevelSystem.put("ref_serviceurl", mServiceUrl);
            mParamsToplevelSystem.put("ref_namespace", mToplevelSystem.getObjectPath().getNameSpace());
            Hashtable mParamsSubsystem = null;
            IDBAttributeMapper mSubsystemMapper = null;
            if (!mToplevelSystem.equals((Object)mSubsystem)) {
                mParamsSubsystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mSubsystem);
                mParamsSubsystem.put("ref_serviceurl", mServiceUrl);
                mParamsSubsystem.put("ref_namespace", mSubsystem.getObjectPath().getNameSpace());
                mSubsystemMapper = mRouter.findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_ComputerSystem");
            }
            IDBAttributeMapper mToplevelSystemMapper = mRouter.findMapper(mToplevelSystem.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
            try {
                DBConnPoolDataSource mConnPool = DBConnPoolDataSource.getInstance();
                mConn = (DBConnection)mConnPool.getPooledConnection();
                MapperResult mMapperResult = mToplevelSystemMapper.persist(mConn, mParamsToplevelSystem, pProcessID);
                if (mSubsystemMapper != null && mParamsSubsystem != null) {
                    mParamsSubsystem.putAll(mMapperResult.getKeyReferences());
                    mSubsystemMapper.persist(mConn, mParamsSubsystem, pProcessID);
                }
                mConn.commit();
                AlertProcessor.processAlerts((String)pProcessID, (MapperResult)mMapperResult, new Hashtable(), new Hashtable());
                Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
            }
            catch (SQLException e) {
                try {
                    mConn.rollback();
                }
                catch (SQLException e1) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException(e);
            }
            finally {
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx1) {
                        throw new RuntimeException(pEx1);
                    }
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
        return HandlingResult.SUCCESS;
    }
}

