/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.VolumeIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class VolumeDeletionHandler
extends VolumeIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StorageVolume", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Volume", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR5 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_StorageVolume", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR3, mR5};
    }

    public VolumeDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                int mVolumeId = DiskMonitorHelper.getVolumeId(mConnection, this.getEvent(), this.getEvent().getSourceCop());
                pLTH.traceHigh("Processing instance delete indication for volume id " + Integer.toString(mVolumeId));
                boolean bEntityHasDetectableAttribute = false;
                if (StorageVolume.getColumnInfo((String)"DETECTABLE") != null) {
                    bEntityHasDetectableAttribute = true;
                }
                try {
                    if (bEntityHasDetectableAttribute) {
                        VolumeIndicationHandler.changeDetectableAttributeForStorageVolume(mConnection, "0", new Integer(mVolumeId));
                    } else {
                        DiskMonitorHelper.deleteVolume(mConnection, mVolumeId);
                    }
                    mConnection.commit();
                    LinkedList<String> mVolumeIdStrings = new LinkedList<String>();
                    mVolumeIdStrings.add(Integer.toString(mVolumeId));
                    HashMap<String, LinkedList<String>> mTouchedEntities = new HashMap<String, LinkedList<String>>();
                    mTouchedEntities.put(TResStorageVolumeTable.getTablename(), mVolumeIdStrings);
                    Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, StorageVolume.getTablename(), Integer.toString(mVolumeId), 1, 0);
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                    return HandlingResult.SUCCESS;
                }
                catch (Exception e) {
                    pLTH.traceError("database update failed, perfoming rollback", (Throwable)e);
                    mConnection.rollback();
                    HandlingResult handlingResult = HandlingResult.FAILURE;
                    if (mConnection == null) return handlingResult;
                    mConnection.close();
                    return handlingResult;
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (DiskMonitorHelper.NotFoundException e) {
            pLTH.traceHigh("The volume " + this.getEvent().getSourceCop().toString() + " wasn't present in the database");
            return HandlingResult.SUCCESS;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

