/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public abstract class VolumeIndicationHandler
extends CIMIndicationHandler {
    public static final String GENERIC_CLASS = "CIM_StorageVolume";

    public VolumeIndicationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    protected CIMInstance getTopLevelSystemInstance(CIMInstance pVolume) throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getTopLevelSystemInstance", (Object[])new Object[]{pVolume});
        try {
            Enumeration mComputerSystem = this.getEvent().getCIMClient().associators(pVolume.getObjectPath(), "CIM_SystemDevice", "CIM_System", "PartComponent", "GroupComponent", false, false, null, mLTH);
            if (mComputerSystem.hasMoreElements()) {
                CIMInstance mTLSInstance = (CIMInstance)mComputerSystem.nextElement();
                Enumeration mProfile = this.getEvent().getCIMClient().associatorNames(mTLSInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", mLTH);
                if (mProfile.hasMoreElements()) {
                    CIMInstance cIMInstance = mTLSInstance;
                    return cIMInstance;
                }
                mComputerSystem = this.getEvent().getCIMClient().associators(mTLSInstance.getObjectPath(), "CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent", true, true, null, mLTH);
                if (mComputerSystem.hasMoreElements()) {
                    mTLSInstance = (CIMInstance)mComputerSystem.nextElement();
                    mProfile = this.getEvent().getCIMClient().associatorNames(mTLSInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", mLTH);
                    if (mProfile.hasMoreElements()) {
                        CIMInstance cIMInstance = mTLSInstance;
                        return cIMInstance;
                    }
                }
            }
            throw new RuntimeException("Cannot detect TopLevelComputerSystem");
        }
        finally {
            mLTH.exit(null);
        }
    }

    public static int changeDetectableAttributeForStorageVolume(DBConnection pConn, String pValue, Integer pIDvalue) throws SQLException {
        if (!pValue.equals("0") && !pValue.equals("1")) {
            return 0;
        }
        Hashtable<ColumnInfo, String> mParams = new Hashtable<ColumnInfo, String>();
        mParams.put(TResStorageVolumeTable.getColumnInfo((String)"SVID"), pIDvalue.toString());
        String mSQL = "UPDATE " + TResStorageVolumeTable.getTablename() + " SET " + "DETECTABLE" + " = " + pValue + " WHERE " + "SVID" + " = (?)";
        return ComplexQuery.sqlUpdate((DBConnection)pConn, (String)mSQL, mParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMInstance getPoolInstance(CIMInstance pVolume) throws CIMException, DiskManagerTimeoutException {
        CIMInstance cIMInstance;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getPoolInstance", (Object[])new Object[]{pVolume});
        CIMInstance mPoolInstance = null;
        try {
            Enumeration mStoragePools = this.getEvent().getCIMClient().associators(pVolume.getObjectPath(), "CIM_AllocatedFromStoragePool", "CIM_StoragePool", "Dependent", "Antecedent", false, false, null, mLTH);
            cIMInstance = mPoolInstance = mStoragePools.hasMoreElements() ? (CIMInstance)mStoragePools.nextElement() : null;
        }
        catch (Throwable throwable) {
            mLTH.exit(mPoolInstance);
            throw throwable;
        }
        mLTH.exit((Object)mPoolInstance);
        return cIMInstance;
    }
}

