/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.VolumeIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class VolumeModificationHandler
extends VolumeIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StorageVolume", "CIM_InstModification");
        CIMIndicationHandler.RegistrationData mR2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Volume", "CIM_InstModification");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_StorageVolume", "CIM_InstModification");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR2, mR3};
    }

    public VolumeModificationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        CIMInstance mStorageSystemInstance;
        CIMInstance mVolumeInstance;
        try {
            mVolumeInstance = this.getEvent().getSourceInstance();
            mStorageSystemInstance = this.getTopLevelSystemInstance(mVolumeInstance);
        }
        catch (CIMException e) {
            throw new RuntimeException(e);
        }
        catch (DiskManagerTimeoutException e) {
            throw new RuntimeException(e);
        }
        MapperRouter mMapperRouter = MapperRouter.getMapperRouter();
        Hashtable mParamsStorageSystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mStorageSystemInstance);
        String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
        mParamsStorageSystem.put("ref_serviceurl", mServiceUrl);
        mParamsStorageSystem.put("ref_namespace", mStorageSystemInstance.getObjectPath().getNameSpace());
        Hashtable mParamsVolume = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mVolumeInstance);
        mParamsVolume.put("ref_serviceurl", mServiceUrl);
        mParamsVolume.put("ref_namespace", mVolumeInstance.getObjectPath().getNameSpace());
        IDBAttributeMapper mMapperStorageSystem = mMapperRouter.findMapper(mStorageSystemInstance.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
        IDBAttributeMapper mMapperVolume = mMapperRouter.findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_StorageVolume");
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            ChangeDetection mChangeDetection = null;
            try {
                mChangeDetection = new ChangeDetection(mConnection);
                try {
                    Hashtable mTouchedEntities = new Hashtable();
                    MapperResult mMapperResult = mMapperStorageSystem.persist(mConnection, mParamsStorageSystem, pProcessID);
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getInsertedRows()));
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getUpdatedRows()));
                    mParamsVolume.putAll(mMapperResult.getKeyReferences());
                    mMapperResult = mMapperVolume.persist(mConnection, mParamsVolume, pProcessID);
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getInsertedRows()));
                    DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mMapperResult.getUpdatedRows()));
                    mConnection.commit();
                    mChangeDetection.complete(mConnection, mTouchedEntities, pProcessID);
                    mConnection.commit();
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    try {
                        pLTH.traceError("Database update failed, calling rollback()", (Throwable)e);
                        mConnection.rollback();
                    }
                    finally {
                        mChangeDetection.cancel();
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return HandlingResult.SUCCESS;
    }
}

