/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.discovery;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.IRestartable;
import org.eclipse.aperi.agent.handler.job.JobState;
import org.eclipse.aperi.agent.nas.AutoMounts;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.nas.RemoteMountInfo;
import org.eclipse.aperi.agent.probe.ExecProbe;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecDiscovery
implements IExecutable,
IRestartable {
    public static final String ARG_NETWARE = "NETWARE";
    public static final String ARG_NETWORK_DISCOVERY = "NETWORK_DISCOVERY";
    public static final int NETAPP_VENDOR_ID = 789;
    public static final int DEFAULT_SCHEDULE_ID = -1;
    private static final int COUNT_UP_TO = 50;
    public int rc;
    private FoundComputer prev;
    private FoundComputer fc;
    private boolean rejectNonRoot;
    private boolean lastWasRoot;

    @Override
    public int exec(StartedJob startedJob, String[] args) {
        JobState jobState;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"main", (String)"");
        }
        this.rc = 0;
        boolean initialDiscovery = startedJob == null;
        boolean netwareOnly = this.arrayContains(args, ARG_NETWARE);
        boolean doNetworkDiscovery = this.arrayContains(args, ARG_NETWORK_DISCOVERY);
        int scheduleID = -1;
        if (startedJob != null) {
            scheduleID = startedJob.getJobRun().getSchedID();
        }
        DiscoveryData structure = new DiscoveryData();
        if (netwareOnly) {
            structure.dfNetwareOnlyDiscovery = true;
            structure.dfNoNetworkDiscovery = true;
        }
        structure.dfComputerID = ComputerID.cachedCID;
        structure.dfDomain = Agent.domain;
        structure.dfRunNumber = scheduleID;
        CheckedRequest request = Agent.makeCheckedRequest();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.subType = "org.eclipse.aperi.server.handler.agent.DiscoveryHndlr";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Agent.localName;
        request.flags = 0;
        request.requestData = structure;
        MessageLog.logMessage((String)"AGT0145I");
        Response response = Agent.reporter.sendRequest((Request)request, (byte)1);
        if (response == null || response.status > 4) {
            MessageLog.logMessage((String)"STA0245E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"main", (int)8);
            }
            return 8;
        }
        MessageLog.logMessage((String)"STA0246I");
        structure = (DiscoveryData)response.responseData;
        structure.unpack();
        structure.dfPackedNasFiler = null;
        boolean bl = this.rejectNonRoot = !structure.dfIncludeNonRoot;
        if (initialDiscovery) {
            boolean bl2 = structure.dfNoNetworkDiscovery = !doNetworkDiscovery;
        }
        if (netwareOnly) {
            structure.dfNoNetworkDiscovery = true;
        }
        new ExecProbe();
        if (Agent.isWindows) {
            this.rc = this.doWindowsDiscovery(structure, initialDiscovery, netwareOnly);
        } else {
            structure.dfNoNetworkDiscovery = false;
            this.rc = this.doUnixDiscovery(structure);
        }
        if (this.rc > 4) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"main", (int)this.rc);
            }
            return this.rc;
        }
        structure.dfComputerID = ComputerID.cachedCID;
        structure.dfDomain = Agent.domain;
        structure.dfNasVendor = null;
        structure.dfPackedLdapTree = null;
        structure.dfLdapTree = null;
        structure.dfDefaultNasLogin = null;
        structure.dfDefaultNasPwd = null;
        structure.dfFirstDiscovery = initialDiscovery;
        structure.pack();
        if (initialDiscovery) {
            jobState = null;
        } else {
            startedJob.setExitCode(this.rc);
            jobState = new JobState(startedJob, structure);
            jobState.saveState();
        }
        if (this.sendResults(structure, initialDiscovery) && jobState != null) {
            jobState.deleteState();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"main", (int)this.rc);
        }
        return this.rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contactFiler(NasFiler nf, int vendorID, String login, String password, boolean loginsExpected) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"contactFiler", (String)"nf, vendorID, login, password");
        }
        Computer computer = nf.nfComputer;
        try {
            NasUtil.cifsLogIn(computer.cmpDomain.domName, nf.nfNetworkName, login, password);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecDiscovery.class.getName(), (String)"contactFiler", (Throwable)e);
            }
            if (loginsExpected) {
                e.print();
                this.rc = 4;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"contactFiler", (boolean)false);
            }
            return false;
        }
        try {
            if (!Probe.enumExports(computer, nf.nfNetworkName)) {
                this.rc = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"contactFiler", (boolean)false);
                }
                boolean e = false;
                return e;
            }
            RemoteMountInfo queryObj = new RemoteMountInfo();
            Map map = null;
            PathConverter converter = this.makePathConverter(vendorID);
            Export xp = computer.cmpExport;
            while (xp != null) {
                block21: {
                    try {
                        queryObj.getInfo(nf.nfNetworkName, xp.xpExportName);
                    }
                    catch (LocalizableException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ExecDiscovery.class.getName(), (String)"contactFiler", (Throwable)e);
                        }
                        e.print();
                        this.rc = 4;
                        break block21;
                    }
                    if (this.rejectNonRoot) {
                        this.hashByVolID(new HashMap<MutableInteger, String>(), converter, queryObj, nf, xp);
                    } else {
                        this.hashByName(new HashMap<String, String>(), converter, queryObj, nf, xp);
                    }
                }
                xp = xp.xpNext;
            }
            if (this.rejectNonRoot) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!Util.isEmpty((String)((String)entry.getValue()))) continue;
                    MutableInteger key = (MutableInteger)entry.getKey();
                    String volser = ExecDiscovery.makeVolSerString(key.value);
                    MessageLog.logMessage((String)"NAA0067W", (Object)nf.nfName, (Object)volser);
                    this.rc = 4;
                }
            }
        }
        finally {
            NasUtil.cifsLogOut(nf.nfNetworkName);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"contactFiler", (boolean)true);
        }
        return true;
    }

    @Override
    public int restart(JobState jobState) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"restart", (String)"jobState");
        }
        this.rc = jobState.job.getExitCode();
        DiscoveryData results = (DiscoveryData)jobState.state;
        this.sendResults(results, jobState == null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"restart", (int)this.rc);
        }
        return this.rc;
    }

    public void setRejectNonRoot(boolean in) {
        this.rejectNonRoot = in;
    }

    public static NasFiler newSANFSFileset(String sanfsClusterName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"newSANFSFileset", (String)"sanfsClusterName");
        }
        NasFiler nf = new NasFiler();
        nf.nfName = sanfsClusterName;
        nf.nfNetworkName = " ";
        nf.nfIPAddress = "";
        nf.nfManufacturer = "IBM";
        nf.nfSnmpCommunity = null;
        Computer computer = new Computer(true);
        computer.cmpManufacturer = nf.nfManufacturer;
        computer.cmpDomain = null;
        nf.nfOSType = computer.cmpOSType = (short)23;
        nf.nfComputer = computer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"newSANFSFileset", (Object)nf);
        }
        return nf;
    }

    public static NasFiler newFiler(SnmpPeer peer, String networkName, Contactor contactor, Domain domain) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"newFiler", (String)"peer, networkName, contactor, domain");
        }
        NasFiler nf = new NasFiler();
        nf.nfName = peer.name.toLowerCase();
        nf.nfNetworkName = networkName;
        nf.nfIPAddress = peer.address.getHostAddress();
        if (contactor.vendor != null) {
            nf.nfManufacturer = contactor.vendor.nlName;
        } else if (contactor.vendorID > 0) {
            nf.nfManufacturer = "unknown";
        }
        nf.nfVendorID = contactor.vendorID;
        NameList used = contactor.communities;
        if (used.nlID == -1) {
            nf.nfSnmpCommunity = null;
        } else {
            NameList community = (NameList)used.clone();
            community.nlNext = null;
            nf.nfSnmpCommunity = community;
        }
        Computer computer = new Computer(true);
        computer.cmpManufacturer = nf.nfManufacturer;
        computer.cmpDomain = domain;
        computer.cmpOSType = nf.nfVendorID == 789 ? (short)10 : (short)9;
        nf.nfOSType = computer.cmpOSType;
        nf.nfComputer = computer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"newFiler", (Object)nf);
        }
        return nf;
    }

    private boolean loginsExpected(boolean initialDiscovery) {
        return !initialDiscovery;
    }

    private boolean sendResults(DiscoveryData results, boolean initialDiscovery) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"sendResults", (String)"results, jobState");
        }
        MessageLog.logMessage((String)"STA0249I");
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Agent.localName;
        request.subType = "org.eclipse.aperi.server.handler.agent.DiscoveryHndlr";
        request.requestData = results;
        request.flags = (byte)(request.flags | 2);
        Response response = Agent.reporter.sendRequest(request, (byte)2);
        if (response != null && response.status <= 4) {
            MessageLog.logMessage((String)"STA0250I");
            if (response.status > this.rc) {
                this.rc = response.status;
            }
            if (this.rc == 0) {
                MessageLog.logMessage((String)"STA0252I");
            } else {
                MessageLog.logMessage((String)"STA0253I");
            }
        } else {
            MessageLog.logMessage((String)"STA0251E");
            if (!(initialDiscovery || response != null && response.status != 8 && response.status != 24)) {
                MessageLog.logMessage((String)"STA0255I");
                this.rc = -4096;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"sendResults");
                }
                return false;
            }
            this.rc = response.status;
            MessageLog.logMessage((String)"STA0254I");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"sendResults");
        }
        return true;
    }

    private PathConverter makePathConverter(int vendorID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"makePathConverter", (String)"vendorID");
        }
        PathConverter result = null;
        switch (vendorID) {
            case 789: {
                result = new NetAppPathConverter();
                break;
            }
            default: {
                result = new PathConverter();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"makePathConverter", (Object)result);
        }
        return result;
    }

    private static void make4HexDigits(int value, char[] array, int pos) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"make4HexDigits", (String)"value, array, pos");
        }
        for (int i = 0; i < 4; ++i) {
            int x = value & 0xF;
            if (x < 10) {
                x += 48;
            } else {
                x -= 10;
                x += 65;
            }
            array[pos] = (char)x;
            --pos;
            value >>= 4;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"make4HexDigits");
        }
    }

    private static String makeVolSerString(int value) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"makeVolSerString", (String)"value");
        }
        char[] array = new char[9];
        ExecDiscovery.make4HexDigits(value >> 16, array, 3);
        array[4] = 45;
        ExecDiscovery.make4HexDigits(value, array, 8);
        String traceResult = new String(array);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"makeVolSerString", (Object)traceResult);
        }
        return traceResult;
    }

    private void addFilesystem(NasFiler filer, Export xp, RemoteMountInfo queryObj, String path) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"addFilesystem", (String)"filer, xp, queryObj, path");
        }
        Computer computer = filer.nfComputer;
        Filesystem fs = new Filesystem();
        fs.fsNasFiler = filer;
        fs.fsMaxFiles = -1;
        fs.fsUsedInodes = -1;
        fs.fsFreeInodes = -1;
        fs.fsPhysicalSize = -1L;
        fs.fsCapacity = queryObj.rmCapacity;
        fs.fsFreeSpace = queryObj.rmFreeSpace;
        computer.cmpFilesystemFreeSpace += fs.fsFreeSpace;
        fs.fsUsedSpace = fs.fsCapacity - fs.fsFreeSpace;
        fs.fsType = this.lastWasRoot ? queryObj.rmFSType : (short)16;
        fs.fsMountPoint = path;
        fs.fsExportName = xp.xpExportName;
        LogicalDisk ld = new LogicalDisk();
        ld.ldCapacity = fs.fsCapacity;
        ld.ldPath = fs.fsMountPoint;
        ld.ldFilesystem = fs;
        fs.fsLogicalDisk = ld;
        ld.ldType = (byte)7;
        ld.ldNext = computer.cmpLogicalDisk;
        computer.cmpLogicalDisk = ld;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"addFilesystem");
        }
    }

    private void hashByVolID(Map<MutableInteger, String> map, PathConverter converter, RemoteMountInfo queryObj, NasFiler nf, Export xp) {
        MutableInteger key;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"hashByVolID", (String)"map, converter, queryObj, nf, xp");
        }
        if (Util.isEmpty((String)map.get(key = new MutableInteger(queryObj.rmVolID)))) {
            String path = converter.convert(xp);
            if (path == null) {
                map.put(key, "");
            } else {
                this.addFilesystem(nf, xp, queryObj, path);
                map.put(key, path);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"hashByVolID");
        }
    }

    private void hashByName(Map<String, String> map, PathConverter converter, RemoteMountInfo queryObj, NasFiler nf, Export xp) {
        String path;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"hashByName", (String)"map, converter, queryObj, nf, xp");
        }
        if ((path = converter.convert(xp)) != null && map.get(path) == null) {
            this.addFilesystem(nf, xp, queryObj, path);
            map.put(path, path);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"hashByName");
        }
    }

    private void advance(boolean setPrev) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"advance", (String)"setPrev");
        }
        if (setPrev) {
            this.prev = this.fc;
        }
        this.fc = this.fc.fcNext;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"advance");
        }
    }

    /*
     * Exception decompiling
     */
    private int doWindowsDiscovery(DiscoveryData structure, boolean initialDiscovery, boolean netwareOnly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MutableInteger doWindowsSanfsDiscovery(DiscoveryData structure) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"doWindowsSanfsDiscovery", (String)"structure");
        }
        MutableInteger saveRC = new MutableInteger();
        saveRC.value = 0;
        structure.dfNasFiler = null;
        Mounts mounts = new Mounts();
        HashMap map = new HashMap();
        mounts.openMnttab();
        while (mounts.findSanFSMount()) {
            if (!mounts.type.equalsIgnoreCase("SANFS")) continue;
            String imprt = mounts.mountPoint;
            FoundComputer oldName = (FoundComputer)map.get(imprt);
            if (oldName != null) {
                MessageLog.logMessage((String)"NAA0117I", (Object)imprt, (Object)oldName.fcName);
                continue;
            }
            MessageLog.logMessage((String)"NAA0118I", (Object)imprt);
            NasFiler nf = ExecDiscovery.newSANFSFileset(imprt);
            Filesystem fs = new Filesystem();
            fs.fsNasFiler = nf;
            if (mounts.statFS(fs) != 0) {
                MessageLog.logMessage((String)"NAA0119I", (Object)imprt);
                saveRC.value = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doWindowsSanfsDiscovery", (Object)saveRC);
                }
                return saveRC;
            }
            fs.fsType = (short)18;
            Computer cmp = nf.nfComputer;
            cmp.cmpFilesystemFreeSpace += fs.fsFreeSpace;
            StringBuffer mntPoint = new StringBuffer("/");
            mntPoint.append(imprt);
            fs.fsMountPoint = mntPoint.toString();
            LogicalDisk ld = new LogicalDisk();
            ld.ldFilesystem = fs;
            fs.fsLogicalDisk = ld;
            ld.ldCapacity = fs.fsCapacity;
            ld.ldPath = imprt;
            ld.ldType = (byte)7;
            ld.ldNext = cmp.cmpLogicalDisk;
            cmp.cmpLogicalDisk = ld;
            nf.nfNext = structure.dfNasFiler;
            structure.dfNasFiler = nf;
            structure.dfManageable = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doWindowsSanfsDiscovery", (Object)saveRC);
        }
        return saveRC;
    }

    private int handleMounts(ImportManager thing, Mounts mounts) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"handleMounts", (String)"thing, mounts");
        }
        if (!mounts.openMnttab()) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"handleMounts", (int)8);
            }
            return 8;
        }
        while (this.rc <= 4 && mounts.nextMount()) {
            int tRC;
            if (mounts.type != null && mounts.type.startsWith("nfs")) {
                tRC = thing.handleImport(mounts, null);
                if (tRC <= this.rc) continue;
                this.rc = tRC;
                continue;
            }
            if (mounts.type == null || !mounts.type.equals("sanfs") || (tRC = thing.handleSANFSMount(mounts)) <= this.rc) continue;
            this.rc = tRC;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"handleMounts", (int)this.rc);
        }
        return this.rc;
    }

    private int doUnixDiscovery(DiscoveryData structure) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecDiscovery.class.getName(), (String)"doUnixDiscovery", (String)"structure");
        }
        this.rc = 0;
        if (structure.dfNasVendor == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doUnixDiscovery", (int)this.rc);
            }
            return this.rc;
        }
        structure.dfNasFiler = null;
        Computer dummy = new Computer();
        ImportManager thing = new ImportManager(dummy, structure.dfNasVendor, structure.dfCommunity, this.rejectNonRoot);
        Mounts mounts = new Mounts();
        if (this.handleMounts(thing, mounts) > 4) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doUnixDiscovery", (int)8);
            }
            return 8;
        }
        if (Agent.hardwareID.osType == 6) {
            thing.enterAutomountMode();
            mounts = new AutoMounts();
            if (this.handleMounts(thing, mounts) > 4) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doUnixDiscovery", (int)8);
                }
                return 8;
            }
        }
        structure.dfNasFiler = dummy.cmpNasFiler;
        structure.dfManageable = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecDiscovery.class.getName(), (String)"doUnixDiscovery", (int)this.rc);
        }
        return this.rc;
    }

    private boolean arrayContains(String[] args, String test) {
        boolean match = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(test)) continue;
            match = true;
            break;
        }
        return match;
    }

    private class NetAppPathConverter
    extends PathConverter {
        private NetAppPathConverter() {
        }

        public String convert(Export xp) {
            String result;
            int i;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)NetAppPathConverter.class.getName(), (String)"convert", (String)"xp");
            }
            ExecDiscovery.this.lastWasRoot = false;
            String path = xp.xpPath.toLowerCase();
            if (!path.startsWith("c:\\")) {
                MessageLog.logMessage((String)"NAA0066W", (Object)xp.xpExportName, (Object)path);
                ExecDiscovery.this.rc = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)NetAppPathConverter.class.getName(), (String)"convert", null);
                }
                return null;
            }
            int length = path.length();
            if (length == 3) {
                String traceResult = "/vol/vol0";
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)NetAppPathConverter.class.getName(), (String)"convert", (Object)traceResult);
                }
                return traceResult;
            }
            if (length < 8 || !path.startsWith("c:\\vol\\")) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)NetAppPathConverter.class.getName(), (String)"convert", null);
                }
                return null;
            }
            path = xp.xpPath;
            for (i = 7; i < length && path.charAt(i) != '\\'; ++i) {
            }
            if (i >= length - 1) {
                ExecDiscovery.this.lastWasRoot = true;
            }
            if (ExecDiscovery.this.rejectNonRoot && !ExecDiscovery.this.lastWasRoot) {
                result = null;
            } else {
                if (!ExecDiscovery.this.lastWasRoot && path.charAt((i = path.length()) - 1) == '\\') {
                    --i;
                }
                result = path.substring(2, i).replace('\\', '/');
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NetAppPathConverter.class.getName(), (String)"convert", (Object)result);
            }
            return result;
        }
    }

    private class PathConverter {
        private PathConverter() {
        }

        public String convert(Export xp) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)PathConverter.class.getName(), (String)"convert", (String)"xp");
            }
            ExecDiscovery.this.lastWasRoot = false;
            String share = xp.xpExportName;
            boolean useIt = !ExecDiscovery.this.rejectNonRoot ? true : share.length() == 2 && Character.isLetter(share.charAt(0)) && share.charAt(1) == '$' && xp.xpAdministrative;
            String result = useIt ? xp.xpPath.replace('\\', '/') : null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PathConverter.class.getName(), (String)"convert", (Object)result);
            }
            return result;
        }
    }
}

