/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;

public class LANManagerDiscovery {
    private static String domain;

    private static native void initIDs();

    private static native FoundComputer queryLANManager(String var0, boolean var1) throws LocalizableException;

    private static native String[] queryWorkstation(String var0) throws LocalizableException;

    public static FoundComputer findComputers(String pDomain, boolean excludeWorkstations) throws LocalizableException {
        FoundComputer result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (String)"pDomain, excludeWorkstations");
        }
        FoundComputer comp = result = LANManagerDiscovery.queryLANManager(pDomain, excludeWorkstations);
        while (comp != null) {
            InetAddress addr;
            block7: {
                comp.fcDiscoveryMethod = 0;
                addr = null;
                try {
                    addr = InetAddress.getByName(comp.fcName);
                }
                catch (UnknownHostException e) {
                    if (!TraceLogger.enableTrace) break block7;
                    TraceLogger.exception((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (Throwable)e);
                }
            }
            if (addr == null) {
                comp.fcIPAddress = " ";
            } else {
                comp.fcIPAddress = addr.getHostAddress();
                comp.fcAddress = addr;
            }
            comp.fcName = comp.fcName.toLowerCase();
            comp = comp.fcNext;
        }
        FoundComputer traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (Object)traceResult);
        }
        return traceResult;
    }

    public static FoundComputer findComputers(String pDomain) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (String)"pDomain");
        }
        FoundComputer traceResult = LANManagerDiscovery.findComputers(pDomain, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (Object)traceResult);
        }
        return traceResult;
    }

    public static FoundComputer findComputers() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (String)"");
        }
        FoundComputer traceResult = LANManagerDiscovery.findComputers(null, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)LANManagerDiscovery.class.getName(), (String)"findComputers", (Object)traceResult);
        }
        return traceResult;
    }

    public static String[] manualQuery(String serverName) throws LocalizableException {
        String[] result = null;
        result = LANManagerDiscovery.queryWorkstation(serverName);
        return result;
    }

    static {
        LANManagerDiscovery.initIDs();
    }
}

