/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.config;

import java.net.Socket;
import java.util.Arrays;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.HostAndPort;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReadConfigHandler
implements IAgentRequestHandler {
    private boolean active = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response, Socket connection) {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReadConfigHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (!RequestChecker.isDesiredType(AgentRequestData.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReadConfigHandler.class.getName(), (String)"handle");
            }
            return;
        }
        if (!AuthChecker.check(request, response, connection)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReadConfigHandler.class.getName(), (String)"handle");
            }
            return;
        }
        ReadConfigHandler readConfigHandler = this;
        synchronized (readConfigHandler) {
            if (this.active) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ReadConfigHandler.class.getName(), (String)"handle");
                }
                return;
            }
            this.active = true;
        }
        MessageLog.logMessage((String)"AGT0111I");
        String[][] localArray = new String[16][];
        for (i = 0; i < localArray.length; ++i) {
            localArray[i] = new String[2];
            localArray[i][0] = Agent.configParams[i][0];
            localArray[i][1] = Agent.configParams[i][1];
        }
        localArray[8][1] = null;
        localArray[12][1] = null;
        localArray[6][1] = null;
        localArray[13][1] = null;
        localArray[14][1] = null;
        try {
            Agent.parser.readValues(localArray);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ReadConfigHandler.class.getName(), (String)"handle", (Throwable)e);
            }
            response.status = (short)12;
            response.errorMessage = MessageLog.getMessage((String)"AGT0050E", null);
            this.active = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReadConfigHandler.class.getName(), (String)"handle");
            }
            return;
        }
        boolean warning = false;
        String[][] stringArray = Agent.configParams;
        synchronized (Agent.configParams) {
            int j;
            boolean reregister = false;
            boolean eitherChanged = false;
            HostAndPort oldServer = Agent.reporter.getServer();
            HostAndPort server = new HostAndPort();
            server.host = oldServer.host;
            server.port = oldServer.port;
            String[] keyValue = localArray[1];
            if (!server.host.equals(keyValue[1])) {
                eitherChanged = true;
            }
            if ((i = Agent.resolvePort(keyValue = localArray[2])) <= 0) {
                warning = true;
            }
            if (i != server.port) {
                eitherChanged = true;
            }
            if (eitherChanged) {
                warning = true;
                MessageLog.logMessage((String)"AGT0105W");
            }
            keyValue = localArray[3];
            CurtailedWriter log = (CurtailedWriter)MessageLog.getDefaultLog();
            eitherChanged = false;
            i = log.maxMessages;
            int messagesPerLog = Agent.intCfgValue(keyValue, i);
            if (messagesPerLog != i) {
                eitherChanged = true;
                Agent.configParams[3][1] = keyValue[1];
            }
            if ((j = Agent.intCfgValue(keyValue = localArray[10], i = log.maxFiles)) != i) {
                eitherChanged = true;
                Agent.configParams[10][1] = keyValue[1];
            }
            if (eitherChanged) {
                log.setParms(j, messagesPerLog);
            }
            if ((j = Agent.intCfgValue(keyValue = localArray[4], Agent.maxBacklog)) != Agent.maxBacklog) {
                Agent.maxBacklog = j;
                Agent.configParams[4][1] = keyValue[1];
            }
            if ((j = Agent.intCfgValue(keyValue = localArray[5], i = Agent.reporter.getNapLength())) != i) {
                Agent.reporter.setNapLength(j);
                Agent.configParams[5][1] = keyValue[1];
            }
            i = Agent.patienceWithServer;
            j = Agent.getPatience(localArray);
            if (j != i) {
                Agent.patienceWithServer = j;
                Agent.configParams[6][1] = localArray[6][1];
            }
            if ((j = Agent.intCfgValue(keyValue = localArray[7], i = Agent.breadLine.getMaxIdleThreads())) != i) {
                Agent.breadLine.setMaxIdleThreads(j);
                Agent.configParams[7][1] = keyValue[1];
            }
            if ((keyValue = localArray[8])[1] == null) {
                if (Agent.configParams[8][1] != null) {
                    reregister = true;
                    Agent.localName = Agent.realLocalName;
                    Agent.configParams[8][1] = null;
                }
            } else if (!keyValue[1].equals(Agent.localName)) {
                reregister = true;
                Agent.localName = keyValue[1];
                Agent.configParams[8][1] = keyValue[1];
            }
            keyValue = localArray[9];
            Agent.honorSentScripts = Agent.booleanCfgParm(keyValue[1]);
            Agent.configParams[9][1] = keyValue[1];
            keyValue = localArray[11];
            i = Agent.upTimePoll;
            j = Agent.intCfgValue(keyValue, i);
            if (j != i) {
                Agent.upTimePoll = j;
                if (Agent.upTimePoller != null) {
                    Agent.upTimePoller.timeoutChanged();
                }
                Agent.configParams[11][1] = keyValue[1];
            }
            if (!Util.stringsEqual((String)(keyValue = localArray[13])[1], (String)Agent.networkName)) {
                reregister = true;
                Agent.networkName = keyValue[1];
                Agent.configParams[13][1] = keyValue[1];
            }
            Agent.makeFakeHardwareID(localArray[14][1]);
            byte[] compareTo = Agent.fakeHardwareID;
            if (compareTo == null) {
                compareTo = Agent.trueHardwareID;
            }
            if (!Arrays.equals(Agent.hardwareID.hardwareID, compareTo)) {
                Agent.hardwareID.hardwareID = compareTo;
                reregister = true;
            }
            if (reregister) {
                Agent.reporter.queueRegistration();
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            this.active = false;
            if (warning) {
                response.status = (short)4;
                response.errorMessage = MessageLog.getMessage((String)"AGT0051W", null);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReadConfigHandler.class.getName(), (String)"handle");
            }
            return;
        }
    }
}

