/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.log;

import java.io.File;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.backend.JobLogFileReader;
import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class JobLogFileHandler
implements IAgentRequestHandler {
    private LogFileReader logReader = new JobLogFileReader();

    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobLogFileHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (request.requestData instanceof ReadLogRequest) {
            ReadLogRequest rd = (ReadLogRequest)request.requestData;
            String name = rd.name;
            boolean unqualified = Agent.isWindows ? this.unqualifiedWindows(name) : this.unqualifiedUnix(name);
            if (unqualified) {
                rd.name = Agent.logFileDirectory + File.separatorChar + name;
            }
        }
        this.logReader.handle(request, response);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobLogFileHandler.class.getName(), (String)"handle");
        }
    }

    private boolean unqualifiedWindows(String name) {
        if (name.length() < 3) {
            return true;
        }
        if (name.charAt(1) != ':' || name.charAt(2) != '\\') {
            return true;
        }
        char driveLetter = Character.toUpperCase(name.charAt(0));
        return driveLetter < 'A' || driveLetter > 'Z';
    }

    private boolean unqualifiedUnix(String name) {
        return name.length() <= 0 || name.charAt(0) != '/';
    }
}

