/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.nas;

import java.net.Socket;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.nas.netware.NetWareUtil;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LoginAdminHandler
implements IAgentRequestHandler {
    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)LoginAdminHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (!RequestChecker.isDesiredType(LdapTree.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)LoginAdminHandler.class.getName(), (String)"handle");
            }
            return;
        }
        LdapTree tree = (LdapTree)request.requestData;
        if (!NetWareLoader.loadNetWare(true)) {
            response.errorMessage = MessageLog.getMessage((String)"NAA0052E");
        } else if (NetWareUtil.verifyLogin(tree)) {
            response.status = 0;
        } else {
            response.errorMessage = MessageLog.getMessage((String)"NAA0062E", (Object)tree.getLtName(), (Object)tree.ltLdapUser);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)LoginAdminHandler.class.getName(), (String)"handle");
        }
    }
}

