/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.nas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.aperi.Nas.common.DiscoveryData;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.discovery.LANManagerDiscovery;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.nas.AutoMounts;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.nas.netware.NetWareDiscovery;
import org.eclipse.aperi.agent.probe.ExecProbe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ManNasConfigHandler
implements IAgentRequestHandler {
    private ManNasReq reqData;
    private Request request;
    private Response response;
    private File tempFile;
    private PrintWriter oldThreadLog;
    private PrintWriter myPrintWriter;

    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"handle", (String)"request, response, connection");
        }
        if (!RequestChecker.isDesiredType(ManNasReq.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"handle");
            }
            return;
        }
        this.request = request;
        this.response = response;
        this.response.status = (short)12;
        this.reqData = (ManNasReq)request.requestData;
        this.reqData.unpack();
        this.oldThreadLog = MessageLog.getThreadLog();
        this.tempFile = null;
        try {
            this.tempFile = File.createTempFile("mannas", null);
            this.myPrintWriter = new PrintWriter(new FileWriter(this.tempFile));
        }
        catch (IOException e) {
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"ManNasConfigHandler", (String)"handle", (Throwable)e);
            }
            return;
        }
        if (this.reqData.mnAddNas) {
            if (Agent.isWindows) {
                this.addWindowsNasServer();
            } else {
                this.addUnixNasServer();
            }
            if (response.status < 12 && this.reqData.mnFiler != null) {
                this.getNasVendor();
            }
        } else {
            this.addNetwareServer();
        }
        this.delTempFile();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWindowsNasServer() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"addNasServer", (String)"");
        }
        boolean bLoggedIn = false;
        Contactor contactor = this.contactFiler();
        if (contactor == null) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
            return;
        }
        try {
            NasUtil.cifsLogIn(Agent.domain, this.reqData.mnNetworkName, this.reqData.mnUserid, this.reqData.mnPassword);
            bLoggedIn = true;
        }
        catch (LocalizableException e) {
            this.response.errorMessage = e.getMessage();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"ManNasConfigHandler", (String)"addNasServer", (Throwable)e);
            }
            return;
        }
        if (!bLoggedIn) {
            this.response.errorMessage = MessageLog.getMessage((String)"NAA0201E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
            }
            return;
        }
        String[] queryData = null;
        try {
            queryData = LANManagerDiscovery.manualQuery(this.reqData.mnNetworkName);
        }
        catch (LocalizableException e) {
            this.response.errorMessage = e.getMessage();
            return;
        }
        finally {
            NasUtil.cifsLogOut(this.reqData.mnNetworkName);
        }
        if (queryData == null) {
            this.response.errorMessage = MessageLog.getMessage((String)"NAA0202E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
            }
            return;
        }
        Domain domain = new Domain();
        domain.domName = queryData[1];
        NasFiler filer = ExecDiscovery.newFiler(contactor.peer, this.reqData.mnNetworkName, contactor, domain);
        try {
            MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
            ExecDiscovery ed = new ExecDiscovery();
            ed.setRejectNonRoot(this.reqData.mnRejectNonRoot);
            if (!ed.contactFiler(filer, contactor.vendorID, this.reqData.mnUserid, this.reqData.mnPassword, false)) {
                this.response.errorMessage = this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
                }
                return;
            }
            if (ed.rc <= 4) {
                this.response.status = 0;
                filer.pack();
                this.reqData.mnFiler = filer;
                this.response.responseData = this.reqData;
            } else {
                this.response.errorMessage = this.getLogMessages();
            }
        }
        finally {
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnixNasServer() {
        Contactor contactor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"addUnixNasServer", (String)"");
        }
        if ((contactor = this.contactFiler()) == null) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
            return;
        }
        String serverName = contactor.peer.name;
        contactor = null;
        Computer dummy = new Computer();
        ImportManager thing = new ImportManager(dummy, null, this.reqData.mnCommunities, this.reqData.mnRejectNonRoot);
        Mounts mounts = new Mounts();
        try {
            MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
            if (this.handleMounts(thing, mounts) > 4) {
                this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
                }
                return;
            }
            if (Agent.hardwareID.osType == 6) {
                thing.enterAutomountMode();
                mounts = new AutoMounts();
                if (this.handleMounts(thing, mounts) > 4) {
                    this.getLogMessages();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
                    }
                    return;
                }
            }
        }
        finally {
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        }
        if (dummy.cmpNasFiler == null) {
            this.getLogMessages();
            return;
        }
        int sCount = 0;
        StringBuffer buf = new StringBuffer();
        NasFiler work = dummy.cmpNasFiler;
        while (work != null) {
            if (work.nfName.compareToIgnoreCase(serverName) == 0) {
                work.nfNext = null;
                work.pack();
                this.reqData.mnFiler = work;
                this.response.status = 0;
                this.response.responseData = this.reqData;
                break;
            }
            if (sCount < 3) {
                buf.append(work.nfNetworkName);
                buf.append('\n');
                sCount = (short)(sCount + 1);
            }
            work = work.nfNext;
        }
        if (this.reqData.mnFiler == null) {
            this.response.errorMessage = MessageLog.getMessage((String)"NAA0205E", (Object)this.reqData.mnNetworkName, (Object)Agent.localName, (Object)buf.toString());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
        }
    }

    private int handleMounts(ImportManager thing, Mounts mounts) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"handleMounts", (String)"thing, mounts");
        }
        int rc = 0;
        if (!mounts.openMnttab()) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"handleMounts", (int)8);
            }
            return 8;
        }
        while (rc <= 4 && mounts.nextMount()) {
            int tRC;
            if (mounts.type == null || !mounts.type.startsWith("nfs") || (tRC = thing.handleImport(mounts, this.reqData.mnNetworkName)) <= 4) continue;
            rc = tRC;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"handleMounts", (int)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contactor contactFiler() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"contactFiler", (String)"");
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(this.reqData.mnNetworkName);
        }
        catch (UnknownHostException e) {
            this.response.errorMessage = MessageLog.getMessageWithException((String)"NAA0200E", (Exception)e, (Object)this.reqData.mnNetworkName);
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"ManNasConfigHandler", (String)"contactFiler", (Throwable)e);
            }
            return null;
        }
        NameList communities = NameList.cloneNameList((NameList)this.reqData.mnCommunities);
        SnmpPeer peer = new SnmpPeer(this.reqData.mnNetworkName, addr);
        Contactor contactor = new Contactor(peer, null, communities, false);
        try {
            MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
            if (contactor.contact() == null || contactor.rc > 4) {
                this.response.errorMessage = this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"contactFiler");
                }
                Contactor contactor2 = null;
                return contactor2;
            }
        }
        finally {
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"contactFiler", (boolean)true);
        }
        return contactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNetwareServer() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"addNetwareServer", (String)"");
        }
        if (!NetWareLoader.loadNetWare(true)) {
            this.response.errorMessage = MessageLog.getMessage((String)"STA0247E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer", (Object)"");
            }
            return;
        }
        LdapTree[] myLdap = new LdapTree[]{this.reqData.mnLdapTree};
        NetWareDiscovery netDisc = new NetWareDiscovery(myLdap);
        DiscoveryData netWareResults = null;
        try {
            MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
            netWareResults = netDisc.go(this.reqData.mnNetworkName);
            if (netDisc.rc > 4) {
                this.response.errorMessage = this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer", (Object)"");
                }
                return;
            }
        }
        finally {
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        }
        this.response.status = 0;
        NasFiler filer = netWareResults.ddNasFiler;
        filer.pack();
        this.reqData.mnFiler = filer;
        this.response.responseData = this.reqData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer");
        }
    }

    private String getLogMessages() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"getLogMessages", (String)"");
        }
        StringBuffer buf = new StringBuffer();
        this.myPrintWriter.flush();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.tempFile));
            while ((line = br.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"getLogMessages");
        }
        return buf.toString();
    }

    private void delTempFile() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"delTempFile", (String)"");
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"delTempFile");
        }
    }

    private void getNasVendor() {
        NameList vendors;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"getNasVendor", (String)"");
        }
        NameList work = vendors = NasUtil.parseVendorArray(this.reqData.mnNasVendors);
        while (work != null) {
            if (work.nlID == this.reqData.mnFiler.nfVendorID) {
                this.reqData.mnFiler.nfManufacturer = work.nlName;
                break;
            }
            work = work.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"getNasVendor");
        }
    }

    static {
        new ExecProbe();
    }
}

