/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AbstractScriptHandler
implements IAgentRequestHandler {
    public static final String HEADER_LINE = "--------------------- BEGIN OUTPUT ---------------------";
    private static File scriptsDir = new File(JobUtil.scriptsDir);

    public abstract IAssignable makeRunner(RunScriptReq var1, String var2, PrintWriter var3, boolean var4);

    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AbstractScriptHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (!RequestChecker.isDesiredType(RunScriptReq.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"handle");
            }
            return;
        }
        if (!AuthChecker.check(request, response, connection)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"handle");
            }
            return;
        }
        RunScriptReq requestData = (RunScriptReq)request.requestData;
        String logFileName = JobUtils.generateLogFileName((RunReq)requestData, (String)Agent.logFileDirectory);
        FileWriter raw = null;
        try {
            raw = new FileWriter(logFileName);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AbstractScriptHandler.class.getName(), (String)"handle", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)e);
        }
        if (raw != null) {
            PrintWriter logFile = new PrintWriter((Writer)raw, true);
            IAssignable task = this.makeRunner(requestData, logFileName, logFile, true);
            Agent.breadLine.assign(task);
            response.status = 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"handle");
        }
    }

    public static File writeTempFile(String prefix, String ext, byte[] body) {
        File result;
        block18: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", (String)"prefix, ext, body");
            }
            result = null;
            File temp = null;
            try {
                temp = File.createTempFile(prefix, ext, scriptsDir);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
            }
            if (temp != null) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(temp);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", (Throwable)e);
                    }
                    MessageLog.logException((String)"GEN0036E", (Exception)e);
                }
                if (out != null) {
                    boolean triedClose = false;
                    try {
                        if (Agent.isWindows || body.length <= 2 || body[0] != 35 || body[1] != 33) {
                            ((OutputStream)out).write(body);
                        } else {
                            AbstractScriptHandler.stripCarriageReturns(out, body);
                        }
                        triedClose = true;
                        ((OutputStream)out).close();
                        result = temp;
                    }
                    catch (IOException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", (Throwable)e);
                        }
                        MessageLog.logMessage((String)"AGT0114E", (Object)temp.getPath(), (Object)e.getMessage());
                    }
                    if (!triedClose) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException ignored) {
                            if (!TraceLogger.enableTrace) break block18;
                            TraceLogger.exception((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", (Throwable)ignored);
                        }
                    }
                }
            }
        }
        File traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"writeTempFile", traceResult);
        }
        return traceResult;
    }

    public static String[] makeMoreTempFiles(RunScriptReq requestData, String tempScriptFile, boolean purge) throws GeneralException {
        File file;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AbstractScriptHandler.class.getName(), (String)"makeMoreTempFiles", (String)"requestData, tempScriptFile, purge");
        }
        if (purge) {
            JobUtil.purgeLogFiles((RunReq)requestData, (String)Agent.logFileDirectory);
        }
        int start = tempScriptFile != null ? 1 : 0;
        int nTempFiles = 0;
        if (requestData.scrData != null) {
            nTempFiles = requestData.scrData.length - 1;
        }
        int length = start + nTempFiles;
        String[] result = new String[length];
        if (tempScriptFile != null) {
            result[0] = tempScriptFile;
        }
        boolean good = true;
        int i = 0;
        while (good && i < nTempFiles) {
            file = AbstractScriptHandler.writeTempFile("DAT", null, requestData.scrData[i + 1]);
            if (file == null) {
                good = false;
                continue;
            }
            result[start + i] = file.getName();
            ++i;
        }
        requestData.scrData = null;
        if (!good) {
            for (i = 0; i < length && result[i] != null; ++i) {
                file = new File(scriptsDir, result[i]);
                file.delete();
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"makeMoreTempFiles");
            }
            throw new GeneralException();
        }
        if (nTempFiles > 0) {
            length = requestData.scrArgv.length;
            String[] newArgv = new String[length + nTempFiles];
            System.arraycopy(requestData.scrArgv, 0, newArgv, 0, length);
            System.arraycopy(result, start, newArgv, length, nTempFiles);
            requestData.scrArgv = newArgv;
        }
        String[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"makeMoreTempFiles", (Object)traceResult);
        }
        return traceResult;
    }

    private static void stripCarriageReturns(OutputStream out, byte[] body) throws IOException {
        int lengthToWrite;
        int offset;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AbstractScriptHandler.class.getName(), (String)"stripCarriageReturns", (String)"out, body");
        }
        int start = 0;
        for (offset = 0; offset < body.length; ++offset) {
            if (body[offset] != 13) continue;
            lengthToWrite = offset - start;
            if (lengthToWrite > 0) {
                out.write(body, start, lengthToWrite);
            }
            start = offset + 1;
        }
        lengthToWrite = offset - start;
        if (lengthToWrite > 0) {
            out.write(body, start, lengthToWrite);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AbstractScriptHandler.class.getName(), (String)"stripCarriageReturns");
        }
    }

    public static File getScriptsDir() {
        return scriptsDir;
    }
}

