/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.agent.probe.HBAAPIWWN;
import org.eclipse.aperi.xmsg.LocalizableException;

public class WWNviaHBAAPI {
    private List libraries;
    private HBAAPIWWN queried;
    private static final String lib64_1 = File.separator + "64";
    private static final String lib64_2 = "64" + File.separator;

    private void addLibrary(String library) {
        if (library.indexOf(lib64_1) > 0) {
            return;
        }
        if (library.indexOf(lib64_2) > 0) {
            return;
        }
        if (library.endsWith("64.so")) {
            return;
        }
        Iterator iterator = this.libraries.iterator();
        while (iterator.hasNext()) {
            String old = iterator.next().toString();
            if (old.compareTo(library) != 0) continue;
            return;
        }
        this.libraries.add(library);
    }

    private void addWWN(long wwn, int busNumber, String osPath) {
        HBAAPIWWN structure = new HBAAPIWWN();
        structure.wwName = wwn;
        structure.wwBusNumber = busNumber;
        structure.wwOSPath = osPath;
        structure.wwNext = this.queried;
        this.queried = structure;
    }

    private native void findLibraries() throws LocalizableException;

    private native void enumHBAs(String var1) throws LocalizableException;

    public HBAAPIWWN findWWNs() throws LocalizableException {
        this.libraries = new LinkedList();
        this.findLibraries();
        boolean allFailed = true;
        LocalizableException exception = null;
        Iterator iterator = this.libraries.iterator();
        while (iterator.hasNext()) {
            String library = iterator.next().toString();
            try {
                this.enumHBAs(library);
                allFailed = false;
            }
            catch (LocalizableException e) {
                if (exception != null) {
                    exception.print();
                }
                exception = e;
            }
        }
        HBAAPIWWN result = this.queried;
        this.libraries = null;
        this.queried = null;
        if (exception != null) {
            if (allFailed) {
                throw exception;
            }
            exception.print();
        }
        return result;
    }

    private static native void initIDs();

    static {
        WWNviaHBAAPI.initIDs();
    }
}

