/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.reporter;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.aperi.agent.reporter.IReporter;
import org.eclipse.aperi.agent.reporter.SendResult;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.HostAndPort;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.req.AgentRegReq;
import org.eclipse.aperi.server.req.AgentStateReq;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class Reporter
implements Runnable,
IReporter {
    private HostAndPort server;
    private LinkedList outgoing;
    private Request oldRequest;
    private JobRun jobRun;
    private boolean running;
    private boolean shutdownRequested;
    private Object mutexForShutdown;
    private int napLength;

    public HostAndPort getServer() {
        return this.server;
    }

    public int getNapLength() {
        return this.napLength;
    }

    public void setNapLength(int pNapLength) {
        this.napLength = pNapLength;
    }

    public void setServer(HostAndPort pServer) {
        this.server = pServer;
    }

    public boolean isBacklogged() {
        boolean backlogged = false;
        if (this.outgoing.size() > Agent.maxBacklog) {
            backlogged = true;
        }
        return backlogged;
    }

    public synchronized void addUnreported(Set unreported) {
        for (Request unreportedReq : this.outgoing) {
            this.addUnreported(unreported, unreportedReq);
        }
        if (this.oldRequest != null) {
            this.addUnreported(unreported, this.oldRequest);
        }
    }

    private void addUnreported(Set set, Request unreportedReq) {
        Serializable unreportedData = unreportedReq.requestData;
        if (unreportedData instanceof StartedJob) {
            StartedJob startedJob = (StartedJob)unreportedData;
            if (startedJob.getJobRun() == null) {
                startedJob.setJobRun(this.jobRun);
            }
            set.add(startedJob);
        }
    }

    public synchronized void add(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"add", (String)"request");
        }
        this.outgoing.addLast(request);
        this.notify();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"add");
        }
    }

    private synchronized void addHiPri(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"addHiPri", (String)"request");
        }
        this.outgoing.addFirst(request);
        this.shutdownRequested = true;
        this.notify();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"addHiPri");
        }
    }

    private String saveFileName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"saveFileName", (String)"");
        }
        String traceResult = Variables.homeDirectory + File.separator + "UNSENT." + Agent.localName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"saveFileName", (Object)traceResult);
        }
        return traceResult;
    }

    private Request createRegistration() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"createRegistration", (String)"");
        }
        CheckedRequest request = Agent.makeCheckedRequest();
        TimeZone tZone = TimeZone.getDefault();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.AgentRegHndlr";
        request.machineName = Agent.localName;
        request.userName = null;
        request.flags = 0;
        AgentRegReq requestData = new AgentRegReq();
        requestData.hwID = Agent.hardwareID;
        requestData.newLogDir = Agent.logFileDirectory;
        requestData.timezone = tZone.getID().indexOf("Custom") == -1 ? TimeZone.getDefault().getID() : tZone.getDisplayName(tZone.useDaylightTime(), 0);
        requestData.port = Agent.listeningPort;
        requestData.installedProducts = Agent.installedProducts;
        requestData.guidO = Agent.guidO;
        requestData.featureSet = 0;
        requestData.networkName = Agent.networkName;
        request.requestData = requestData;
        CheckedRequest traceResult = request;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"createRegistration", (Object)traceResult);
        }
        return traceResult;
    }

    public void queueRegistration() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"queueRegistration", (String)"");
        }
        Request request = this.createRegistration();
        this.add(request);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"queueRegistration");
        }
    }

    public Reporter(HostAndPort pServer, int pNapLength) {
        Request request;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"Reporter", (String)"pServer, pNapLength");
        }
        this.oldRequest = null;
        this.jobRun = null;
        this.server = pServer;
        this.napLength = pNapLength;
        this.mutexForShutdown = new Object();
        String unsentName = this.saveFileName();
        File unsentFile = new File(unsentName);
        this.outgoing = null;
        if (unsentFile.canRead()) {
            block37: {
                FileInputStream raw = null;
                ObjectInputStream cooked = null;
                try {
                    raw = new FileInputStream(unsentName);
                }
                catch (FileNotFoundException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                    }
                    MessageLog.logException((String)"GEN0029E", (Exception)e);
                }
                if (raw != null) {
                    try {
                        cooked = new ObjectInputStream(raw);
                    }
                    catch (ObjectStreamException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0036W", (Exception)e, (Object)unsentName);
                    }
                    catch (IOException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0035W", (Exception)e, (Object)unsentName);
                    }
                }
                if (cooked == null) {
                    if (raw != null) {
                        try {
                            ((InputStream)raw).close();
                        }
                        catch (IOException e) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                            }
                        }
                    }
                } else {
                    try {
                        this.outgoing = (LinkedList)cooked.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logMessage((String)"AGT0038W", (Object)e.getMessage(), (Object)unsentName);
                    }
                    catch (ObjectStreamException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0036W", (Exception)e, (Object)unsentName);
                    }
                    catch (EOFException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0037W", (Exception)e, (Object)unsentName);
                    }
                    catch (IOException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0035W", (Exception)e, (Object)unsentName);
                    }
                    catch (ClassCastException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                        }
                        MessageLog.logException((String)"AGT0039W", (Exception)e, (Object)unsentName, (Object)"LinkedList");
                    }
                    try {
                        cooked.close();
                    }
                    catch (IOException e) {
                        if (!TraceLogger.enableTrace) break block37;
                        TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                    }
                }
            }
            unsentFile.delete();
        }
        if (this.outgoing == null) {
            this.outgoing = new LinkedList();
        } else {
            Iterator iterator = this.outgoing.iterator();
            Object o = null;
            while (iterator.hasNext()) {
                try {
                    o = iterator.next();
                    request = o;
                    if (!request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") || !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentRegHndlr") && !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentStateHndlr")) continue;
                    iterator.remove();
                }
                catch (ClassCastException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Reporter.class.getName(), (String)"Reporter", (Throwable)e);
                    }
                    iterator.remove();
                }
            }
        }
        request = this.createRegistration();
        this.outgoing.addFirst(request);
        this.running = true;
        this.shutdownRequested = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"Reporter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean quick) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"shutdown", (String)"quick");
        }
        Request request = new Request();
        request.machineName = Agent.localName;
        request.userName = null;
        ServerRequest.agentState((Request)request, null, (byte)0);
        if (quick) {
            request.flags = (byte)(request.flags | 1);
        }
        this.addHiPri(request);
        Object object = this.mutexForShutdown;
        synchronized (object) {
            while (this.running) {
                try {
                    this.mutexForShutdown.wait();
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"shutdown", (Throwable)e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"shutdown");
        }
    }

    public Response sendRequest(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendRequest", (String)"request");
        }
        Response traceResult = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendRequest", (Object)traceResult);
        }
        return traceResult;
    }

    public Response sendRequest(Request request, byte retryLevel) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendRequest", (String)"request, retryLevel");
        }
        Response traceResult = this.sendRequest(request, retryLevel, Agent.patienceWithServer);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendRequest", (Object)traceResult);
        }
        return traceResult;
    }

    public Response sendRequest(Request request, byte retryLevel, int timeoutInSeconds) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendRequest", (String)"request, retryLevel, timeoutInSeconds");
        }
        SendResult result = new SendResult();
        this.sendWithResult(request, retryLevel, timeoutInSeconds, result);
        if (result.zrTransceiver != null) {
            result.zrTransceiver.close();
        }
        Response traceResult = result.zrResponse;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendRequest", (Object)traceResult);
        }
        return traceResult;
    }

    public void sendWithResult(Request request, byte retryLevel, int timeoutInSeconds, SendResult result) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendWithResult", (String)"request, retryLevel, timeoutInSeconds, result");
        }
        result.zrTransceiver = null;
        result.zrResponse = null;
        do {
            HostAndPort remote = this.server;
            Socket connection = null;
            response = null;
            try {
                connection = SocketRegistry.connect((String)remote.host, (int)remote.port);
            }
            catch (UnknownHostException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"sendWithResult", (Throwable)e);
                }
                MessageLog.logMessage((String)"GEN0039E", (Object)e.getMessage());
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Reporter.class.getName(), (String)"sendWithResult");
                }
                return;
            }
            SocketTransceiver transceiver = null;
            if (connection != null) {
                transceiver = new SocketTransceiver(connection, remote.host, timeoutInSeconds);
                if ((request.flags & 2) == 0) {
                    response = transceiver.transmitRequest(request, null);
                } else {
                    Serializable requestData = request.requestData;
                    request.requestData = null;
                    response = transceiver.transmitRequest(request, (Object)requestData);
                    request.requestData = requestData;
                }
            }
            if (response != null && response.status <= 4) {
                result.zrTransceiver = transceiver;
            } else if (transceiver != null) {
                transceiver.close();
            }
            if (response != null ? (response.status != 8 || retryLevel < 1) && (response.status != 24 || retryLevel != 2) : retryLevel < 2) break;
        } while (this.waitToResend());
        result.zrResponse = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendWithResult");
        }
    }

    private boolean waitToResend() {
        boolean traceResult;
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Reporter.class.getName(), (String)"waitToResend", (String)"");
            }
            if (Agent.state == 1) {
                try {
                    Thread.sleep(Agent.sendFailWait * 1000);
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"waitToResend", (Throwable)e);
                }
            }
        }
        boolean bl = traceResult = Agent.state == 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"waitToResend", (boolean)traceResult);
        }
        return traceResult;
    }

    private Response sendRequestOptimized(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendRequestOptimized", (String)"request");
        }
        if (!(request.requestData instanceof StartedJob)) {
            Response traceResult = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Reporter.class.getName(), (String)"sendRequestOptimized", (Object)traceResult);
            }
            return traceResult;
        }
        StartedJob job = (StartedJob)request.requestData;
        this.jobRun = job.getJobRun();
        job.setJobRun(null);
        Response response = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
        job.setJobRun(this.jobRun);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendRequestOptimized", (Object)traceResult);
        }
        return traceResult;
    }

    public boolean sendNoWaitRequest(Request request) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"sendNoWaitRequest", (String)"request");
        }
        HostAndPort remote = this.server;
        Socket connection = null;
        boolean result = false;
        try {
            connection = SocketRegistry.connect((String)remote.host, (int)remote.port);
        }
        catch (UnknownHostException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Reporter.class.getName(), (String)"sendNoWaitRequest", (Throwable)e);
            }
            boolean traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Reporter.class.getName(), (String)"sendNoWaitRequest", (boolean)traceResult);
            }
            return traceResult;
        }
        if (connection != null) {
            SocketTransceiver transceiver = new SocketTransceiver(connection, remote.host);
            transceiver.writeObject((Object)request, -1);
            transceiver.close();
            result = true;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"sendNoWaitRequest", (boolean)traceResult);
        }
        return traceResult;
    }

    private synchronized void save() {
        boolean written;
        String unsentName;
        block18: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Reporter.class.getName(), (String)"save", (String)"");
            }
            if (this.outgoing.size() <= 0) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Reporter.class.getName(), (String)"save");
                }
                return;
            }
            unsentName = this.saveFileName();
            FileOutputStream raw = null;
            try {
                raw = new FileOutputStream(unsentName);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"save", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Reporter.class.getName(), (String)"save");
                }
                return;
            }
            written = false;
            ObjectOutputStream cooked = null;
            try {
                cooked = new ObjectOutputStream(raw);
                cooked.writeObject(this.outgoing);
                written = true;
            }
            catch (ObjectStreamException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"save", (Throwable)e);
                }
                MessageLog.logException((String)"AGT0043E", (Exception)e, (Object)unsentName);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Reporter.class.getName(), (String)"save", (Throwable)e);
                }
                MessageLog.logException((String)"AGT0042E", (Exception)e, (Object)unsentName);
            }
            if (cooked != null) {
                try {
                    cooked.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Reporter.class.getName(), (String)"save", (Throwable)e);
                    }
                    if (!written) break block18;
                    MessageLog.logException((String)"AGT0042E", (Exception)e, (Object)unsentName);
                    written = false;
                }
            }
        }
        if (!written) {
            File unsentFile = new File(unsentName);
            unsentFile.delete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistration(Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"handleRegistration", (String)"response");
        }
        AgentRequestData data = (AgentRequestData)response.responseData;
        if (ComputerID.cachedCID != null) {
            ComputerID.cachedCID.computerID = data.getComputerID();
        } else {
            ComputerID.cachedCID = new ComputerID(data.getComputerID());
            if (data.getServerToken() != Agent.serverToken) {
                if (Agent.serverToken != 0L) {
                    MessageLog.logMessage((String)"AGT0106I");
                    Reporter reporter = this;
                    synchronized (reporter) {
                        this.outgoing.clear();
                    }
                }
                Agent.serverToken = data.getServerToken();
                Agent.writeToken();
            }
        }
        MessageLog.logMessage((String)"AGT0003I");
        Agent.registered();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"handleRegistration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Reporter.class.getName(), (String)"run", (String)"");
        }
        Request request = null;
        Response response = null;
        boolean isShutdown = false;
        while (true) {
            object = this;
            synchronized (object) {
                if (this.outgoing.size() == 0 && this.oldRequest != null) {
                    request = this.oldRequest;
                } else {
                    while (this.outgoing.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            if (!TraceLogger.enableTrace) continue;
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"run", (Throwable)e);
                        }
                    }
                    request = (Request)this.outgoing.getFirst();
                    boolean bl = isShutdown = request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") && request.subType.equals("org.eclipse.aperi.server.handler.server.AgentStateHndlr");
                    if (this.oldRequest == null || isShutdown) {
                        this.outgoing.removeFirst();
                    } else {
                        request = this.oldRequest;
                    }
                }
            }
            if (isShutdown) {
                if (this.oldRequest != null) {
                    this.addHiPri(this.oldRequest);
                    this.oldRequest = null;
                }
                ComputerID computerID = ComputerID.cachedCID;
                if ((request.flags & 1) != 0 || computerID == null) break;
                AgentStateReq requestData = (AgentStateReq)request.requestData;
                requestData.computerID = computerID;
                this.sendRequest(request, (byte)0, 300);
                break;
            }
            this.oldRequest = request;
            response = this.sendRequestOptimized(request);
            if (response != null && response.status <= 4) {
                this.oldRequest = null;
                if (!request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") || !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentRegHndlr")) continue;
                this.handleRegistration(response);
                continue;
            }
            object = this;
            synchronized (object) {
                block26: {
                    if (!this.shutdownRequested) {
                        try {
                            this.wait(1000L * (long)this.napLength);
                        }
                        catch (InterruptedException e) {
                            if (!TraceLogger.enableTrace) break block26;
                            TraceLogger.exception((String)Reporter.class.getName(), (String)"run", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (Agent.shutdownMode != 3) {
            this.save();
        }
        object = this.mutexForShutdown;
        synchronized (object) {
            this.running = false;
            this.mutexForShutdown.notify();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Reporter.class.getName(), (String)"run");
        }
    }
}

