/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.svp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.cluster.mscs.MSCSEventListener;
import org.eclipse.aperi.agent.handler.job.JavaJobRestart;
import org.eclipse.aperi.agent.handler.job.JobManager;
import org.eclipse.aperi.agent.probe.IPoller;
import org.eclipse.aperi.agent.probe.InitialProbe;
import org.eclipse.aperi.agent.probe.UpTime;
import org.eclipse.aperi.agent.reporter.Reporter;
import org.eclipse.aperi.agent.req.HostAndPort;
import org.eclipse.aperi.agent.worker.BreadLine;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.ConfigParser;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.identity.SingleInstance;
import org.eclipse.aperi.identity.SuperUser;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.NativeLogManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.osgi.framework.BundleException;

public class Agent {
    public static BreadLine breadLine = null;
    public static String logFileDirectory = null;
    public static JobManager jobManager = new JobManager();
    public static Reporter reporter = null;
    public static MSCSEventListener clsEventListener = null;
    public static String localName = null;
    public static String realLocalName = null;
    public static HardwareID hardwareID = null;
    public static byte[] fakeHardwareID = null;
    public static byte[] trueHardwareID;
    public static GUID guidO;
    public static int listeningPort;
    public static int maxBacklog;
    public static int upTimePoll;
    public static ConfigParser parser;
    public static String networkName;
    public static long started;
    public static long systemBoot;
    public static long serverToken;
    public static byte shutdownMode;
    public static boolean isWindows;
    public static boolean isMSCSNode;
    public static String domain;
    public static boolean isDomainController;
    public static IPoller upTimePoller;
    public static boolean needProbe;
    public static SoftwareVersion[] installedProducts;
    public static boolean honorSentScripts;
    public static int windowsScanOption;
    public static final byte RUNNING = 1;
    public static final byte SHUTTING_DOWN = 2;
    public static final byte DOWN = 3;
    public static byte state;
    public static ThreadGroup threadGroup;
    public static final int CFG_SERVER_HOST = 1;
    public static final int CFG_SERVER_PORT = 2;
    public static final int CFG_MAX_LOG_MSGS = 3;
    public static final int CFG_MAX_BACKLOG = 4;
    public static final int CFG_SENDFAILWAIT = 5;
    public static final int CFG_PATIENCE = 6;
    public static final int CFG_MAX_IDLE_THR = 7;
    public static final int CFG_AGENT_ALIAS = 8;
    public static final int CFG_HONORSENTSCRIPTS = 9;
    public static final int CFG_LOGS_KEPT = 10;
    public static final int CFG_UPTIME_POLL = 11;
    public static final int CFG_SYMAPI_DB = 12;
    public static final int CFG_NETWORK_NAME = 13;
    public static final int CFG_HARDWARE_ID = 14;
    public static final int CFG_SCAN_OPTION = 15;
    public static final int CFG_VARIABLES = 16;
    public static final int DFT_MAX_LOG_MSGS = 100000;
    public static final int DFT_MAX_BACKLOG = 50;
    public static final int DFT_SENDFAILWAIT = 180;
    public static final int DFT_PATIENCE = 240;
    public static final int DFT_MAX_IDLE_THR = 6;
    public static final int DFT_LOGS_KEPT = 5;
    public static final int DFT_UPTIME_POLL = 120;
    public static final int DFT_SCAN_OPTION = 1;
    public static String[][] configParams;
    public static final String PROBE_ME = "PROBE_ME";
    private static final int LOGFILE_ERROR = 8;
    private static final int CONFIGFILE_ERROR = 12;
    private static final int UNCAUGHT_EXCEPTION = 16;
    private static final int NO_WORKING_DIRECTORY = 24;
    private static final int CREATE_LOGDIR_FAIL = 28;
    private static final int INITIALIZATION_FAIL = 32;
    public static final int LOCAL_HOSTNAME_FAIL = 36;
    private static final int SET_DIRPERMS_FAIL = 40;
    private static final int ANOTHER_AGENT_UP = 44;
    private static final int NOT_SUPER_USER = 48;
    private static final int SYSCALL_FAIL = 52;
    public static final int LOAD_LIBRARY_FAIL = 64;
    public static final int CANT_GET_BOOT_TIME = 68;
    public static HostAndPort server;
    public static int sendFailWait;
    public static int patienceWithServer;
    private static int workerPoolSize;
    private static CurtailedWriter output;
    private static boolean isFreshStart;
    public static boolean stopNow;
    private static int returnCode;
    static int listeningPortFromConfig;

    public static boolean booleanCfgParm(String s) {
        char c = Character.toUpperCase(s.charAt(0));
        return c == '1' || c == 'T' || c == 'Y';
    }

    private static native boolean initialize();

    private static native void setSymAPIDB(String var0);

    private static native long getBootTime();

    public static native boolean kill(StartedJob var0, int var1) throws LocalizableException;

    private static native int getCPUInfo();

    private static native int resolvePortPrimitive(String var0);

    private static native void setPermissions(String var0) throws LocalizableException;

    private static native boolean isClusteredNode();

    private static native void setNativeStopNow(boolean var0);

    public static void setStopNow(boolean pStopNow) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"setStopNow", (String)"pStopNow");
        }
        stopNow = pStopNow;
        Agent.setNativeStopNow(pStopNow);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"setStopNow");
        }
    }

    public static int resolvePort(String[] keyValue) {
        int result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"resolvePort", (String)"keyValue");
        }
        if ((result = Agent.resolvePortPrimitive(keyValue[1])) <= 0) {
            MessageLog.logMessage((String)"AGT0047E", (Object)keyValue[0]);
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"resolvePort", (int)traceResult);
        }
        return traceResult;
    }

    public static int intCfgValue(String[] keyValue, int dft) {
        int result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"intCfgValue", (String)"keyValue, dft");
        }
        try {
            result = Integer.parseInt(keyValue[1]);
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Agent.class.getName(), (String)"intCfgValue", (Throwable)e);
            }
            keyValue[1] = String.valueOf(dft);
            MessageLog.logMessage((String)"AGT0046W", (Object)keyValue[0], (Object)keyValue[1]);
            result = dft;
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"intCfgValue", (int)traceResult);
        }
        return traceResult;
    }

    public static int getPatience(String[][] params) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"getPatience", (String)"params");
        }
        int minutes = params[6][1] == null ? 240 : Agent.intCfgValue(params[6], 240);
        int traceResult = minutes * 60;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"getPatience", (int)traceResult);
        }
        return traceResult;
    }

    public static int getNCPUs() {
        return Agent.getCPUInfo() & 0xFFFF;
    }

    private static String tokenFileName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"tokenFileName", (String)"");
        }
        String traceResult = Variables.homeDirectory + File.separator + "SERVER.ID";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"tokenFileName", (Object)traceResult);
        }
        return traceResult;
    }

    private static void readToken() {
        block13: {
            String line;
            block12: {
                BufferedReader in;
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Agent.class.getName(), (String)"readToken", (String)"");
                }
                serverToken = 0L;
                try {
                    in = new BufferedReader(new FileReader(Agent.tokenFileName()));
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Agent.class.getName(), (String)"readToken", (Throwable)e);
                    }
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)Agent.class.getName(), (String)"readToken");
                    }
                    return;
                }
                line = null;
                try {
                    line = in.readLine();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception((String)Agent.class.getName(), (String)"readToken", (Throwable)e);
                }
            }
            if (line == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Agent.class.getName(), (String)"readToken");
                }
                return;
            }
            try {
                serverToken = Long.parseLong(line);
            }
            catch (NumberFormatException e) {
                if (!TraceLogger.enableTrace) break block13;
                TraceLogger.exception((String)Agent.class.getName(), (String)"readToken", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"readToken");
        }
    }

    public static void writeToken() {
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Agent.class.getName(), (String)"writeToken", (String)"");
            }
            String fileName = Agent.tokenFileName();
            boolean created = false;
            try {
                FileWriter writer = new FileWriter(fileName);
                created = true;
                SuperUser.adminAccessOnly((String)fileName);
                writer.write(Long.toString(serverToken));
                ((Writer)writer).close();
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Agent.class.getName(), (String)"writeToken", (Throwable)e);
                }
                if (created) {
                    File file = new File(fileName);
                    file.delete();
                }
                if (!(e instanceof LocalizableException)) break block6;
                LocalizableException ex = (LocalizableException)((Object)e);
                ex.print();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"writeToken");
        }
    }

    private static SoftwareVersion[] getInstalledProducts() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"getInstalledProducts", (String)"");
        }
        SoftwareVersion[] result = new SoftwareVersion[10];
        result[0] = new SoftwareVersion(5, 0, 0, 0, SoftwareVersion.getVendor());
        SoftwareVersion[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"getInstalledProducts", (Object)traceResult);
        }
        return traceResult;
    }

    public static void registered() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"registered", (String)"");
        }
        if (needProbe) {
            InitialProbe task = new InitialProbe();
            breadLine.assign(task);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"registered");
        }
    }

    public static CheckedRequest makeCheckedRequest() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"makeCheckedRequest", (String)"");
        }
        CheckedRequest result = new CheckedRequest();
        result.productCode = 1;
        int cpuInfo = Agent.getCPUInfo();
        result.processorType = (byte)(cpuInfo >> 16);
        result.numberProcessors = (short)(cpuInfo & 0xFFFF);
        result.computerID = ComputerID.cachedCID == null ? -1 : ComputerID.cachedCID.computerID;
        CheckedRequest traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"makeCheckedRequest", (Object)traceResult);
        }
        return traceResult;
    }

    public static void makeFakeHardwareID(String fromConfigFile) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"makeFakeHardwareID", (String)"fromConfigFile");
        }
        if (fromConfigFile == null) {
            fakeHardwareID = null;
        } else {
            String s = "FAKE_" + fromConfigFile;
            fakeHardwareID = s.getBytes();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"makeFakeHardwareID");
        }
    }

    public static void parseConfigFile() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"parseConfigFile", (String)"");
        }
        String name = Variables.homeDirectory + File.separator + "configuration" + File.separator + "agent.config";
        parser = new ConfigParser(name);
        try {
            parser.readValues(configParams);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Agent.class.getName(), (String)"parseConfigFile", (Throwable)e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Agent.class.getName(), (String)"parseConfigFile");
            }
            throw new LocalizableException("GEN0029E", null);
        }
        int logsKept = Agent.intCfgValue(configParams[10], 5);
        int messagesPerLog = Agent.intCfgValue(configParams[3], 100000);
        if (output != null) {
            output.setParms(logsKept, messagesPerLog);
        }
        server = new HostAndPort();
        Agent.server.port = Agent.resolvePort(configParams[2]);
        if (Agent.server.port <= 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Agent.class.getName(), (String)"parseConfigFile");
            }
            throw new LocalizableException(null, null);
        }
        Agent.server.host = configParams[1][1];
        if (Agent.server.host == null) {
            Object[] parms = new Object[]{configParams[1][0]};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Agent.class.getName(), (String)"parseConfigFile");
            }
            throw new LocalizableException("AGT0048E", parms);
        }
        Variables.server = Agent.server.host;
        Variables.port = Agent.server.port;
        maxBacklog = Agent.intCfgValue(configParams[4], 50);
        sendFailWait = Agent.intCfgValue(configParams[5], 180);
        patienceWithServer = Agent.getPatience(configParams);
        workerPoolSize = Agent.intCfgValue(configParams[7], 6);
        if (configParams[8][1] != null) {
            localName = configParams[8][1].toLowerCase();
        }
        honorSentScripts = Agent.booleanCfgParm(configParams[9][1]);
        if (configParams[12][1] != null) {
            Agent.setSymAPIDB(configParams[12][1]);
        }
        if (configParams[13][1] != null) {
            networkName = configParams[13][1];
        }
        Agent.makeFakeHardwareID(configParams[14][1]);
        windowsScanOption = Agent.intCfgValue(configParams[15], 1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"parseConfigFile");
        }
    }

    public static void start() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"start", (String)"pAgentEnvironment");
        }
        Agent.init();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"start");
        }
    }

    private static void init() throws LocalizableException {
        TSThread thread;
        if (isFreshStart) {
            Variables.whoAmI = (byte)2;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"init", (String)"");
        }
        returnCode = 24;
        Variables.homeDirectory = Agent.getWorkingDirectory();
        JobUtil.setUpScriptsDir((String)Variables.homeDirectory);
        if (isFreshStart) {
            threadGroup = new ExitingGroup("EXITING");
            try {
                System.loadLibrary("DataAgent");
            }
            catch (Error e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Agent.class.getName(), (String)"init", (Throwable)e);
                }
                e.printStackTrace();
                returnCode = 64;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Agent.class.getName(), (String)"init");
                }
                throw new LocalizableException(null, null);
            }
        }
        returnCode = 36;
        realLocalName = localName = HardwareID.getLocalHostName();
        returnCode = 28;
        boolean mustChangePerms = false;
        logFileDirectory = Variables.homeDirectory + File.separator + "log" + File.separator + localName;
        File file = new File(logFileDirectory);
        if (!file.isDirectory()) {
            boolean found2xDir = false;
            int dotIndex = localName.indexOf(".", 0);
            if (dotIndex > 0) {
                String shortHostName = localName.substring(0, dotIndex).toLowerCase();
                File shortFile = new File(Variables.homeDirectory + File.separator + "log" + File.separator + shortHostName);
                if (shortFile.isDirectory()) {
                    logFileDirectory = Variables.homeDirectory + File.separator + "log" + File.separator + shortHostName;
                    found2xDir = true;
                }
            }
            if (!found2xDir) {
                if (!file.mkdir()) {
                    Object[] parms = new Object[]{logFileDirectory};
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)Agent.class.getName(), (String)"init");
                    }
                    throw new LocalizableException("GEN0037E", parms);
                }
                mustChangePerms = true;
            }
        }
        returnCode = 8;
        TSThread.setProperty((Object)"TSThread.key.serviceIdentity", (Object)"org.eclipse.aperi.agent.svp.AgentSvp");
        String traceConfigFile = Variables.homeDirectory + File.separator + "configuration" + File.separator + "AgentTraceLog.config";
        String traceLogFile = logFileDirectory + File.separator + "AgentTrace.log";
        TraceLoggerFactory.initializeTraceLogger((String)traceConfigFile, (String)traceLogFile);
        TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.Agent", (String)"org.eclipse.aperi.agent.svp.AgentSvp");
        try {
            output = new CurtailedWriter(logFileDirectory + File.separator + "agent", 0, 0, false);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Agent.class.getName(), (String)"init", (Throwable)e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Agent.class.getName(), (String)"init");
            }
            throw new LocalizableException(null, null);
        }
        MessageLog.setThreadLog((PrintWriter)output);
        if (isFreshStart) {
            try {
                NativeLogManager.initAgentTraceLogger((String)logFileDirectory);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Agent.class.getName(), (String)"init", (Throwable)e);
                }
                e.print();
            }
            MessageLog.initNative();
            if (!SuperUser.check()) {
                returnCode = 48;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Agent.class.getName(), (String)"init");
                }
                throw new LocalizableException(null, null);
            }
            if (!Agent.initialize()) {
                returnCode = 32;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Agent.class.getName(), (String)"init");
                }
                throw new LocalizableException(null, null);
            }
        }
        if (mustChangePerms) {
            returnCode = 40;
            Agent.setPermissions(logFileDirectory);
        }
        started = System.currentTimeMillis();
        installedProducts = Agent.getInstalledProducts();
        returnCode = 12;
        Agent.parseConfigFile();
        listeningPort = Integer.parseInt(System.getProperty("org.osgi.service.http.port"));
        returnCode = 52;
        int pid = SingleInstance.check((String)Agent.server.host, (int)Agent.server.port);
        if (pid != 0) {
            Object[] parms;
            String msgID;
            returnCode = 44;
            if (pid > 0) {
                msgID = "AGT0006E";
                parms = new Object[]{new Integer(pid)};
            } else {
                msgID = "AGT0007E";
                parms = null;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Agent.class.getName(), (String)"init");
            }
            throw new LocalizableException(msgID, parms);
        }
        hardwareID = new HardwareID(realLocalName);
        if (Agent.hardwareID.hardwareID == null) {
            hardwareID.setBogusHardwareID(localName);
        }
        trueHardwareID = Agent.hardwareID.hardwareID;
        if (fakeHardwareID != null) {
            Agent.hardwareID.hardwareID = fakeHardwareID;
        }
        if (isFreshStart) {
            guidO = GUID.readGUID();
        }
        Agent.readToken();
        if (isFreshStart) {
            systemBoot = Agent.getBootTime();
            if (systemBoot == 0L) {
                returnCode = 68;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Agent.class.getName(), (String)"init");
                }
                throw new LocalizableException("AGT0072E", null);
            }
            upTimePoll = Agent.intCfgValue(configParams[11], 120);
            upTimePoller = new UpTime();
            thread = new TSThread(threadGroup, (Runnable)upTimePoller, "Uptime Poller");
            thread.start();
            breadLine = new BreadLine(workerPoolSize);
        }
        file = new File(PROBE_ME);
        needProbe = file.exists();
        file = null;
        MessageLog.logMessage((String)"AGT0004I");
        SingleInstance.logPID();
        MessageLog.logMessage((String)"AGT0119I", (Object)installedProducts[0].toString());
        reporter = new Reporter(server, sendFailWait);
        thread = new TSThread(threadGroup, (Runnable)reporter, "Reporter");
        thread.start();
        if (isMSCSNode) {
            clsEventListener = new MSCSEventListener(realLocalName);
            TSThread clsEventThread = new TSThread(threadGroup, (Runnable)clsEventListener);
            clsEventThread.start();
        }
        JavaJobRestart.restart();
        returnCode = 0;
        isFreshStart = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"init");
        }
    }

    private static void initConfigParams() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Agent.class.getName(), (String)"initConfigParams", (String)"");
        }
        Agent.configParams[1][1] = null;
        Agent.configParams[2][1] = Integer.toString(9550);
        Agent.configParams[3][1] = Integer.toString(100000);
        Agent.configParams[4][1] = Integer.toString(50);
        Agent.configParams[5][1] = Integer.toString(180);
        Agent.configParams[6][1] = null;
        Agent.configParams[7][1] = Integer.toString(6);
        Agent.configParams[8][1] = null;
        Agent.configParams[9][1] = "1";
        Agent.configParams[10][1] = Integer.toString(5);
        Agent.configParams[11][1] = Integer.toString(120);
        Agent.configParams[12][1] = null;
        Agent.configParams[13][1] = null;
        Agent.configParams[14][1] = null;
        Agent.configParams[15][1] = String.valueOf(1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Agent.class.getName(), (String)"initConfigParams");
        }
    }

    public static void closeAgentLog() {
        output.close();
    }

    private static String getWorkingDirectory() throws LocalizableException {
        String result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"Agent", (String)"getWorkingDirectory", (String)"");
        }
        if ((result = System.getProperty("user.dir")) == null) {
            Object[] parms = new Object[]{"user.dir"};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"Agent", (String)"getWorkingDirectory");
            }
            throw new LocalizableException("GEN0041E", parms);
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"Agent", (String)"getWorkingDirectory", (Object)traceResult);
        }
        return traceResult;
    }

    public static void reset() {
        Agent.initConfigParams();
        Agent.setStopNow(false);
        SocketRegistry.activate();
        state = 1;
        shutdownMode = (byte)2;
        networkName = null;
        Agent.setSymAPIDB(null);
        jobManager = new JobManager();
        reporter = null;
        ComputerID.cachedCID = null;
        LockManager.initProductLockMaps();
    }

    static {
        guidO = null;
        parser = null;
        shutdownMode = (byte)2;
        domain = null;
        upTimePoller = null;
        state = 1;
        threadGroup = null;
        configParams = new String[][]{{"agentPort", null}, {"serverHost", null}, {"serverPort", null}, {"messagesPerLog", null}, {"maxBacklog", null}, {"sendFailWait", null}, {"patienceWithServer", null}, {"maxIdleThreads", null}, {"hostAlias", null}, {"honorSentScripts", null}, {"logFilesKept", null}, {"uptimePoll", null}, {"symAPIDB", null}, {"networkName", null}, {"hardwareID", null}, {"windowsScanOption", null}};
        output = null;
        isFreshStart = true;
        stopNow = false;
        Agent.initConfigParams();
    }

    private static class ExitingGroup
    extends ThreadGroup {
        public ExitingGroup(String name) {
            super(name);
        }

        public void uncaughtException(Thread t, Throwable e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ExitingGroup.class.getName(), (String)"uncaughtException", (String)"t, e");
            }
            super.uncaughtException(t, e);
            returnCode = 16;
            e.printStackTrace(MessageLog.getThreadLog());
            if (e instanceof Error) {
                try {
                    Activator.stopBundle(true);
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExitingGroup.class.getName(), (String)"uncaughtException");
            }
        }
    }
}

