/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.HostAndPort;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.identity.SingleInstance;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class AuthChecker {
    private static native void rename(String var0, String var1) throws LocalizableException;

    private static void writeConfigFile(Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AuthChecker.class.getName(), (String)"writeConfigFile", (String)"response");
        }
        String configFileName = Agent.parser.configFile;
        int i = configFileName.lastIndexOf(File.separatorChar);
        String configDir = configFileName.substring(0, i);
        File dirFile = new File(configDir);
        File tempFile = null;
        try {
            tempFile = File.createTempFile("CFG", null, dirFile);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AuthChecker.class.getName(), (String)"writeConfigFile", (Throwable)e);
            }
            response.status = (short)4;
            response.errorMessage = MessageLog.getMessage((String)"GEN0002E", (Object)e.getMessage());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AuthChecker.class.getName(), (String)"writeConfigFile");
            }
            return;
        }
        String tempFileName = tempFile.getPath();
        FileOutputStream raw = null;
        try {
            raw = new FileOutputStream(tempFileName);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AuthChecker.class.getName(), (String)"writeConfigFile", (Throwable)e);
            }
            response.status = (short)4;
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AuthChecker.class.getName(), (String)"writeConfigFile");
            }
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(raw));
        boolean triedClose = false;
        try {
            for (i = 0; i < Agent.configParams.length; ++i) {
                if (Agent.configParams[i][1] == null) continue;
                String line = Agent.configParams[i][0] + " = " + Agent.configParams[i][1];
                out.write(line, 0, line.length());
                out.newLine();
            }
            triedClose = true;
            out.close();
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AuthChecker.class.getName(), (String)"writeConfigFile", (Throwable)e);
            }
            response.status = (short)4;
            response.errorMessage = MessageLog.getMessageWithException((String)"AGT0042E", (Exception)e, (Object)tempFileName);
            if (!triedClose) {
                try {
                    out.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AuthChecker.class.getName(), (String)"writeConfigFile");
            }
            return;
        }
        boolean renamed = false;
        if (Agent.isWindows) {
            try {
                AuthChecker.rename(tempFileName, configFileName);
                renamed = true;
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)AuthChecker.class.getName(), (String)"writeConfigFile", (Throwable)e);
                }
                response.errorMessage = e.getMessage();
            }
        } else {
            File configFile = new File(configFileName);
            renamed = tempFile.renameTo(configFile);
            if (!renamed) {
                Object[] args = new Object[]{tempFileName, configFileName};
                response.errorMessage = MessageLog.getMessage((String)"GEN0023E", (Object[])args);
            }
        }
        if (!renamed) {
            response.status = (short)4;
            tempFile.delete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AuthChecker.class.getName(), (String)"writeConfigFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean check(Request request, Response response, Socket connection, boolean isPing) {
        boolean unregistered;
        AgentRequestData requestData;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AuthChecker.class.getName(), (String)"check", (String)"request, response, connection, isPing");
        }
        if ((requestData = (AgentRequestData)request.requestData).getServerToken() != Agent.serverToken) {
            if (ComputerID.cachedCID == null) {
                response.status = (short)12;
                response.errorMessage = MessageLog.getMessage((String)"AGT0041E", null);
            } else {
                response.status = (short)16;
                response.errorMessage = MessageLog.getMessage((String)"AGT0104E", null);
            }
            if (isPing) {
                response.responseData = Agent.reporter.getServer();
            }
            boolean traceResult = false;
            if (!TraceLogger.enableTrace) return traceResult;
            TraceLogger.exit((String)AuthChecker.class.getName(), (String)"check", (boolean)traceResult);
            return traceResult;
        }
        response.status = 0;
        boolean bl = unregistered = ComputerID.cachedCID == null;
        if (unregistered || isPing) {
            boolean portChanged;
            if (unregistered) {
                ComputerID.cachedCID = new ComputerID(requestData.getComputerID());
            } else {
                ComputerID.cachedCID.computerID = requestData.getComputerID();
            }
            InetAddress peer = connection.getInetAddress();
            HostAndPort newServer = new HostAndPort();
            newServer.host = peer.getHostName();
            newServer.port = requestData.getServerPort();
            HostAndPort oldServer = Agent.reporter.getServer();
            boolean hostChanged = !newServer.host.equalsIgnoreCase(oldServer.host);
            boolean bl2 = portChanged = newServer.port != oldServer.port;
            if (!hostChanged && !portChanged) {
                oldServer = null;
            } else {
                String[][] stringArray = Agent.configParams;
                // MONITORENTER : org.eclipse.aperi.agent.svp.Agent.configParams
                Agent.reporter.setServer(newServer);
                if (hostChanged) {
                    Agent.configParams[1][1] = newServer.host;
                }
                if (portChanged) {
                    Agent.configParams[2][1] = Integer.toString(newServer.port);
                }
                AuthChecker.writeConfigFile(response);
                SingleInstance.changed((String)newServer.host, (int)newServer.port);
                // MONITOREXIT : stringArray
                MessageLog.logMessage((String)"AGT0056I", (Object)newServer.host, (Object)new Integer(newServer.port));
            }
            if (isPing) {
                response.responseData = oldServer;
            }
        }
        boolean traceResult = true;
        if (!TraceLogger.enableTrace) return traceResult;
        TraceLogger.exit((String)AuthChecker.class.getName(), (String)"check", (boolean)traceResult);
        return traceResult;
    }

    public static boolean check(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AuthChecker.class.getName(), (String)"check", (String)"request, response, connection");
        }
        boolean traceResult = AuthChecker.check(request, response, connection, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AuthChecker.class.getName(), (String)"check", (boolean)traceResult);
        }
        return traceResult;
    }
}

