/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.worker;

import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

class Worker
implements Runnable {
    private IAssignable task;

    Worker(IAssignable pTask) {
        this.task = pTask;
    }

    Worker() {
        this(null);
    }

    public synchronized void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Worker.class.getName(), (String)"run", (String)"");
        }
        boolean going = true;
        while (going) {
            while (this.task == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)Worker.class.getName(), (String)"run", (Throwable)e);
                }
            }
            TSThread t = (TSThread)Thread.currentThread();
            TSThread.setProperty((Object)"TSThread.key.messageLog", (Object)MessageLog.getDefaultLog());
            this.task.execute();
            this.task = null;
            going = Agent.breadLine.join(this);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Worker.class.getName(), (String)"run");
        }
    }

    synchronized void dispatch(IAssignable pTask) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Worker.class.getName(), (String)"dispatch", (String)"pTask");
        }
        this.task = pTask;
        this.notify();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Worker.class.getName(), (String)"dispatch");
        }
    }
}

