/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSessionFactory;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class SessionSweeper
implements Wakeable {
    private static final int DEFAULT_INTERVAL = 1440;
    private static final int DEFAULT_IDLE_TIME = 720;
    Timer timer = TimerService.scheduleWakeUp(this.convertTime(1440), this);

    private int convertTime(int time) {
        return time * 60 * 1000;
    }

    public void wakeUp(Object o) {
        SnmpSession session;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SessionSweeper - sweeping for stale sessions");
        }
        long allowedIdleTime = this.convertTime(720);
        Hashtable sessions = SnmpSessionFactory.getSessions();
        long oldestAllowed = System.currentTimeMillis();
        oldestAllowed -= allowedIdleTime;
        Enumeration keys = sessions.keys();
        Enumeration values = sessions.elements();
        Vector<String> removeThese = new Vector<String>();
        while (keys.hasMoreElements()) {
            long lastUsed;
            String key = (String)keys.nextElement();
            session = (SnmpSession)sessions.get(key);
            if (session == null) continue;
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("SessionSweeper - working on session - " + session.toString());
            }
            if ((lastUsed = session.stats.getLastUsed()) >= oldestAllowed) continue;
            removeThese.addElement(key);
        }
        if (!removeThese.isEmpty()) {
            int count = removeThese.size();
            for (int i = 0; i < count; ++i) {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SessionSweeper - removing session - " + removeThese.elementAt(i));
                }
                session = (SnmpSession)sessions.remove((String)removeThese.elementAt(i));
                session.close();
            }
        }
    }

    public void stop() {
        TimerService.cancelWakeUp(this.timer);
    }
}

